/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.PartitionReplica;
import java.util.List;
import javax.validation.constraints.Min;

public class Partition {
    @Min(value=0L)
    private @Min(value=0L) int partition;
    @Min(value=0L)
    private @Min(value=0L) int leader;
    private List<PartitionReplica> replicas;

    public Partition() {
    }

    public Partition(@JsonProperty int partition, @JsonProperty int leader, @JsonProperty List<PartitionReplica> replicas) {
        this.partition = partition;
        this.leader = leader;
        this.replicas = replicas;
    }

    @JsonProperty
    public int getPartition() {
        return this.partition;
    }

    @JsonProperty
    public void setPartition(int partition) {
        this.partition = partition;
    }

    @JsonProperty
    public int getLeader() {
        return this.leader;
    }

    @JsonProperty
    public void setLeader(int leader) {
        this.leader = leader;
    }

    @JsonProperty
    public List<PartitionReplica> getReplicas() {
        return this.replicas;
    }

    @JsonProperty
    public void setReplicas(List<PartitionReplica> replicas) {
        this.replicas = replicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Partition)) {
            return false;
        }
        Partition partition1 = (Partition)o;
        if (this.leader != partition1.leader) {
            return false;
        }
        if (this.partition != partition1.partition) {
            return false;
        }
        return !(this.replicas != null ? !this.replicas.equals(partition1.replicas) : partition1.replicas != null);
    }

    public int hashCode() {
        int result = this.partition;
        result = 31 * result + this.leader;
        result = 31 * result + (this.replicas != null ? this.replicas.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Partition{partition=" + this.partition + ", leader=" + this.leader + ", replicas=" + this.replicas + '}';
    }
}

