/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.admin;

import io.confluent.kafka.admin.LogDirsCommand;
import io.confluent.kafka.utils.Json$;
import io.confluent.org.apache.kafka.clients.admin.AdminClient;
import io.confluent.org.apache.kafka.clients.admin.DescribeLogDirsResult;
import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.requests.DescribeLogDirsResponse;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LogDirsCommand$ {
    public static LogDirsCommand$ MODULE$;

    static {
        new LogDirsCommand$();
    }

    public void main(String[] args) {
        this.describe(args, System.out);
    }

    public void describe(String[] args, PrintStream out) {
        int[] nArray;
        LogDirsCommand.LogDirsCommandOptions opts = new LogDirsCommand.LogDirsCommandOptions(args);
        AdminClient adminClient = this.createAdminClient(opts);
        String[] topicList = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)opts.options().valueOf(opts.topicListOpt())).split(","))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogDirsCommand$.$anonfun$describe$1(x$1)));
        Option option = Option$.MODULE$.apply(opts.options().valueOf(opts.brokerListOpt()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String brokerListStr = (String)some.value();
            nArray = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(brokerListStr)).split(','))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirsCommand$.$anonfun$describe$2(x$2))))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)LogDirsCommand$.$anonfun$describe$3(x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (None$.MODULE$.equals(option)) {
            nArray = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(adminClient.describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        } else {
            throw new MatchError((Object)option);
        }
        int[] brokerList = nArray;
        out.println("Querying brokers for log directories information");
        DescribeLogDirsResult describeLogDirsResult = adminClient.describeLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toSeq()).asJava());
        Map logDirInfosByBroker = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(describeLogDirsResult.all().get()).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x$5 -> (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(x$5).asScala());
        out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received log directory information from brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).mkString(",")})));
        out.println(this.formatAsJson((Map<Integer, Map<String, DescribeLogDirsResponse.LogDirInfo>>)logDirInfosByBroker, (Set<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicList)).toSet()));
        adminClient.close();
    }

    private String formatAsJson(Map<Integer, Map<String, DescribeLogDirsResponse.LogDirInfo>> logDirInfosByBroker, Set<String> topicSet) {
        return Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"brokers"), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)logDirInfosByBroker.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer broker = (Integer)tuple2._1();
            Map logDirInfos = (Map)tuple2._2();
            java.util.Map map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker"), (Object)broker), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirs"), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)logDirInfos.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String logDir = (String)tuple2._1();
                DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                java.util.Map map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDir"), (Object)logDir), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)logDirInfo.error.exceptionName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirsCommand$.$anonfun$formatAsJson$3(topicSet, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2 = x0$4;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    DescribeLogDirsResponse.ReplicaInfo replicaInfo = (DescribeLogDirsResponse.ReplicaInfo)tuple2._2();
                    java.util.Map map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)topicPartition.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)BoxesRunTime.boxToLong((long)replicaInfo.size)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsetLag"), (Object)BoxesRunTime.boxToLong((long)replicaInfo.offsetLag)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isFuture"), (Object)BoxesRunTime.boxToBoolean((boolean)replicaInfo.isFuture))}))).asJava();
                    return map;
                }, Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava();
                return map;
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava();
            return map;
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava());
    }

    private AdminClient createAdminClient(LogDirsCommand.LogDirsCommandOptions opts) {
        Properties props = new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        props.put("client.id", "log-dirs-tool");
        return AdminClient.create(props);
    }

    public static final /* synthetic */ boolean $anonfun$describe$1(String x$1) {
        return !x$1.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describe$2(String x$2) {
        return !x$2.isEmpty();
    }

    public static final /* synthetic */ int $anonfun$describe$3(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$formatAsJson$3(Set topicSet$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = topicSet$1.isEmpty() || topicSet$1.contains((Object)topicPartition.topic());
        return bl;
    }

    private LogDirsCommand$() {
        MODULE$ = this;
    }
}

