/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.api;

import io.confluent.kafka.api.ApiVersion;
import io.confluent.kafka.api.KAFKA_0_10_0_IV0$;
import io.confluent.kafka.api.KAFKA_0_10_0_IV1$;
import io.confluent.kafka.api.KAFKA_0_10_1_IV0$;
import io.confluent.kafka.api.KAFKA_0_10_1_IV1$;
import io.confluent.kafka.api.KAFKA_0_10_1_IV2$;
import io.confluent.kafka.api.KAFKA_0_10_2_IV0$;
import io.confluent.kafka.api.KAFKA_0_11_0_IV0$;
import io.confluent.kafka.api.KAFKA_0_11_0_IV1$;
import io.confluent.kafka.api.KAFKA_0_11_0_IV2$;
import io.confluent.kafka.api.KAFKA_0_8_0$;
import io.confluent.kafka.api.KAFKA_0_8_1$;
import io.confluent.kafka.api.KAFKA_0_8_2$;
import io.confluent.kafka.api.KAFKA_0_9_0$;
import io.confluent.kafka.api.KAFKA_1_0_IV0$;
import io.confluent.kafka.api.KAFKA_1_1_IV0$;
import io.confluent.org.apache.kafka.common.record.RecordFormat;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class ApiVersion$ {
    public static ApiVersion$ MODULE$;
    private final Map<String, ApiVersion> versionNameMap;
    private final Regex versionPattern;

    static {
        new ApiVersion$();
    }

    public <A extends ApiVersion> Ordering<A> orderingByVersion() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    private Map<String, ApiVersion> versionNameMap() {
        return this.versionNameMap;
    }

    private Regex versionPattern() {
        return this.versionPattern;
    }

    public ApiVersion apply(String version) {
        String[] versionsSeq = this.versionPattern().split((CharSequence)version);
        int numSegments = version.startsWith("0.") ? 3 : 2;
        String key = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])versionsSeq)).take(numSegments))).mkString(".");
        return (ApiVersion)this.versionNameMap().getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Version `", "` is not a valid version"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version})));
        });
    }

    public ApiVersion latestVersion() {
        return (ApiVersion)this.versionNameMap().values().max(this.orderingByVersion());
    }

    public Set<ApiVersion> allVersions() {
        return this.versionNameMap().values().toSet();
    }

    public String minVersionForMessageFormat(RecordFormat messageFormatVersion) {
        String string;
        RecordFormat recordFormat = messageFormatVersion;
        if (((Object)((Object)RecordFormat.V0)).equals((Object)recordFormat)) {
            string = "0.8.0";
        } else if (((Object)((Object)RecordFormat.V1)).equals((Object)recordFormat)) {
            string = "0.10.0";
        } else if (((Object)((Object)RecordFormat.V2)).equals((Object)recordFormat)) {
            string = "0.11.0";
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid message format version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{messageFormatVersion})));
        }
        return string;
    }

    private ApiVersion$() {
        MODULE$ = this;
        this.versionNameMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.8.0"), (Object)KAFKA_0_8_0$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.8.1"), (Object)KAFKA_0_8_1$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.8.2"), (Object)KAFKA_0_8_2$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.9.0"), (Object)KAFKA_0_9_0$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.10.0-IV0"), (Object)KAFKA_0_10_0_IV0$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.10.0-IV1"), (Object)KAFKA_0_10_0_IV1$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.10.0"), (Object)KAFKA_0_10_0_IV1$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.10.1-IV0"), (Object)KAFKA_0_10_1_IV0$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.10.1-IV1"), (Object)KAFKA_0_10_1_IV1$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.10.1-IV2"), (Object)KAFKA_0_10_1_IV2$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.10.1"), (Object)KAFKA_0_10_1_IV2$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.10.2-IV0"), (Object)KAFKA_0_10_2_IV0$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.10.2"), (Object)KAFKA_0_10_2_IV0$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.11.0-IV0"), (Object)KAFKA_0_11_0_IV0$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.11.0-IV1"), (Object)KAFKA_0_11_0_IV1$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.11.0-IV2"), (Object)KAFKA_0_11_0_IV2$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"0.11.0"), (Object)KAFKA_0_11_0_IV2$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1.0-IV0"), (Object)KAFKA_1_0_IV0$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1.0"), (Object)KAFKA_1_0_IV0$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1.1-IV0"), (Object)KAFKA_1_1_IV0$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1.1"), (Object)KAFKA_1_1_IV0$.MODULE$)}));
        this.versionPattern = new StringOps(Predef$.MODULE$.augmentString("\\.")).r();
    }
}

