/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.api;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.api.ApiUtils$;
import io.confluent.kafka.api.OffsetCommitRequest;
import io.confluent.kafka.common.OffsetAndMetadata;
import io.confluent.kafka.common.OffsetAndMetadata$;
import io.confluent.kafka.common.TopicAndPartition;
import io.confluent.kafka.utils.Logging;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class OffsetCommitRequest$
implements Logging,
scala.Serializable {
    public static OffsetCommitRequest$ MODULE$;
    private final short CurrentVersion;
    private final String DefaultClientId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new OffsetCommitRequest$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        OffsetCommitRequest$ offsetCommitRequest$ = this;
        synchronized (offsetCommitRequest$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public short $lessinit$greater$default$3() {
        return this.CurrentVersion();
    }

    public int $lessinit$greater$default$4() {
        return 0;
    }

    public String $lessinit$greater$default$5() {
        return this.DefaultClientId();
    }

    public int $lessinit$greater$default$6() {
        return -1;
    }

    public String $lessinit$greater$default$7() {
        return "";
    }

    public long $lessinit$greater$default$8() {
        return -1L;
    }

    public short CurrentVersion() {
        return this.CurrentVersion;
    }

    public String DefaultClientId() {
        return this.DefaultClientId;
    }

    public OffsetCommitRequest readFrom(ByteBuffer buffer) {
        short versionId = buffer.getShort();
        Predef$.MODULE$.assert(versionId == 0 || versionId == 1 || versionId == 2, (Function0 & Serializable & scala.Serializable)() -> "Version " + versionId + " is invalid for OffsetCommitRequest. Valid versions are 0, 1 or 2.");
        int correlationId = buffer.getInt();
        String clientId = ApiUtils$.MODULE$.readShortString(buffer);
        String groupId = ApiUtils$.MODULE$.readShortString(buffer);
        int groupGenerationId = versionId >= 1 ? buffer.getInt() : -1;
        String memberId = versionId >= 1 ? ApiUtils$.MODULE$.readShortString(buffer) : "";
        long retentionMs = versionId >= 2 ? buffer.getLong() : -1L;
        int topicCount = buffer.getInt();
        IndexedSeq pairs = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), topicCount).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> OffsetCommitRequest$.$anonfun$readFrom$2(buffer, versionId, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        return new OffsetCommitRequest(groupId, (Map<TopicAndPartition, OffsetAndMetadata>)((Map)Map$.MODULE$.apply((Seq)pairs)), versionId, correlationId, clientId, groupGenerationId, memberId, retentionMs);
    }

    public OffsetCommitRequest apply(String groupId, Map<TopicAndPartition, OffsetAndMetadata> requestInfo, short versionId, int correlationId, String clientId, int groupGenerationId, String memberId, long retentionMs) {
        return new OffsetCommitRequest(groupId, requestInfo, versionId, correlationId, clientId, groupGenerationId, memberId, retentionMs);
    }

    public short apply$default$3() {
        return this.CurrentVersion();
    }

    public int apply$default$4() {
        return 0;
    }

    public String apply$default$5() {
        return this.DefaultClientId();
    }

    public int apply$default$6() {
        return -1;
    }

    public String apply$default$7() {
        return "";
    }

    public long apply$default$8() {
        return -1L;
    }

    public Option<Tuple8<String, Map<TopicAndPartition, OffsetAndMetadata>, Object, Object, String, Object, String, Object>> unapply(OffsetCommitRequest x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.groupId(), x$0.requestInfo(), (Object)BoxesRunTime.boxToShort((short)x$0.versionId()), (Object)BoxesRunTime.boxToInteger((int)x$0.correlationId()), (Object)x$0.clientId(), (Object)BoxesRunTime.boxToInteger((int)x$0.groupGenerationId()), (Object)x$0.memberId(), (Object)BoxesRunTime.boxToLong((long)x$0.retentionMs())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$readFrom$3(ByteBuffer buffer$1, short versionId$1, String topic$1, int x$2) {
        int partitionId = buffer$1.getInt();
        long offset = buffer$1.getLong();
        long timestamp = versionId$1 == 1 ? buffer$1.getLong() : -1L;
        String metadata = ApiUtils$.MODULE$.readShortString(buffer$1);
        return new Tuple2((Object)new TopicAndPartition(topic$1, partitionId), (Object)OffsetAndMetadata$.MODULE$.apply(offset, metadata, timestamp));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$readFrom$2(ByteBuffer buffer$1, short versionId$1, int x$1) {
        String topic = ApiUtils$.MODULE$.readShortString(buffer$1);
        int partitionCount = buffer$1.getInt();
        return (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), partitionCount).map((Function1 & Serializable & scala.Serializable)x$2 -> OffsetCommitRequest$.$anonfun$readFrom$3(buffer$1, versionId$1, topic, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private OffsetCommitRequest$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.CurrentVersion = (short)2;
        this.DefaultClientId = "";
    }
}

