/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.cluster;

import io.confluent.kafka.api.ApiUtils$;
import io.confluent.kafka.cluster.BrokerEndPoint;
import io.confluent.kafka.common.KafkaException;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class BrokerEndPoint$
implements Serializable {
    public static BrokerEndPoint$ MODULE$;
    private final Regex uriParseExp;

    static {
        new BrokerEndPoint$();
    }

    private Regex uriParseExp() {
        return this.uriParseExp;
    }

    public Option<Tuple2<String, Object>> parseHostPort(String connectionString) {
        None$ none$;
        String string = connectionString;
        Option option = this.uriParseExp().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            Some some;
            String host = (String)((LinearSeqOptimized)option.get()).apply(0);
            String port = (String)((LinearSeqOptimized)option.get()).apply(1);
            try {
                some = new Some((Object)new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
            }
            catch (NumberFormatException numberFormatException) {
                some = None$.MODULE$;
            }
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public BrokerEndPoint createBrokerEndPoint(int brokerId, String connectionString) {
        return (BrokerEndPoint)this.parseHostPort(connectionString).map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, host, port);
            return brokerEndPoint;
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            throw new KafkaException("Unable to parse " + connectionString + " to a broker endpoint");
        });
    }

    public BrokerEndPoint readFrom(ByteBuffer buffer) {
        int brokerId = buffer.getInt();
        String host = ApiUtils$.MODULE$.readShortString(buffer);
        int port = buffer.getInt();
        return new BrokerEndPoint(brokerId, host, port);
    }

    public BrokerEndPoint apply(int id, String host, int port) {
        return new BrokerEndPoint(id, host, port);
    }

    public Option<Tuple3<Object, String, Object>> unapply(BrokerEndPoint x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.id()), (Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BrokerEndPoint$() {
        MODULE$ = this;
        this.uriParseExp = new StringOps(Predef$.MODULE$.augmentString("\\[?([0-9a-zA-Z\\-%._:]*)\\]?:([0-9]+)")).r();
    }
}

