/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.controller;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.api.LeaderAndIsr;
import io.confluent.kafka.api.LeaderAndIsr$;
import io.confluent.kafka.common.StateChangeFailedException;
import io.confluent.kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import io.confluent.kafka.controller.ControllerBrokerRequestBatch;
import io.confluent.kafka.controller.ControllerContext;
import io.confluent.kafka.controller.LeaderIsrAndControllerEpoch;
import io.confluent.kafka.controller.NewPartition$;
import io.confluent.kafka.controller.NonExistentPartition$;
import io.confluent.kafka.controller.OfflinePartition$;
import io.confluent.kafka.controller.OfflinePartitionLeaderElectionStrategy$;
import io.confluent.kafka.controller.OnlinePartition$;
import io.confluent.kafka.controller.PartitionLeaderElectionAlgorithms$;
import io.confluent.kafka.controller.PartitionLeaderElectionStrategy;
import io.confluent.kafka.controller.PartitionState;
import io.confluent.kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import io.confluent.kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import io.confluent.kafka.controller.ReassignedPartitionsContext;
import io.confluent.kafka.controller.StateChangeLogger;
import io.confluent.kafka.controller.TopicDeletionManager;
import io.confluent.kafka.log.LogConfig;
import io.confluent.kafka.server.KafkaConfig;
import io.confluent.kafka.utils.Logging;
import io.confluent.kafka.zk.KafkaZkClient;
import io.confluent.kafka.zk.TopicPartitionStateZNode$;
import io.confluent.kafka.zookeeper.GetDataResponse;
import io.confluent.org.apache.kafka.common.TopicPartition;
import java.io.Serializable;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=b\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!\u0011!Q\u0001\nY\taaY8oM&<\u0007CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u0019\u0019XM\u001d<fe&\u00111\u0004\u0007\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\t\u0003?\u0001j\u0011AA\u0005\u0003C\t\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011q$J\u0005\u0003M\t\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011!A\u0003A!A!\u0002\u0013I\u0013\u0001\u0006;pa&\u001cG)\u001a7fi&|g.T1oC\u001e,'\u000f\u0005\u0002 U%\u00111F\u0001\u0002\u0015)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8NC:\fw-\u001a:\t\u00115\u0002!\u0011!Q\u0001\n9\n\u0001B_6DY&,g\u000e\u001e\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0011\t!A_6\n\u0005M\u0002$!D&bM.\f'l[\"mS\u0016tG\u000f\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u0004Ba\u000e\u001f?\u00136\t\u0001H\u0003\u0002:u\u00059Q.\u001e;bE2,'BA\u001e\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003{a\u00121!T1q!\tyt)D\u0001A\u0015\t\t%)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\rS!\u0001R#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0015aA8sO&\u0011\u0001\n\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\ty\"*\u0003\u0002L\u0005\tq\u0001+\u0019:uSRLwN\\*uCR,\u0007\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\u00029\r|g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQB\u0011qdT\u0005\u0003!\n\u0011AdQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000eC\u0003S\u0001\u0011\u00051+\u0001\u0004=S:LGO\u0010\u000b\t)V3v\u000bW-[7B\u0011q\u0004\u0001\u0005\u0006+E\u0003\rA\u0006\u0005\u0006;E\u0003\rA\b\u0005\u0006GE\u0003\r\u0001\n\u0005\u0006QE\u0003\r!\u000b\u0005\u0006[E\u0003\rA\f\u0005\u0006kE\u0003\rA\u000e\u0005\u0006\u001bF\u0003\rA\u0014\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u00031\u0019wN\u001c;s_2dWM]%e+\u0005y\u0006CA\u0005a\u0013\t\t'BA\u0002J]RDaa\u0019\u0001!\u0002\u0013y\u0016!D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0005C\u0003f\u0001\u0011\u0005a-A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003\u001d\u0004\"!\u00035\n\u0005%T!\u0001B+oSRDQa\u001b\u0001\u0005\u0002\u0019\f\u0001b\u001d5vi\u0012|wO\u001c\u0005\u0006[\u0002!IAZ\u0001\u0019S:LG/[1mSj,\u0007+\u0019:uSRLwN\\*uCR,\u0007\"B8\u0001\t\u00031\u0017!\t;sS\u001e<WM](oY&tW\rU1si&$\u0018n\u001c8Ti\u0006$Xm\u00115b]\u001e,\u0007\"B9\u0001\t\u0003\u0011\u0018A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$baZ:\u0002\u0004\u0005\u001d\u0001\"\u0002;q\u0001\u0004)\u0018A\u00039beRLG/[8ogB\u0019aO  \u000f\u0005]dhB\u0001=|\u001b\u0005I(B\u0001>\u0007\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002~\u0015\u00059\u0001/Y2lC\u001e,\u0017bA@\u0002\u0002\t\u00191+Z9\u000b\u0005uT\u0001BBA\u0003a\u0002\u0007\u0011*A\u0006uCJ<W\r^*uCR,\u0007\"CA\u0005aB\u0005\t\u0019AA\u0006\u0003\t\u0002\u0018M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|gn\u0015;sCR,w-_(qiB)\u0011\"!\u0004\u0002\u0012%\u0019\u0011q\u0002\u0006\u0003\r=\u0003H/[8o!\ry\u00121C\u0005\u0004\u0003+\u0011!a\b)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o'R\u0014\u0018\r^3hs\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0011!\u00059beRLG/[8og&s7\u000b^1uKR!\u0011QDA\u0017!\u0015\ty\"a\n?\u001d\u0011\t\t#a\t\u0011\u0005aT\u0011bAA\u0013\u0015\u00051\u0001K]3eK\u001aLA!!\u000b\u0002,\t\u00191+\u001a;\u000b\u0007\u0005\u0015\"\u0002C\u0004\u00020\u0005]\u0001\u0019A%\u0002\u000bM$\u0018\r^3\t\u000f\u0005M\u0002\u0001\"\u0003\u00026\u0005!Bm\u001c%b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$raZA\u001c\u0003s\tY\u0004\u0003\u0004u\u0003c\u0001\r!\u001e\u0005\b\u0003\u000b\t\t\u00041\u0001J\u0011!\tI!!\rA\u0002\u0005-\u0001bBA \u0001\u0011%\u0011\u0011I\u0001$S:LG/[1mSj,G*Z1eKJ\fe\u000eZ%te\u001a{'\u000fU1si&$\u0018n\u001c8t)\r)\u00181\t\u0005\u0007i\u0006u\u0002\u0019A;\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J\u0005AR\r\\3di2+\u0017\rZ3s\r>\u0014\b+\u0019:uSRLwN\\:\u0015\u000bU\fY%!\u0014\t\rQ\f)\u00051\u0001v\u0011!\ty%!\u0012A\u0002\u0005E\u0011a\b9beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o'R\u0014\u0018\r^3hs\"9\u00111\u000b\u0001\u0005\n\u0005U\u0013A\u00073p\u000b2,7\r\u001e'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:\u001cHCBA,\u0003O\nI\u0007E\u0004\n\u00033*X/!\u0018\n\u0007\u0005m#B\u0001\u0004UkBdWm\r\t\b\u0003?\tyFPA1\u0013\ri\u00141\u0006\t\u0004m\u0006\r\u0014\u0002BA3\u0003\u0003\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\t\rQ\f\t\u00061\u0001v\u0011!\ty%!\u0015A\u0002\u0005E\u0001bBA7\u0001\u0011%\u0011qN\u0001\u0011Y\u0016\fG-\u001a:G_J|eM\u001a7j]\u0016$B!!\u001d\u0002\u0006B!aO`A:!!I\u0011\u0011\f \u0002v\u0005\r\u0005#B\u0005\u0002\u000e\u0005]\u0004\u0003BA=\u0003\u007fj!!a\u001f\u000b\u0007\u0005uD!A\u0002ba&LA!!!\u0002|\taA*Z1eKJ\fe\u000eZ%teB\u0019aO`0\t\u0011\u0005\u001d\u00151\u000ea\u0001\u0003\u0013\u000bA\u0004\\3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD7\u000f\u0005\u0003w}\u0006-\u0005CB\u0005\u0002\u000ez\n\t*C\u0002\u0002\u0010*\u0011a\u0001V;qY\u0016\u0014\u0004cA\u0010\u0002\u0014&\u0019\u0011Q\u0013\u0002\u000371+\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u001d\tI\n\u0001C\u0005\u00037\u000b\u0011\u0003\\3bI\u0016\u0014hi\u001c:SK\u0006\u001c8/[4o)\u0011\t\t(!(\t\u0011\u0005\u001d\u0015q\u0013a\u0001\u0003\u0013Cq!!)\u0001\t\u0013\t\u0019+A\rmK\u0006$WM\u001d$peB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG\u0003BA9\u0003KC\u0001\"a\"\u0002 \u0002\u0007\u0011\u0011\u0012\u0005\b\u0003S\u0003A\u0011BAV\u0003maW-\u00193fe\u001a{'oQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]R1\u0011\u0011OAW\u0003_C\u0001\"a\"\u0002(\u0002\u0007\u0011\u0011\u0012\u0005\t\u0003c\u000b9\u000b1\u0001\u00024\u0006\u00192\u000f[;ui&tw\rR8x]\n\u0013xn[3sgB)\u0011qDA\u0014?\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0016!E5t-\u0006d\u0017\u000e\u001a+sC:\u001c\u0018\u000e^5p]R1\u00111XAa\u0003\u000b\u00042!CA_\u0013\r\tyL\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019-!.A\u0002y\n\u0011\u0002]1si&$\u0018n\u001c8\t\u000f\u0005\u0015\u0011Q\u0017a\u0001\u0013\"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0017\u0001\u00067pO&sg/\u00197jIR\u0013\u0018M\\:ji&|g\u000eF\u0003h\u0003\u001b\fy\rC\u0004\u0002D\u0006\u001d\u0007\u0019\u0001 \t\u000f\u0005\u0015\u0011q\u0019a\u0001\u0013\"9\u00111\u001b\u0001\u0005\n\u0005U\u0017\u0001\u00067pO\u001a\u000b\u0017\u000e\\3e'R\fG/Z\"iC:<W\rF\u0005h\u0003/\fI.!8\u0002`\"9\u00111YAi\u0001\u0004q\u0004bBAn\u0003#\u0004\r!S\u0001\nGV\u0014(o\u0015;bi\u0016Dq!!\u0002\u0002R\u0002\u0007\u0011\n\u0003\u0005\u0002b\u0006E\u0007\u0019AAr\u0003\u0011\u0019w\u000eZ3\u0011\t\u0005\u0015\u00181 \b\u0005\u0003O\f)P\u0004\u0003\u0002j\u0006Eh\u0002BAv\u0003_t1\u0001_Aw\u0013\u00051\u0015B\u0001#F\u0013\r\t\u0019pQ\u0001\nu>|7.Z3qKJLA!a>\u0002z\u0006y1*Z3qKJ,\u0005pY3qi&|gNC\u0002\u0002t\u000eKA!!@\u0002\u0000\n!1i\u001c3f\u0015\u0011\t90!?\t\u000f\u0005M\u0007\u0001\"\u0003\u0003\u0004QIqM!\u0002\u0003\b\t%!1\u0002\u0005\b\u0003\u0007\u0014\t\u00011\u0001?\u0011\u001d\tYN!\u0001A\u0002%Cq!!\u0002\u0003\u0002\u0001\u0007\u0011\n\u0003\u0005\u0003\u000e\t\u0005\u0001\u0019\u0001B\b\u0003\u0005!\bc\u0001<\u0003\u0012%!!1CA\u0001\u0005%!\u0006N]8xC\ndW\rC\u0005\u0003\u0018\u0001\t\n\u0011\"\u0001\u0003\u001a\u0005a\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3tI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u000eU\u0011\tYA!\b,\u0005\t}\u0001\u0003\u0002B\u0011\u0005Wi!Aa\t\u000b\t\t\u0015\"qE\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u000b\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005[\u0011\u0019CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class PartitionStateMachine
implements Logging {
    private final KafkaConfig config;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final TopicDeletionManager topicDeletionManager;
    private final KafkaZkClient zkClient;
    private final Map<TopicPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final int controllerId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing partition state");
        this.initializePartitionState();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Triggering online partition state changes");
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started partition state machine with initial state -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.partitionState})));
    }

    public void shutdown() {
        this.partitionState.clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped partition state machine");
    }

    private void initializePartitionState() {
        this.controllerContext.partitionReplicaAssignment().keys().foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            Option option;
            Option option2 = $this.controllerContext.partitionLeadershipInfo().get(topicPartition);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)some.value();
                option = $this.controllerContext.isReplicaOnline(currentLeaderIsrAndEpoch.leaderAndIsr().leader(), (TopicPartition)topicPartition, $this.controllerContext.isReplicaOnline$default$3()) ? $this.partitionState.put(topicPartition, (Object)OnlinePartition$.MODULE$) : $this.partitionState.put(topicPartition, (Object)OfflinePartition$.MODULE$);
            } else if (None$.MODULE$.equals(option2)) {
                option = $this.partitionState.put(topicPartition, (Object)NewPartition$.MODULE$);
            } else {
                throw new MatchError((Object)option2);
            }
            return option;
        });
    }

    public void triggerOnlinePartitionStateChange() {
        Seq partitionsToTrigger = ((MapLike)this.partitionState.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$triggerOnlinePartitionStateChange$1(this, x0$1)))).keys().toSeq();
        this.handleStateChanges((Seq<TopicPartition>)partitionsToTrigger, OnlinePartition$.MODULE$, (Option<PartitionLeaderElectionStrategy>)Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
    }

    public void handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        block2: {
            if (!partitions.nonEmpty()) break block2;
            try {
                this.controllerBrokerRequestBatch.newBatch();
                this.doHandleStateChanges(partitions, targetState, partitionLeaderElectionStrategyOpt);
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while moving some partitions to ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
    }

    public Option<PartitionLeaderElectionStrategy> handleStateChanges$default$3() {
        return None$.MODULE$;
    }

    public Set<TopicPartition> partitionsInState(PartitionState state) {
        return ((MapLike)this.partitionState.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$partitionsInState$1(state, x0$2)))).keySet().toSet();
    }

    private void doHandleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> partitionLeaderElectionStrategyOpt) {
        StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> (PartitionState)$this.partitionState.getOrElseUpdate(partition, (Function0 & Serializable & scala.Serializable)() -> NonExistentPartition$.MODULE$));
        Tuple2 tuple2 = partitions.partition((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)this.isValidTransition(partition, targetState)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq validPartitions = (Seq)tuple2._1();
        Seq invalidPartitions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)validPartitions, (Object)invalidPartitions);
        Tuple2 tuple23 = tuple22;
        Seq validPartitions2 = (Seq)tuple23._1();
        Seq invalidPartitions2 = (Seq)tuple23._2();
        invalidPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.logInvalidTransition(partition, targetState);
            return BoxedUnit.UNIT;
        });
        PartitionState partitionState = targetState;
        if (NewPartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                stateChangeLog.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", " with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, $this.partitionState.apply(partition), targetState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"assigned replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)$this.controllerContext.partitionReplicaAssignment().apply(partition)).mkString(",")})));
                return $this.partitionState.put(partition, (Object)NewPartition$.MODULE$);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OnlinePartition$.MODULE$.equals(partitionState)) {
            BoxedUnit boxedUnit;
            Seq uninitializedPartitions = (Seq)validPartitions2.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doHandleStateChanges$7(this, partition)));
            Seq partitionsToElectLeader = (Seq)validPartitions2.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doHandleStateChanges$8(this, partition)));
            if (uninitializedPartitions.nonEmpty()) {
                Seq<TopicPartition> successfulInitializations = this.initializeLeaderAndIsrForPartitions((Seq<TopicPartition>)uninitializedPartitions);
                successfulInitializations.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    stateChangeLog.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " from ", " to ", " with state "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, $this.partitionState.apply(partition), targetState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo().apply(partition)).leaderAndIsr()})));
                    return $this.partitionState.put(partition, (Object)OnlinePartition$.MODULE$);
                });
            }
            if (partitionsToElectLeader.nonEmpty()) {
                Seq<TopicPartition> successfulElections = this.electLeaderForPartitions((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)partitionLeaderElectionStrategyOpt.get());
                successfulElections.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    stateChangeLog.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " from ", " to ", " with state "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, $this.partitionState.apply(partition), targetState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo().apply(partition)).leaderAndIsr()})));
                    return $this.partitionState.put(partition, (Object)OnlinePartition$.MODULE$);
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (OfflinePartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                stateChangeLog.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, $this.partitionState.apply(partition), targetState})));
                return $this.partitionState.put(partition, (Object)OfflinePartition$.MODULE$);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NonExistentPartition$.MODULE$.equals(partitionState)) {
            validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                stateChangeLog.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed partition ", " state from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, $this.partitionState.apply(partition), targetState})));
                return $this.partitionState.put(partition, (Object)NonExistentPartition$.MODULE$);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)partitionState);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TopicPartition> initializeLeaderAndIsrForPartitions(Seq<TopicPartition> partitions) {
        void var3_2;
        Seq seq;
        Buffer successfulInitializations = (Buffer)Buffer$.MODULE$.empty();
        Seq replicasPerPartition = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), $this.controllerContext.partitionReplicaAssignment().apply(partition)), Seq$.MODULE$.canBuildFrom());
        Seq liveReplicasPerPartition = (Seq)replicasPerPartition.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Seq liveReplicasForPartition = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)liveReplicasForPartition);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = liveReplicasPerPartition.partition((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$4(x0$4)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionsWithoutLiveReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveReplicas = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsWithoutLiveReplicas, (Object)partitionsWithLiveReplicas);
        Tuple2 tuple23 = tuple22;
        Seq partitionsWithoutLiveReplicas2 = (Seq)tuple23._1();
        Seq partitionsWithLiveReplicas2 = (Seq)tuple23._2();
        partitionsWithoutLiveReplicas2.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            PartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$5(this, x0$5);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = ((TraversableOnce)partitionsWithLiveReplicas2.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            Seq liveReplicas = (Seq)tuple2._2();
            LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)liveReplicas.head()), (List<Object>)liveReplicas.toList());
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        try {
            seq = this.zkClient.createTopicPartitionStatesRaw((scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch>)leaderIsrAndControllerEpochs);
        }
        catch (Exception e) {
            partitionsWithLiveReplicas2.foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
                PartitionStateMachine.$anonfun$initializeLeaderAndIsrForPartitions$7(this, e, x0$7);
                return BoxedUnit.UNIT;
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        Seq createResponses = seq;
        createResponses.foreach((Function1 & Serializable & scala.Serializable)createResponse -> {
            BoxedUnit boxedUnit;
            KeeperException.Code code = createResponse.resultCode();
            TopicPartition partition = (TopicPartition)createResponse.ctx().get();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochs.apply((Object)partition);
            KeeperException.Code code2 = code;
            KeeperException.Code code3 = KeeperException.Code.OK;
            if (!(code2 != null ? !code2.equals(code3) : code3 != null)) {
                $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), partition, leaderIsrAndControllerEpoch, (Seq<Object>)((Seq)$this.controllerContext.partitionReplicaAssignment().apply((Object)partition)), true);
                boxedUnit = successfulInitializations.$plus$eq((Object)partition);
            } else {
                this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, code);
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return var3_2;
    }

    private Seq<TopicPartition> electLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Buffer successfulElections = (Buffer)Buffer$.MODULE$.empty();
        Seq remaining = partitions;
        while (remaining.nonEmpty()) {
            Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> tuple3 = this.doElectLeaderForPartitions(partitions, partitionLeaderElectionStrategy);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Seq success = (Seq)tuple3._1();
            Seq updatesToRetry = (Seq)tuple3._2();
            scala.collection.immutable.Map failedElections = (scala.collection.immutable.Map)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)success, (Object)updatesToRetry, (Object)failedElections);
            Tuple3 tuple33 = tuple32;
            Seq success2 = (Seq)tuple33._1();
            Seq updatesToRetry2 = (Seq)tuple33._2();
            scala.collection.immutable.Map failedElections2 = (scala.collection.immutable.Map)tuple33._3();
            remaining = updatesToRetry2;
            successfulElections.$plus$plus$eq((TraversableOnce)success2);
            failedElections2.foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                PartitionStateMachine.$anonfun$electLeaderForPartitions$1(this, x0$8);
                return BoxedUnit.UNIT;
            });
        }
        return successfulElections;
    }

    private Tuple3<Seq<TopicPartition>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> doElectLeaderForPartitions(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy partitionLeaderElectionStrategy) {
        Tuple2 tuple2;
        Seq<GetDataResponse> seq;
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)e), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        Seq<GetDataResponse> getDataResponses = seq;
        Map failedElections = Map$.MODULE$.empty();
        Buffer leaderIsrAndControllerEpochPerPartition = (Buffer)Buffer$.MODULE$.empty();
        getDataResponses.foreach((Function1 & Serializable & scala.Serializable)getDataResponse -> {
            Option option;
            TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
            PartitionState currState = (PartitionState)$this.partitionState.apply((Object)partition);
            KeeperException.Code code = getDataResponse.resultCode();
            KeeperException.Code code2 = KeeperException.Code.OK;
            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                BoxedUnit boxedUnit;
                Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                if (leaderIsrAndControllerEpochOpt.isEmpty()) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LeaderAndIsr information doesn't exist for partition ", " in ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, currState})));
                    boxedUnit = failedElections.put((Object)partition, (Object)exception);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option = leaderIsrAndControllerEpochPerPartition.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), leaderIsrAndControllerEpochOpt.get()));
            } else {
                KeeperException.Code code3 = getDataResponse.resultCode();
                KeeperException.Code code4 = KeeperException.Code.NONODE;
                if (!(code3 != null ? !code3.equals(code4) : code4 != null)) {
                    StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LeaderAndIsr information doesn't exist for partition ", " in ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, currState})));
                    option = failedElections.put((Object)partition, (Object)exception);
                } else {
                    option = failedElections.put((Object)partition, getDataResponse.resultException().get());
                }
            }
            return option;
        });
        Tuple2 tuple22 = leaderIsrAndControllerEpochPerPartition.partition((Function1 & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$3(this, x0$9)));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Buffer invalidPartitionsForElection = (Buffer)tuple22._1();
        Buffer validPartitionsForElection = (Buffer)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)invalidPartitionsForElection, (Object)validPartitionsForElection);
        Tuple2 tuple24 = tuple23;
        Buffer invalidPartitionsForElection2 = (Buffer)tuple24._1();
        Buffer validPartitionsForElection2 = (Buffer)tuple24._2();
        invalidPartitionsForElection2.foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
            Tuple2 tuple2 = x0$10;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aborted leader election for partition ", " since the LeaderAndIsr path was "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"already written by another controller. This probably means that the current controller ", " went through "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a soft failure and another controller was elected with epoch ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch())}));
            Option option = failedElections.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
            return option;
        });
        if (validPartitionsForElection2.isEmpty()) {
            return new Tuple3((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty(), (Object)failedElections.toMap(Predef$.MODULE$.$conforms()));
        }
        Set shuttingDownBrokers = this.controllerContext.shuttingDownBrokerIds().toSet();
        PartitionLeaderElectionStrategy partitionLeaderElectionStrategy2 = partitionLeaderElectionStrategy;
        if (OfflinePartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForOffline((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x0$11 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$5(x0$11)));
        } else if (ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForReassign((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x0$12 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$6(x0$12)));
        } else if (PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForPreferredReplica((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2).partition((Function1 & Serializable & scala.Serializable)x0$13 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$7(x0$13)));
        } else if (ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(partitionLeaderElectionStrategy2)) {
            tuple2 = this.leaderForControlledShutdown((Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>>)validPartitionsForElection2, (Set<Object>)shuttingDownBrokers).partition((Function1 & Serializable & scala.Serializable)x0$14 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$doElectLeaderForPartitions$8(x0$14)));
        } else {
            throw new MatchError((Object)partitionLeaderElectionStrategy2);
        }
        Tuple2 tuple25 = tuple2;
        if (tuple25 == null) {
            throw new MatchError((Object)tuple25);
        }
        Seq partitionsWithoutLeaders = (Seq)tuple25._1();
        Seq partitionsWithLeaders = (Seq)tuple25._2();
        Tuple2 tuple26 = new Tuple2((Object)partitionsWithoutLeaders, (Object)partitionsWithLeaders);
        Tuple2 tuple27 = tuple26;
        Seq partitionsWithoutLeaders2 = (Seq)tuple27._1();
        Seq partitionsWithLeaders2 = (Seq)tuple27._2();
        partitionsWithoutLeaders2.foreach((Function1 & Serializable & scala.Serializable)x0$15 -> {
            Tuple3 tuple3 = x0$15;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            TopicPartition partition = (TopicPartition)tuple3._1();
            String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to elect leader for partition ", " under strategy ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition, partitionLeaderElectionStrategy}));
            Option option = failedElections.put((Object)partition, (Object)new StateChangeFailedException(failMsg));
            return option;
        });
        scala.collection.immutable.Map recipientsPerPartition = ((TraversableOnce)partitionsWithLeaders2.map((Function1 & Serializable & scala.Serializable)x0$16 -> {
            Tuple3 tuple3 = x0$16;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            TopicPartition partition = (TopicPartition)tuple3._1();
            Seq recipients = (Seq)tuple3._3();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)recipients);
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map adjustedLeaderAndIsrs = ((TraversableOnce)partitionsWithLeaders2.map((Function1 & Serializable & scala.Serializable)x0$17 -> {
            Tuple3 tuple3 = x0$17;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            TopicPartition partition = (TopicPartition)tuple3._1();
            Option leaderAndIsrOpt = (Option)tuple3._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), leaderAndIsrOpt.get());
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.controllerContext.epoch());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError((Object)updateLeaderAndIsrResult);
        }
        scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> successfulUpdates = updateLeaderAndIsrResult.successfulPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        scala.collection.immutable.Map<TopicPartition, Exception> failedUpdates = updateLeaderAndIsrResult.failedPartitions();
        Tuple3 tuple3 = new Tuple3(successfulUpdates, updatesToRetry, failedUpdates);
        Tuple3 tuple32 = tuple3;
        scala.collection.immutable.Map successfulUpdates2 = (scala.collection.immutable.Map)tuple32._1();
        Seq updatesToRetry2 = (Seq)tuple32._2();
        scala.collection.immutable.Map failedUpdates2 = (scala.collection.immutable.Map)tuple32._3();
        successfulUpdates2.foreach((Function1 & Serializable & scala.Serializable)x0$18 -> {
            PartitionStateMachine.$anonfun$doElectLeaderForPartitions$12(this, recipientsPerPartition, x0$18);
            return BoxedUnit.UNIT;
        });
        return new Tuple3((Object)successfulUpdates2.keys().toSeq(), (Object)updatesToRetry2, (Object)failedElections.toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)failedUpdates2));
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForOffline(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        Tuple2 tuple2 = leaderIsrAndControllerEpochs.partition((Function1 & Serializable & scala.Serializable)x0$19 -> BoxesRunTime.boxToBoolean((boolean)PartitionStateMachine.$anonfun$leaderForOffline$1(this, x0$19)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionsWithNoLiveInSyncReplicas = (Seq)tuple2._1();
        Seq partitionsWithLiveInSyncReplicas = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionsWithNoLiveInSyncReplicas, (Object)partitionsWithLiveInSyncReplicas);
        Tuple2 tuple23 = tuple22;
        Seq partitionsWithNoLiveInSyncReplicas2 = (Seq)tuple23._1();
        Seq partitionsWithLiveInSyncReplicas2 = (Seq)tuple23._2();
        Tuple2<scala.collection.immutable.Map<String, LogConfig>, scala.collection.immutable.Map<String, Exception>> tuple24 = this.zkClient.getLogConfigs((Seq<String>)((Seq)partitionsWithNoLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$20 -> {
            Tuple2 tuple2 = x0$20;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            String string = partition.topic();
            return string;
        }, Seq$.MODULE$.canBuildFrom())), this.config.originals());
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        scala.collection.immutable.Map logConfigs = (scala.collection.immutable.Map)tuple24._1();
        scala.collection.immutable.Map failed = (scala.collection.immutable.Map)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)logConfigs, (Object)failed);
        Tuple2 tuple26 = tuple25;
        scala.collection.immutable.Map logConfigs2 = (scala.collection.immutable.Map)tuple26._1();
        scala.collection.immutable.Map failed2 = (scala.collection.immutable.Map)tuple26._2();
        Seq partitionsWithUncleanLeaderElectionState = (Seq)((TraversableLike)partitionsWithNoLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$21 -> {
            Tuple3 tuple3;
            Tuple2 tuple2 = x0$21;
            if (tuple2 != null) {
                TopicPartition partition = (TopicPartition)tuple2._1();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                if (failed2.contains((Object)partition.topic())) {
                    this.logFailedStateChange(partition, (PartitionState)$this.partitionState.apply((Object)partition), (PartitionState)OnlinePartition$.MODULE$, (Throwable)failed2.apply((Object)partition.topic()));
                    tuple3 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                } else {
                    tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)((LogConfig)logConfigs2.apply((Object)partition.topic())).uncleanLeaderElectionEnable()));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 tuple32 = tuple3;
            return tuple32;
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLiveInSyncReplicas2.map((Function1 & Serializable & scala.Serializable)x0$22 -> {
            Tuple2 tuple2 = x0$22;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)Option$.MODULE$.apply((Object)leaderIsrAndControllerEpoch), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return (Seq)partitionsWithUncleanLeaderElectionState.map((Function1 & Serializable & scala.Serializable)x0$23 -> {
            Tuple3 tuple3;
            Tuple3 tuple32 = x0$23;
            if (tuple32 != null) {
                TopicPartition partition = (TopicPartition)tuple32._1();
                Option leaderIsrAndControllerEpochOpt = (Option)tuple32._2();
                boolean uncleanLeaderElectionEnabled = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
                Seq assignment = (Seq)$this.controllerContext.partitionReplicaAssignment().apply((Object)partition);
                Seq liveReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
                if (leaderIsrAndControllerEpochOpt.nonEmpty()) {
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochOpt.get();
                    List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
                    Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection((Seq<Object>)assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet(), uncleanLeaderElectionEnabled);
                    Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForOffline$8(this, partition, leaderIsrAndControllerEpoch, isr, BoxesRunTime.unboxToInt((Object)leader)));
                    tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, (Object)liveReplicas);
                } else {
                    tuple3 = new Tuple3((Object)partition, (Object)None$.MODULE$, (Object)liveReplicas);
                }
            } else {
                throw new MatchError((Object)tuple32);
            }
            Tuple3 tuple33 = tuple3;
            return tuple33;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForReassign(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1 & Serializable & scala.Serializable)x0$24 -> {
            Tuple2 tuple2 = x0$24;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Seq<Object> reassignment = ((ReassignedPartitionsContext)$this.controllerContext.partitionsBeingReassigned().apply((Object)partition)).newReplicas();
            Seq liveReplicas = (Seq)reassignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
            Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet());
            Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForReassign$3(leaderIsrAndControllerEpoch, BoxesRunTime.unboxToInt((Object)leader)));
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, reassignment);
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForPreferredReplica(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1 & Serializable & scala.Serializable)x0$25 -> {
            Tuple2 tuple2 = x0$25;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Seq assignment = (Seq)$this.controllerContext.partitionReplicaAssignment().apply((Object)partition);
            Seq liveReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
            Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection((Seq<Object>)assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet());
            Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForPreferredReplica$3(leaderIsrAndControllerEpoch, BoxesRunTime.unboxToInt((Object)leader)));
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, (Object)assignment);
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Seq<Object>>> leaderForControlledShutdown(Seq<Tuple2<TopicPartition, LeaderIsrAndControllerEpoch>> leaderIsrAndControllerEpochs, Set<Object> shuttingDownBrokers) {
        return (Seq)leaderIsrAndControllerEpochs.map((Function1 & Serializable & scala.Serializable)x0$26 -> {
            Tuple2 tuple2 = x0$26;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
            Seq assignment = (Seq)$this.controllerContext.partitionReplicaAssignment().apply((Object)partition);
            Seq liveReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
            List<Object> isr = leaderIsrAndControllerEpoch.leaderAndIsr().isr();
            Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection((Seq<Object>)assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet(), shuttingDownBrokers);
            List newIsr = (List)isr.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> !$this.controllerContext.shuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)replica)));
            Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable & scala.Serializable)leader -> PartitionStateMachine.$anonfun$leaderForControlledShutdown$4(leaderIsrAndControllerEpoch, newIsr, BoxesRunTime.unboxToInt((Object)leader)));
            Tuple3 tuple3 = new Tuple3((Object)partition, (Object)newLeaderAndIsrOpt, (Object)liveReplicas);
            return tuple3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private boolean isValidTransition(TopicPartition partition, PartitionState targetState) {
        return targetState.validPreviousStates().contains(this.partitionState.apply((Object)partition));
    }

    private void logInvalidTransition(TopicPartition partition, PartitionState targetState) {
        PartitionState currState = (PartitionState)this.partitionState.apply((Object)partition);
        IllegalStateException e = new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should be in one of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " states before moving to ", " state. Instead it is in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState.validPreviousStates().mkString(","), targetState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currState})));
        this.logFailedStateChange(partition, currState, targetState, e);
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, KeeperException.Code code) {
        this.logFailedStateChange(partition, currState, targetState, KeeperException.create((KeeperException.Code)code));
    }

    private void logFailedStateChange(TopicPartition partition, PartitionState currState, PartitionState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " failed to change state for partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controllerContext.epoch()), partition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currState, targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ boolean $anonfun$triggerOnlinePartitionStateChange$1(PartitionStateMachine $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        PartitionState partitionState = (PartitionState)tuple2._2();
        boolean bl = !$this.topicDeletionManager.isTopicQueuedUpForDeletion(partition.topic()) && (partitionState.equals(OfflinePartition$.MODULE$) || partitionState.equals(NewPartition$.MODULE$));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$partitionsInState$1(PartitionState state$1, Tuple2 x0$2) {
        PartitionState s;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionState partitionState = s = (PartitionState)tuple2._2();
        PartitionState partitionState2 = state$1;
        boolean bl = !(partitionState != null ? !partitionState.equals(partitionState2) : partitionState2 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$7(PartitionStateMachine $this, TopicPartition partition) {
        Object object = $this.partitionState.apply((Object)partition);
        NewPartition$ newPartition$ = NewPartition$.MODULE$;
        return !(object != null ? !object.equals(newPartition$) : newPartition$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$8(PartitionStateMachine $this, TopicPartition partition) {
        Object object = $this.partitionState.apply((Object)partition);
        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
        if (object == null) {
            if (offlinePartition$ == null) return true;
        } else if (object.equals(offlinePartition$)) return true;
        Object object2 = $this.partitionState.apply((Object)partition);
        OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
        if (object2 != null) {
            if (!object2.equals(onlinePartition$)) return false;
            return true;
        }
        if (onlinePartition$ == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$initializeLeaderAndIsrForPartitions$4(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq liveReplicas = (Seq)tuple2._2();
        boolean bl = liveReplicas.isEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$5(PartitionStateMachine $this, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        Seq replicas = (Seq)tuple2._2();
        String failMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " encountered error during state change of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controllerContext.epoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", " from New to Online, assigned replicas are "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "], live brokers are [", "]. No assigned "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicas.mkString(","), $this.controllerContext.liveBrokerIds()})) + "replica is alive.";
        $this.logFailedStateChange(partition, (PartitionState)NewPartition$.MODULE$, (PartitionState)OnlinePartition$.MODULE$, new StateChangeFailedException(failMsg));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$initializeLeaderAndIsrForPartitions$7(PartitionStateMachine $this, Exception e$2, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        $this.logFailedStateChange(partition, (PartitionState)$this.partitionState.apply((Object)partition), (PartitionState)NewPartition$.MODULE$, e$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$electLeaderForPartitions$1(PartitionStateMachine $this, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        Exception e = (Exception)tuple2._2();
        $this.logFailedStateChange(partition, (PartitionState)$this.partitionState.apply((Object)partition), (PartitionState)OnlinePartition$.MODULE$, e);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$3(PartitionStateMachine $this, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
        boolean bl = leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$5(Tuple3 x0$11) {
        Tuple3 tuple3 = x0$11;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$6(Tuple3 x0$12) {
        Tuple3 tuple3 = x0$12;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$7(Tuple3 x0$13) {
        Tuple3 tuple3 = x0$13;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doElectLeaderForPartitions$8(Tuple3 x0$14) {
        Tuple3 tuple3 = x0$14;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Option newLeaderAndIsrOpt = (Option)tuple3._2();
        boolean bl = newLeaderAndIsrOpt.isEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$doElectLeaderForPartitions$12(PartitionStateMachine $this, scala.collection.immutable.Map recipientsPerPartition$1, Tuple2 x0$18) {
        Tuple2 tuple2 = x0$18;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
        Seq replicas = (Seq)$this.controllerContext.partitionReplicaAssignment().apply((Object)partition);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
        $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)recipientsPerPartition$1.apply((Object)partition)), partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicas, false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$leaderForOffline$1(PartitionStateMachine $this, Tuple2 x0$19) {
        Tuple2 tuple2 = x0$19;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
        List liveInSyncReplicas = (List)leaderIsrAndControllerEpoch.leaderAndIsr().isr().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition, $this.controllerContext.isReplicaOnline$default$3()));
        boolean bl = liveInSyncReplicas.isEmpty();
        return bl;
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForOffline$8(PartitionStateMachine $this, TopicPartition partition$4, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, List isr$1, int leader) {
        List newIsr = isr$1.contains((Object)BoxesRunTime.boxToInteger((int)leader)) ? (List)isr$1.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)replica -> $this.controllerContext.isReplicaOnline(replica, partition$4, $this.controllerContext.isReplicaOnline$default$3())) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader}));
        return leaderIsrAndControllerEpoch$1.leaderAndIsr().newLeaderAndIsr(leader, (List<Object>)newIsr);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForReassign$3(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$2, int leader) {
        return leaderIsrAndControllerEpoch$2.leaderAndIsr().newLeader(leader);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForPreferredReplica$3(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$3, int leader) {
        return leaderIsrAndControllerEpoch$3.leaderAndIsr().newLeader(leader);
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForControlledShutdown$4(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$4, List newIsr$1, int leader) {
        return leaderIsrAndControllerEpoch$4.leaderAndIsr().newLeaderAndIsr(leader, (List<Object>)newIsr$1);
    }

    public PartitionStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, TopicDeletionManager topicDeletionManager, KafkaZkClient zkClient, Map<TopicPartition, PartitionState> partitionState, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.config = config;
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.topicDeletionManager = topicDeletionManager;
        this.zkClient = zkClient;
        this.partitionState = partitionState;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[PartitionStateMachine controllerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId())})));
    }
}

