/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.log;

import io.confluent.kafka.log.CleanerConfig;
import io.confluent.kafka.log.LogCleaner$;
import io.confluent.kafka.log.LogConfig;
import io.confluent.kafka.log.LogConfig$;
import io.confluent.kafka.log.LogManager;
import io.confluent.kafka.server.BrokerState;
import io.confluent.kafka.server.BrokerTopicStats;
import io.confluent.kafka.server.KafkaConfig;
import io.confluent.kafka.server.KafkaServer$;
import io.confluent.kafka.server.LogDirFailureChannel;
import io.confluent.kafka.utils.KafkaScheduler;
import io.confluent.kafka.zk.KafkaZkClient;
import io.confluent.org.apache.kafka.common.utils.Time;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;

public final class LogManager$ {
    public static LogManager$ MODULE$;
    private final String RecoveryPointCheckpointFile;
    private final String LogStartOffsetCheckpointFile;
    private final int ProducerIdExpirationCheckIntervalMs;

    static {
        new LogManager$();
    }

    public String RecoveryPointCheckpointFile() {
        return this.RecoveryPointCheckpointFile;
    }

    public String LogStartOffsetCheckpointFile() {
        return this.LogStartOffsetCheckpointFile;
    }

    public int ProducerIdExpirationCheckIntervalMs() {
        return this.ProducerIdExpirationCheckIntervalMs;
    }

    public LogManager apply(KafkaConfig config, Seq<String> initialOfflineDirs, KafkaZkClient zkClient, BrokerState brokerState, KafkaScheduler kafkaScheduler, Time time, BrokerTopicStats brokerTopicStats, LogDirFailureChannel logDirFailureChannel) {
        java.util.Map<String, Object> defaultProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(config);
        LogConfig defaultLogConfig = new LogConfig(defaultProps, LogConfig$.MODULE$.apply$default$2());
        Tuple2<scala.collection.immutable.Map<String, LogConfig>, scala.collection.immutable.Map<String, Exception>> tuple2 = zkClient.getLogConfigs(zkClient.getAllTopicsInCluster(), defaultProps);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map topicConfigs = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map failed = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topicConfigs, (Object)failed);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Map topicConfigs2 = (scala.collection.immutable.Map)tuple23._1();
        scala.collection.immutable.Map failed2 = (scala.collection.immutable.Map)tuple23._2();
        if (!failed2.isEmpty()) {
            throw (Throwable)((Tuple2)failed2.head())._2();
        }
        CleanerConfig cleanerConfig = LogCleaner$.MODULE$.cleanerConfig(config);
        return new LogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$24 -> new File((String)x$24).getAbsoluteFile(), Seq$.MODULE$.canBuildFrom())), (Seq<File>)((Seq)initialOfflineDirs.map((Function1 & Serializable & scala.Serializable)x$25 -> new File((String)x$25).getAbsoluteFile(), Seq$.MODULE$.canBuildFrom())), (Map<String, LogConfig>)topicConfigs2, defaultLogConfig, cleanerConfig, Predef$.MODULE$.Integer2int(config.numRecoveryThreadsPerDataDir()), Predef$.MODULE$.Long2long(config.logFlushSchedulerIntervalMs()), config.logFlushOffsetCheckpointIntervalMs(), config.logFlushStartOffsetCheckpointIntervalMs(), Predef$.MODULE$.Long2long(config.logCleanupIntervalMs()), Predef$.MODULE$.Integer2int(config.transactionIdExpirationMs()), kafkaScheduler, brokerState, brokerTopicStats, logDirFailureChannel, time);
    }

    private LogManager$() {
        MODULE$ = this;
        this.RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
        this.LogStartOffsetCheckpointFile = "log-start-offset-checkpoint";
        this.ProducerIdExpirationCheckIntervalMs = 600000;
    }
}

