/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import io.confluent.kafka.cluster.BrokerEndPoint;
import io.confluent.kafka.metrics.KafkaMetricsGroup;
import io.confluent.kafka.server.AbstractFetcherManager$;
import io.confluent.kafka.server.AbstractFetcherThread;
import io.confluent.kafka.server.BrokerAndFetcherId;
import io.confluent.kafka.server.BrokerAndInitialOffset;
import io.confluent.kafka.server.BrokerIdAndFetcherId;
import io.confluent.kafka.server.FetcherLagMetrics;
import io.confluent.kafka.utils.Logging;
import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.utils.Utils;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de!B\u0001\u0003\u0003\u00039!AF!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u000f)A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\tq!\\3ue&\u001c7/\u0003\u0002\u001a-\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\t\u0011m\u0001!Q1A\u0005\u0012q\tAA\\1nKV\tQ\u0004\u0005\u0002\u001fK9\u0011qd\t\t\u0003A)i\u0011!\t\u0006\u0003E\u0019\ta\u0001\u0010:p_Rt\u0014B\u0001\u0013\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011ae\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011R\u0001\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u000b9\fW.\u001a\u0011\t\u0011-\u0002!\u0011!Q\u0001\nu\t\u0001b\u00197jK:$\u0018\n\u001a\u0005\t[\u0001\u0011\t\u0011)A\u0005]\u0005Ya.^7GKR\u001c\u0007.\u001a:t!\tIq&\u0003\u00021\u0015\t\u0019\u0011J\u001c;\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\u0011!dg\u000e\u001d\u0011\u0005U\u0002Q\"\u0001\u0002\t\u000bm\t\u0004\u0019A\u000f\t\u000b-\n\u0004\u0019A\u000f\t\u000f5\n\u0004\u0013!a\u0001]!A!\b\u0001b\u0001\n\u0003\u00111(\u0001\tgKR\u001c\u0007.\u001a:UQJ,\u0017\rZ'baV\tA\b\u0005\u0003>\u0005\u0012;U\"\u0001 \u000b\u0005}\u0002\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u0003*\t!bY8mY\u0016\u001cG/[8o\u0013\t\u0019eHA\u0004ICNDW*\u00199\u0011\u0005U*\u0015B\u0001$\u0003\u0005Q\u0011%o\\6fe&#\u0017I\u001c3GKR\u001c\u0007.\u001a:JIB\u0011Q\u0007S\u0005\u0003\u0013\n\u0011Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\r\u0003\u0004L\u0001\u0001\u0006I\u0001P\u0001\u0012M\u0016$8\r[3s)\"\u0014X-\u00193NCB\u0004\u0003bB'\u0001\u0005\u0004%IAT\u0001\u0005Y>\u001c7.F\u0001P!\t\u0001V+D\u0001R\u0015\t\u00116+\u0001\u0003mC:<'\"\u0001+\u0002\t)\fg/Y\u0005\u0003-F\u0013aa\u00142kK\u000e$\bB\u0002-\u0001A\u0003%q*A\u0003m_\u000e\\\u0007\u0005C\u0004[\u0001\u0001\u0007I\u0011B.\u0002)9,XNR3uG\",'o\u001d)fe\n\u0013xn[3s+\u0005q\u0003bB/\u0001\u0001\u0004%IAX\u0001\u0019]Vlg)\u001a;dQ\u0016\u00148\u000fU3s\u0005J|7.\u001a:`I\u0015\fHCA0c!\tI\u0001-\u0003\u0002b\u0015\t!QK\\5u\u0011\u001d\u0019G,!AA\u00029\n1\u0001\u001f\u00132\u0011\u0019)\u0007\u0001)Q\u0005]\u0005)b.^7GKR\u001c\u0007.\u001a:t!\u0016\u0014(I]8lKJ\u0004\u0003\"B4\u0001\t\u0003A\u0017\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\ty\u0016\u000eC\u0003kM\u0002\u0007a&A\u0004oK^\u001c\u0016N_3\t\r1\u0004A\u0011\u0001\u0002n\u000319W\r\u001e$fi\u000eDWM]%e)\rqc\u000e\u001d\u0005\u0006_.\u0004\r!H\u0001\u0006i>\u0004\u0018n\u0019\u0005\u0006c.\u0004\rAL\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0003t\u0001\u0011\u0005A/A\u000enCJ\\\u0007+\u0019:uSRLwN\\:G_J$&/\u001e8dCRLwN\u001c\u000b\u0006?V<\u0018\u0011\u0002\u0005\u0006mJ\u0004\rAL\u0001\tEJ|7.\u001a:JI\")\u0001P\u001da\u0001s\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007c\u0001>\u0002\u00065\t1P\u0003\u0002}{\u000611m\\7n_:T!!\u0002@\u000b\u0007}\f\t!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0007\t1a\u001c:h\u0013\r\t9a\u001f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\tYA\u001da\u0001\u0003\u001b\t\u0001\u0003\u001e:v]\u000e\fG/[8o\u001f\u001a47/\u001a;\u0011\u0007%\ty!C\u0002\u0002\u0012)\u0011A\u0001T8oO\"9\u0011Q\u0003\u0001\u0007\u0002\u0005]\u0011aE2sK\u0006$XMR3uG\",'\u000f\u00165sK\u0006$G#B$\u0002\u001a\u0005u\u0001bBA\u000e\u0003'\u0001\rAL\u0001\nM\u0016$8\r[3s\u0013\u0012D\u0001\"a\b\u0002\u0014\u0001\u0007\u0011\u0011E\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005\u0003\u0002\u000f\rdWo\u001d;fe&!\u00111FA\u0013\u00059\u0011%o\\6fe\u0016sG\rU8j]RDq!a\f\u0001\t\u0003\t\t$A\fbI\u00124U\r^2iKJ4uN\u001d)beRLG/[8ogR\u0019q,a\r\t\u0011\u0005U\u0012Q\u0006a\u0001\u0003o\t1\u0003]1si&$\u0018n\u001c8B]\u0012|eMZ:fiN\u0004r!!\u000f\u0002<e\fy$D\u0001A\u0013\r\ti\u0004\u0011\u0002\u0004\u001b\u0006\u0004\bcA\u001b\u0002B%\u0019\u00111\t\u0002\u0003-\t\u0013xn[3s\u0003:$\u0017J\\5uS\u0006dwJ\u001a4tKRDq!a\u0012\u0001\t\u0003\tI%\u0001\u000esK6|g/\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0002`\u0003\u0017B\u0001\"!\u0014\u0002F\u0001\u0007\u0011qJ\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#BA\u001d\u0003#J\u0018bAA*\u0001\n\u00191+\u001a;\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z\u0005Q2\u000f[;uI><h.\u00133mK\u001a+Go\u00195feRC'/Z1egR\tq\fC\u0004\u0002^\u0001!\t!!\u0017\u0002!\rdwn]3BY24U\r^2iKJ\u001cx!CA1\u0005\u0005\u0005\t\u0012AA2\u0003Y\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\bcA\u001b\u0002f\u0019A\u0011AAA\u0001\u0012\u0003\t9gE\u0002\u0002f!AqAMA3\t\u0003\tY\u0007\u0006\u0002\u0002d!Q\u0011qNA3#\u0003%\t!!\u001d\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019HK\u0002/\u0003kZ#!a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003S\u0011AC1o]>$\u0018\r^5p]&!\u0011QQA>\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public abstract class AbstractFetcherManager
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<BrokerIdAndFetcherId, AbstractFetcherThread> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return AbstractFetcherManager$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractFetcherManager abstractFetcherManager = this;
        synchronized (abstractFetcherManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<BrokerIdAndFetcherId, AbstractFetcherThread> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resizing fetcher thread pool size from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentSize), BoxesRunTime.boxToInteger((int)newSize)})));
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
        }
    }

    public int getFetcherId(String topic, int partitionId) {
        int n;
        Object object = this.lock();
        synchronized (object) {
            n = Utils.abs(31 * topic.hashCode() + partitionId) % this.numFetchersPerBroker();
        }
        return n;
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition.topic(), topicPartition.partition());
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable & scala.Serializable)thread -> {
                thread.markPartitionsForTruncation(topicPartition, truncationOffset);
                return BoxedUnit.UNIT;
            });
        }
    }

    public abstract AbstractFetcherThread createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, BrokerAndInitialOffset> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Map partitionsPerFetcher = partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                BrokerAndInitialOffset brokerAndInitialFetchOffset = (BrokerAndInitialOffset)tuple2._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.broker(), this.getFetcherId(topicPartition.topic(), topicPartition.partition()));
                return brokerAndFetcherId;
            });
            partitionsPerFetcher.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, x$2);
                return BoxedUnit.UNIT;
            });
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Added fetcher for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionAndOffsets.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            BrokerAndInitialOffset brokerAndInitialOffset = (BrokerAndInitialOffset)tuple2._2();
            String string = "[" + topicPartition + ", initOffset " + brokerAndInitialOffset.initOffset() + " to broker " + brokerAndInitialOffset.broker() + "] ";
            return string;
        }, Iterable$.MODULE$.canBuildFrom())})));
    }

    public void removeFetcherForPartitions(Set<TopicPartition> partitions) {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> {
                fetcher.removePartitions((Set<TopicPartition>)partitions);
                return BoxedUnit.UNIT;
            });
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Removed fetcher for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitions.mkString(",")})));
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x$3;
                if (tuple2 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)tuple2._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$4)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$5);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
        }
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(AbstractFetcherManager $this, int newSize$2, Tuple2 x0$1) {
        Map<TopicPartition, BrokerAndInitialOffset> removedPartitions;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BrokerIdAndFetcherId id = (BrokerIdAndFetcherId)tuple2._1();
            AbstractFetcherThread thread = (AbstractFetcherThread)tuple2._2();
            removedPartitions = thread.partitionsAndOffsets();
            $this.removeFetcherForPartitions((Set<TopicPartition>)removedPartitions.keySet());
            if (id.fetcherId() >= newSize$2) {
                thread.shutdown();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        $this.addFetcherForPartitions(removedPartitions);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void migratePartitions$1(int newSize) {
        this.fetcherThreadMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(this, newSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        AbstractFetcherThread fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, (Object)fetcherThread);
        fetcherThread.start();
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$addFetcherForPartitions$4(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        BrokerAndInitialOffset brokerAndInitOffset = (BrokerAndInitialOffset)tuple2._2();
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)brokerAndInitOffset.initOffset()));
        return tuple22;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Tuple2 x$2) {
        var4_2 = x$2;
        if (var4_2 == null) ** GOTO lbl29
        brokerAndFetcherId = (BrokerAndFetcherId)var4_2._1();
        initialFetchOffsets = (Map)var4_2._2();
        brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
        var8_6 = false;
        var9_7 = null;
        var10_8 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
        if (!(var10_8 instanceof Some)) ** GOTO lbl-1000
        var8_6 = true;
        var9_7 = (Some)var10_8;
        f = (AbstractFetcherThread)var9_7.value();
        v0 = f.sourceBroker().host();
        var12_10 = brokerAndFetcherId.broker().host();
        if (!(v0 != null ? v0.equals(var12_10) == false : var12_10 != null) && f.sourceBroker().port() == brokerAndFetcherId.broker().port()) {
            var3_11 = BoxedUnit.UNIT;
        } else if (var8_6) {
            f = (AbstractFetcherThread)var9_7.value();
            f.shutdown();
            $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            var3_12 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(var10_8)) {
            $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            var3_13 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)var10_8);
lbl29:
            // 1 sources

            throw new MatchError((Object)var4_2);
        }
        ((AbstractFetcherThread)$this.fetcherThreadMap().apply((Object)brokerIdAndFetcherId)).addPartitions((Map<TopicPartition, Object>)((Map)initialFetchOffsets.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)(), Map$.MODULE$.canBuildFrom())));
        var2_15 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
        boolean bl = fetcher.initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbstractFetcherThread fetcher = (AbstractFetcherThread)tuple2._2();
        fetcher.shutdown();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers) {
        this.name = name;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.logIdent_$eq("[" + name + "] ");
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public long value() {
                return BoxesRunTime.unboxToLong((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$1(BoxesRunTime.unboxToLong((Object)curMaxAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ long $anonfun$value$2(long curMaxThread, Tuple2 fetcherLagStatsEntry) {
                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(curMaxThread), ((FetcherLagMetrics)fetcherLagStatsEntry._2()).lag());
            }

            public static final /* synthetic */ long $anonfun$value$1(long curMaxAll, Tuple2 fetcherThreadMapEntry) {
                return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherLagStats().stats().foldLeft(BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxThread, fetcherLagStatsEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$2(BoxesRunTime.unboxToLong((Object)curMaxThread), fetcherLagStatsEntry))))), curMaxAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(java.lang.Object scala.Tuple2 ), $anonfun$value$2$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public double value() {
                double headRate = BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$3(x$1))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
                return BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$5(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ double $anonfun$value$3(Tuple2 x$1) {
                return ((AbstractFetcherThread)x$1._2()).fetcherStats().requestRate().oneMinuteRate();
            }

            public static final /* synthetic */ double $anonfun$value$5(double curMinAll, Tuple2 fetcherThreadMapEntry) {
                return RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherStats().requestRate().oneMinuteRate()), curMinAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3$adapted(scala.Tuple2 ), $anonfun$value$4(), $anonfun$value$5$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))));
    }
}

