/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.api.LeaderAndIsr$;
import io.confluent.kafka.cluster.Broker;
import io.confluent.kafka.cluster.EndPoint;
import io.confluent.kafka.common.TopicAndPartition;
import io.confluent.kafka.controller.StateChangeLogger;
import io.confluent.kafka.utils.CoreUtils$;
import io.confluent.kafka.utils.Logging;
import io.confluent.org.apache.kafka.common.Node;
import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.internals.Topic;
import io.confluent.org.apache.kafka.common.network.ListenerName;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.requests.MetadataResponse;
import io.confluent.org.apache.kafka.common.requests.UpdateMetadataRequest;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u0001\u0003\u0001\u001d\u0011Q\"T3uC\u0012\fG/Y\"bG\",'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oO\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0005ce>\\WM]%e!\tIq#\u0003\u0002\u0019\u0015\t\u0019\u0011J\u001c;\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\tab\u0004\u0005\u0002\u001e\u00015\t!\u0001C\u0003\u00163\u0001\u0007a\u0003C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\u000b\r\f7\r[3\u0016\u0003\t\u0002Ba\t\u0015+k5\tAE\u0003\u0002&M\u00059Q.\u001e;bE2,'BA\u0014\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003S\u0011\u00121!T1q!\tY#G\u0004\u0002-aA\u0011QFC\u0007\u0002])\u0011qFB\u0001\u0007yI|w\u000e\u001e \n\u0005ER\u0011A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\u0006\u0011\t\rBcC\u000e\t\u0003o\u0011s!\u0001\u000f\"\u000e\u0003eR!AO\u001e\u0002\u0011I,\u0017/^3tiNT!\u0001P\u001f\u0002\r\r|W.\\8o\u0015\t)aH\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<\u0017BA\":\u0003U)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgRL!!\u0012$\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK*\u00111)\u000f\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\u0012\u0002\r\r\f7\r[3!\u0011\u001dQ\u0005\u00011A\u0005\n-\u000bAbY8oiJ|G\u000e\\3s\u0013\u0012,\u0012\u0001\u0014\t\u0004\u001353\u0012B\u0001(\u000b\u0005\u0019y\u0005\u000f^5p]\"9\u0001\u000b\u0001a\u0001\n\u0013\t\u0016\u0001E2p]R\u0014x\u000e\u001c7fe&#w\fJ3r)\t\u0011V\u000b\u0005\u0002\n'&\u0011AK\u0003\u0002\u0005+:LG\u000fC\u0004W\u001f\u0006\u0005\t\u0019\u0001'\u0002\u0007a$\u0013\u0007\u0003\u0004Y\u0001\u0001\u0006K\u0001T\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011)\u0005]S\u0006CA\u0005\\\u0013\ta&B\u0001\u0005w_2\fG/\u001b7f\u0011\u001dq\u0006A1A\u0005\n}\u000bA\"\u00197jm\u0016\u0014%o\\6feN,\u0012\u0001\u0019\t\u0005G!2\u0012\r\u0005\u0002cK6\t1M\u0003\u0002e\t\u000591\r\\;ti\u0016\u0014\u0018B\u00014d\u0005\u0019\u0011%o\\6fe\"1\u0001\u000e\u0001Q\u0001\n\u0001\fQ\"\u00197jm\u0016\u0014%o\\6feN\u0004\u0003b\u00026\u0001\u0005\u0004%Ia[\u0001\u000bC2Lg/\u001a(pI\u0016\u001cX#\u00017\u0011\t\rBc#\u001c\t\u0005]>\u0004h/D\u0001'\u0013\tIc\u0005\u0005\u0002ri6\t!O\u0003\u0002tw\u00059a.\u001a;x_J\\\u0017BA;s\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f!\t9\b0D\u0001<\u0013\tI8H\u0001\u0003O_\u0012,\u0007BB>\u0001A\u0003%A.A\u0006bY&4XMT8eKN\u0004\u0003bB?\u0001\u0005\u0004%IA`\u0001\u0016a\u0006\u0014H/\u001b;j_:lU\r^1eCR\fGj\\2l+\u0005y\b\u0003BA\u0001\u0003'i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003\u0013\tY!\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0004\u0002\u0010\u0005!Q\u000f^5m\u0015\t\t\t\"\u0001\u0003kCZ\f\u0017\u0002BA\u000b\u0003\u0007\u0011aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m\u001b\u0005\b\u00033\u0001\u0001\u0015!\u0003\u0000\u0003Y\u0001\u0018M\u001d;ji&|g.T3uC\u0012\fG/\u0019'pG.\u0004\u0003\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0003\u0003C\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O!\u0011AC2p]R\u0014x\u000e\u001c7fe&!\u00111FA\u0013\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\"\u0005\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003k\tAbZ3u\u000b:$\u0007o\\5oiN$\u0002\"a\u000e\u0002>\u0005M\u0013q\u000b\t\u0005]\u0006eb/C\u0002\u0002<\u0019\u00121aU3r\u0011!\ty$!\rA\u0002\u0005\u0005\u0013a\u00022s_.,'o\u001d\t\u0006\u0003\u0007\niE\u0006\b\u0005\u0003\u000b\nIED\u0002.\u0003\u000fJ\u0011aC\u0005\u0004\u0003\u0017R\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\n\tF\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tYE\u0003\u0005\b\u0003+\n\t\u00041\u0001q\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f\u0011!\tI&!\rA\u0002\u0005m\u0013A\u00074jYR,'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bcA\u0005\u0002^%\u0019\u0011q\f\u0006\u0003\u000f\t{w\u000e\\3b]\"9\u00111\r\u0001\u0005\n\u0005\u0015\u0014\u0001F4fiB\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0005\u0002h\u0005e\u0014QPA@!\u0011IQ*!\u001b\u0011\r\u0005\r\u0013QJA6!\u0011\ti'a\u001d\u000f\u0007a\ny'C\u0002\u0002re\n\u0001#T3uC\u0012\fG/\u0019*fgB|gn]3\n\t\u0005U\u0014q\u000f\u0002\u0012!\u0006\u0014H/\u001b;j_:lU\r^1eCR\f'bAA9s!9\u00111PA1\u0001\u0004Q\u0013!\u0002;pa&\u001c\u0007bBA+\u0003C\u0002\r\u0001\u001d\u0005\t\u0003\u0003\u000b\t\u00071\u0001\u0002\\\u0005IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.Z#oIB|\u0017N\u001c;t\u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\u000b\u0001cZ3u\u00032Lg/Z#oIB|\u0017N\u001c;\u0015\r\u0005%\u00151RAG!\rIQJ\u001e\u0005\u0007+\u0005\r\u0005\u0019\u0001\f\t\u000f\u0005U\u00131\u0011a\u0001a\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0015\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b)!\t)*!(\u0002(\u0006%\u0006#\u00028\u0002:\u0005]\u0005\u0003BA7\u00033KA!a'\u0002x\tiAk\u001c9jG6+G/\u00193bi\u0006D\u0001\"a(\u0002\u0010\u0002\u0007\u0011\u0011U\u0001\u0007i>\u0004\u0018nY:\u0011\t9\f\u0019KK\u0005\u0004\u0003K3#aA*fi\"9\u0011QKAH\u0001\u0004\u0001\bBCAA\u0003\u001f\u0003\n\u00111\u0001\u0002\\!9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0016\u0001D4fi\u0006cG\u000eV8qS\u000e\u001cHCAAQ\u0011\u001d\t\u0019\f\u0001C\u0001\u0003k\u000bAcZ3u\u001d>tW\t_5ti&tw\rV8qS\u000e\u001cH\u0003BAQ\u0003oC\u0001\"a(\u00022\u0002\u0007\u0011\u0011\u0015\u0005\b\u0003w\u0003A\u0011AA_\u00035I7O\u0011:pW\u0016\u0014\u0018\t\\5wKR!\u00111LA`\u0011\u0019)\u0012\u0011\u0018a\u0001-!9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0017aD4fi\u0006c\u0017N^3Ce>\\WM]:\u0016\u0005\u0005\u001d\u0007\u0003\u00028\u0002:\u0005Dq!a3\u0001\t\u0013\ti-\u0001\rbI\u0012|%/\u00169eCR,\u0007+\u0019:uSRLwN\\%oM>$rAUAh\u0003#\f)\u000eC\u0004\u0002|\u0005%\u0007\u0019\u0001\u0016\t\u000f\u0005M\u0017\u0011\u001aa\u0001-\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\t9.!3A\u0002Y\n\u0011b\u001d;bi\u0016LeNZ8\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\u0006\u0001r-\u001a;QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u0007\u0003?\f\t/a9\u0011\u0007%ie\u0007C\u0004\u0002|\u0005e\u0007\u0019\u0001\u0016\t\u000f\u0005M\u0017\u0011\u001ca\u0001-!9\u0011q\u001d\u0001\u0005\u0002\u0005%\u0018AG4fiB\u000b'\u000f^5uS>tG*Z1eKJ,e\u000e\u001a9pS:$H\u0003CAE\u0003W\fi/a<\t\u000f\u0005m\u0014Q\u001da\u0001U!9\u00111[As\u0001\u00041\u0002bBA+\u0003K\u0004\r\u0001\u001d\u0005\u0007\u0003g\u0004A\u0011A&\u0002\u001f\u001d,GoQ8oiJ|G\u000e\\3s\u0013\u0012Dq!a>\u0001\t\u0003\tI0A\u0006va\u0012\fG/Z\"bG\",GCBA~\u0005\u0007\u00119\u0001E\u0003o\u0003s\ti\u0010E\u0002x\u0003\u007fL1A!\u0001<\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DqA!\u0002\u0002v\u0002\u0007a#A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\t\u0005\u0013\t)\u00101\u0001\u0003\f\u0005)R\u000f\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\bc\u0001\u001d\u0003\u000e%\u0019!qB\u001d\u0003+U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\"9!1\u0003\u0001\u0005\u0002\tU\u0011\u0001C2p]R\f\u0017N\\:\u0015\t\u0005m#q\u0003\u0005\b\u0003w\u0012\t\u00021\u0001+\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u00057!B!a\u0017\u0003\u001e!A!q\u0004B\r\u0001\u0004\ti0\u0001\u0002ua\"9!1\u0005\u0001\u0005\n\t\u0015\u0012a\u0005:f[>4X\rU1si&$\u0018n\u001c8J]\u001a|GCBA.\u0005O\u0011I\u0003C\u0004\u0002|\t\u0005\u0002\u0019\u0001\u0016\t\u000f\u0005M'\u0011\u0005a\u0001-!I!Q\u0006\u0001\u0012\u0002\u0013\u0005!qF\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$HeM\u000b\u0003\u0005cQC!a\u0017\u00034-\u0012!Q\u0007\t\u0005\u0005o\u0011\t%\u0004\u0002\u0003:)!!1\bB\u001f\u0003%)hn\u00195fG.,GMC\u0002\u0003@)\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019E!\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class MetadataCache
implements Logging {
    private final int brokerId;
    private final scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, UpdateMetadataRequest.PartitionState>> cache;
    private volatile Option<Object> controllerId;
    private final scala.collection.mutable.Map<Object, Broker> aliveBrokers;
    private final scala.collection.mutable.Map<Object, Map<ListenerName, Node>> aliveNodes;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, UpdateMetadataRequest.PartitionState>> cache() {
        return this.cache;
    }

    private Option<Object> controllerId() {
        return this.controllerId;
    }

    private void controllerId_$eq(Option<Object> x$1) {
        this.controllerId = x$1;
    }

    private scala.collection.mutable.Map<Object, Broker> aliveBrokers() {
        return this.aliveBrokers;
    }

    private scala.collection.mutable.Map<Object, Map<ListenerName, Node>> aliveNodes() {
        return this.aliveNodes;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private Seq<Node> getEndpoints(Iterable<Object> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        ArrayBuffer result = new ArrayBuffer(package$.MODULE$.min(this.aliveBrokers().size(), brokers.size()));
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            None$ none$;
            Option<Node> option = this.getAliveEndpoint(brokerId, listenerName);
            if (None$.MODULE$.equals(option)) {
                none$ = !filterUnavailableEndpoints ? new Some((Object)new Node(brokerId, "", -1)) : None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Node node = (Node)some.value();
                none$ = new Some((Object)node);
            } else {
                throw new MatchError(option);
            }
            None$ endpoint = none$;
            endpoint.foreach((Function1 & Serializable & scala.Serializable)elem -> result.$plus$eq(elem));
        });
        return result;
    }

    private Option<Iterable<MetadataResponse.PartitionMetadata>> getPartitionMetadata(String topic, ListenerName listenerName, boolean errorUnavailableEndpoints) {
        return this.cache().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataResponse.PartitionMetadata partitionMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int partitionId = tuple2._1$mcI$sp();
            UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)tuple2._2();
            TopicAndPartition topicPartition = new TopicAndPartition(topic, partitionId);
            Option<Node> maybeLeader = this.getAliveEndpoint(partitionState.basePartitionState.leader, listenerName);
            Buffer replicas = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.replicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1)), Buffer$.MODULE$.canBuildFrom());
            Seq<Node> replicaInfo = this.getEndpoints((Iterable<Object>)replicas, listenerName, errorUnavailableEndpoints);
            Seq<Node> offlineReplicaInfo = this.getEndpoints((Iterable<Object>)((Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.offlineReplicas).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)), Buffer$.MODULE$.canBuildFrom())), listenerName, errorUnavailableEndpoints);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": leader not available"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.LEADER_NOT_AVAILABLE, partitionId, Node.noNode(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), Collections.emptyList(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                return partitionMetadata;
            } else {
                MetadataResponse.PartitionMetadata partitionMetadata2;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Node leader = (Node)some.value();
                Buffer isr = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.basePartitionState.isr).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)), Buffer$.MODULE$.canBuildFrom());
                Seq<Node> isrInfo = this.getEndpoints((Iterable<Object>)isr, listenerName, errorUnavailableEndpoints);
                if (replicaInfo.size() < replicas.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Object[] objectArray = new Object[1];
                        Seq seq = (Seq)replicaInfo.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Seq$.MODULE$.canBuildFrom());
                        objectArray[0] = ((TraversableOnce)replicas.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",");
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": replica information not available for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"following brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else if (isrInfo.size() < isr.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        Object[] objectArray = new Object[1];
                        Seq seq = (Seq)isrInfo.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Seq$.MODULE$.canBuildFrom());
                        objectArray[0] = ((TraversableOnce)isr.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",");
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while fetching metadata for ", ": in sync replica information not available for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"following brokers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, partitionId, leader, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else {
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, partitionId, leader, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                }
                partitionMetadata = partitionMetadata2;
            }
            return partitionMetadata;
        }, Iterable$.MODULE$.canBuildFrom()));
    }

    private Option<Node> getAliveEndpoint(int brokerId, ListenerName listenerName) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)brokerId)).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get((Object)listenerName)));
    }

    public Seq<MetadataResponse.TopicMetadata> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints) {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata((String)topic, listenerName, errorUnavailableEndpoints).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponse.TopicMetadata(Errors.NONE, (String)topic, Topic.isInternal(topic), (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom()));
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public Set<String> getAllTopics() {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().keySet().toSet());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> (Set)topics.$minus$minus((GenTraversableOnce)this.cache().keySet()));
    }

    public boolean isBrokerAlive(int brokerId) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.aliveBrokers().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))));
    }

    public Seq<Broker> getAliveBrokers() {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.aliveBrokers().values().toBuffer());
    }

    private void addOrUpdatePartitionInfo(String topic, int partitionId, UpdateMetadataRequest.PartitionState stateInfo) {
        CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map infos = (scala.collection.mutable.Map)this.cache().getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
            infos.update((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)stateInfo);
        });
    }

    public Option<UpdateMetadataRequest.PartitionState> getPartitionInfo(String topic, int partitionId) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get((Object)BoxesRunTime.boxToInteger((int)partitionId))));
    }

    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        return (Option)CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> this.cache().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.get((Object)BoxesRunTime.boxToInteger((int)partitionId))).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.basePartitionState.leader;
            Option option = this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)leaderId));
            if (option instanceof Some) {
                Some some = (Some)option;
                Map nodeMap = (Map)some.value();
                node = (Node)nodeMap.getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        }));
    }

    public Option<Object> getControllerId() {
        return this.controllerId();
    }

    public Seq<TopicPartition> updateCache(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        return (Seq)CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (Function0 & Serializable & scala.Serializable)() -> {
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            this.controllerId_$eq((Option<Object>)(n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n))));
            this.aliveNodes().clear();
            this.aliveBrokers().clear();
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)broker -> {
                MetadataCache.$anonfun$updateCache$2(this, broker);
                return BoxedUnit.UNIT;
            });
            this.aliveNodes().get((Object)BoxesRunTime.boxToInteger((int)$this.brokerId)).foreach((Function1 & Serializable & scala.Serializable)listenerMap -> {
                MetadataCache.$anonfun$updateCache$4(this, listenerMap);
                return BoxedUnit.UNIT;
            });
            ArrayBuffer deletedPartitions = new ArrayBuffer();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    UpdateMetadataRequest.PartitionState info = (UpdateMetadataRequest.PartitionState)tuple2._2();
                    int controllerId = updateMetadataRequest.controllerId();
                    int controllerEpoch = updateMetadataRequest.controllerEpoch();
                    if (info.basePartitionState.leader == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                        this.removePartitionInfo(tp.topic(), tp.partition());
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted partition ", " from metadata cache in response to UpdateMetadata "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request sent by controller ", " epoch ", " with correlation id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)controllerEpoch), BoxesRunTime.boxToInteger((int)correlationId)})));
                        boxedUnit = deletedPartitions.$plus$eq((Object)tp);
                    } else {
                        this.addOrUpdatePartitionInfo(tp.topic(), tp.partition(), info);
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cached leader info ", " for partition ", " in response to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info, tp})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UpdateMetadata request sent by controller ", " epoch ", " with correlation id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)controllerEpoch), BoxesRunTime.boxToInteger((int)correlationId)})));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            return deletedPartitions;
        });
    }

    public boolean contains(String topic) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inReadLock(this.partitionMetadataLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.cache().contains((Object)topic)));
    }

    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(String topic, int partitionId) {
        return this.cache().get((Object)topic).exists((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$removePartitionInfo$1(this, topic, partitionId, infos)));
    }

    public static final /* synthetic */ void $anonfun$updateCache$2(MetadataCache $this, UpdateMetadataRequest.Broker broker) {
        HashMap nodes = new HashMap();
        ArrayBuffer endPoints = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(broker.endPoints).asScala()).foreach((Function1 & Serializable & scala.Serializable)ep -> {
            endPoints.$plus$eq((Object)new EndPoint(ep.host, ep.port, ep.listenerName, ep.securityProtocol));
            return nodes.put(ep.listenerName, new Node(broker$1.id, ep.host, ep.port));
        });
        $this.aliveBrokers().update((Object)BoxesRunTime.boxToInteger((int)broker.id), (Object)new Broker(broker.id, (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack)));
        $this.aliveNodes().update((Object)BoxesRunTime.boxToInteger((int)broker.id), JavaConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$updateCache$5(Set listeners$1, Map x$9) {
        Set set = x$9.keySet();
        Set set2 = listeners$1;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateCache$4(MetadataCache $this, Map listenerMap) {
        block0: {
            Set listeners = listenerMap.keySet();
            if ($this.aliveNodes().values().forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$updateCache$5(listeners, x$9)))) break block0;
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listeners are not identical across brokers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.aliveNodes()})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(MetadataCache $this, String topic$6, int partitionId$4, scala.collection.mutable.Map infos) {
        infos.remove((Object)BoxesRunTime.boxToInteger((int)partitionId$4));
        Object object = infos.isEmpty() ? $this.cache().remove((Object)topic$6) : BoxedUnit.UNIT;
        return true;
    }

    public MetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.cache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.controllerId = None$.MODULE$;
        this.aliveBrokers = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.aliveNodes = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[MetadataCache brokerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})));
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

