/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.shaded.serializers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.confluent.kafka.shaded.serializers.KafkaJsonSerializerConfig;
import io.confluent.org.apache.kafka.common.errors.SerializationException;
import io.confluent.org.apache.kafka.common.serialization.Serializer;
import java.util.Map;

public class KafkaJsonSerializer<T>
implements Serializer<T> {
    private ObjectMapper objectMapper;

    @Override
    public void configure(Map<String, ?> config, boolean isKey) {
        this.configure(new KafkaJsonSerializerConfig(config));
    }

    protected void configure(KafkaJsonSerializerConfig config) {
        boolean prettyPrint = config.getBoolean("json.indent.output");
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, prettyPrint);
    }

    @Override
    public byte[] serialize(String topic, T data) {
        if (data == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes(data);
        }
        catch (Exception e) {
            throw new SerializationException("Error serializing JSON message", e);
        }
    }

    @Override
    public void close() {
    }
}

