/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.common.MessageFormatter;
import io.confluent.kafka.tools.DefaultMessageFormatter;
import io.confluent.org.apache.kafka.clients.consumer.ConsumerRecord;
import io.confluent.org.apache.kafka.common.record.TimestampType;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u000f\t9Bj\\4hS:<W*Z:tC\u001e,gi\u001c:nCR$XM\u001d\u0006\u0003\u0007\u0011\tQ\u0001^8pYNT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!\u0001\u0004d_6lwN\\\u0005\u0003'A\u0011\u0001#T3tg\u0006<WMR8s[\u0006$H/\u001a:\u0011\u0005UaR\"\u0001\f\u000b\u0005]A\u0012\u0001D:dC2\fGn\\4hS:<'BA\r\u001b\u0003!!\u0018\u0010]3tC\u001a,'\"A\u000e\u0002\u0007\r|W.\u0003\u0002\u001e-\tYA*\u0019>z\u0019><w-\u001b8h\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\t!\u0001C\u0004%\u0001\t\u0007I\u0011B\u0013\u0002\u001b\u0011,g-Y;mi^\u0013\u0018\u000e^3s+\u00051\u0003C\u0001\u0012(\u0013\tA#AA\fEK\u001a\fW\u000f\u001c;NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e;fe\"1!\u0006\u0001Q\u0001\n\u0019\na\u0002Z3gCVdGo\u0016:ji\u0016\u0014\b\u0005C\u0003-\u0001\u0011\u0005S&\u0001\u0003j]&$HC\u0001\u00182!\tIq&\u0003\u00021\u0015\t!QK\\5u\u0011\u0015\u00114\u00061\u00014\u0003\u0015\u0001(o\u001c9t!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003vi&d'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0015a\u0004\u0001\"\u0001>\u0003\u001d9(/\u001b;f)>$2A\f T\u0011\u0015y4\b1\u0001A\u00039\u0019wN\\:v[\u0016\u0014(+Z2pe\u0012\u0004B!Q&N\u001b6\t!I\u0003\u0002D\t\u0006A1m\u001c8tk6,'O\u0003\u0002F\r\u000691\r\\5f]R\u001c(BA\u0003H\u0015\tA\u0015*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051\u0013%AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\t\u0004\u00139\u0003\u0016BA(\u000b\u0005\u0015\t%O]1z!\tI\u0011+\u0003\u0002S\u0015\t!!)\u001f;f\u0011\u0015!6\b1\u0001V\u0003\u0019yW\u000f\u001e9viB\u0011a+W\u0007\u0002/*\u0011\u0001lN\u0001\u0003S>L!AW,\u0003\u0017A\u0013\u0018N\u001c;TiJ,\u0017-\u001c")
public class LoggingMessageFormatter
implements MessageFormatter,
LazyLogging {
    private final DefaultMessageFormatter defaultWriter;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public void close() {
        MessageFormatter.close$(this);
    }

    private Logger logger$lzycompute() {
        LoggingMessageFormatter loggingMessageFormatter = this;
        synchronized (loggingMessageFormatter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private DefaultMessageFormatter defaultWriter() {
        return this.defaultWriter;
    }

    @Override
    public void init(Properties props) {
        this.defaultWriter().init(props);
    }

    @Override
    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        BoxedUnit boxedUnit;
        this.defaultWriter().writeTo(consumerRecord, output);
        if (this.logger().underlying().isInfoEnabled()) {
            TimestampType timestampType = consumerRecord.timestampType();
            TimestampType timestampType2 = TimestampType.NO_TIMESTAMP_TYPE;
            this.logger().underlying().info(((timestampType == null ? timestampType2 != null : !((Object)((Object)timestampType)).equals((Object)timestampType2)) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerRecord.timestampType(), BoxesRunTime.boxToLong((long)consumerRecord.timestamp())})) : "") + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key:", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerRecord.key() == null ? "null" : new String(consumerRecord.key(), StandardCharsets.UTF_8)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumerRecord.value() == null ? "null" : new String(consumerRecord.value(), StandardCharsets.UTF_8)})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public LoggingMessageFormatter() {
        MessageFormatter.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.defaultWriter = new DefaultMessageFormatter();
    }
}

