/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.api.OffsetRequest$;
import io.confluent.kafka.consumer.Consumer$;
import io.confluent.kafka.consumer.ConsumerConfig;
import io.confluent.kafka.consumer.ConsumerConnector;
import io.confluent.kafka.consumer.KafkaStream;
import io.confluent.kafka.tools.ReplayLogProducer;
import io.confluent.kafka.utils.Logging;
import io.confluent.kafka.utils.ZkUtils$;
import java.io.Serializable;
import java.util.Properties;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ReplayLogProducer$
implements Logging {
    public static ReplayLogProducer$ MODULE$;
    private final String GroupId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplayLogProducer$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplayLogProducer$ replayLogProducer$ = this;
        synchronized (replayLogProducer$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private String GroupId() {
        return this.GroupId;
    }

    public void main(String[] args) {
        ReplayLogProducer.Config config = new ReplayLogProducer.Config(args);
        ZkUtils$.MODULE$.maybeDeletePath(config.zkConnect(), "/consumers/" + this.GroupId());
        Thread.sleep(500L);
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", this.GroupId());
        consumerProps.put("zookeeper.connect", config.zkConnect());
        consumerProps.put("consumer.timeout.ms", "10000");
        consumerProps.put("auto.offset.reset", OffsetRequest$.MODULE$.SmallestTimeString());
        consumerProps.put("fetch.message.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)0x100000)).toString());
        consumerProps.put("socket.receive.buffer.bytes", ((Object)BoxesRunTime.boxToInteger((int)0x200000)).toString());
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        Map<String, List<KafkaStream<byte[], byte[]>>> topicMessageStreams = consumerConnector.createMessageStreams((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)config.inputTopic()), (Object)BoxesRunTime.boxToInteger((int)config.numThreads()))}))));
        ObjectRef threadList = ObjectRef.create((Object)Nil$.MODULE$);
        topicMessageStreams.values().foreach((Function1 & Serializable & scala.Serializable)streamList -> {
            streamList.foreach((Function1 & Serializable & scala.Serializable)stream -> {
                threadList$1.elem = ((List)threadList$1.elem).$colon$colon((Object)new ReplayLogProducer.ZKConsumerThread(config$1, stream));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        ((List)threadList.elem).foreach((Function1 & Serializable & scala.Serializable)thread -> {
            thread.start();
            return BoxedUnit.UNIT;
        });
        ((List)threadList.elem).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        consumerConnector.shutdown();
    }

    private ReplayLogProducer$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.GroupId = "replay-log-producer";
    }
}

