/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.utils;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.message.CompressionCodec;
import io.confluent.kafka.message.CompressionCodec$;
import io.confluent.kafka.message.NoCompressionCodec$;
import io.confluent.kafka.utils.CoreUtils$;
import io.confluent.kafka.utils.Logging;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Properties;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001\u001d\u0011ACV3sS\u001aL\u0017M\u00197f!J|\u0007/\u001a:uS\u0016\u001c(BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\t9Aj\\4hS:<\u0007\u0002C\n\u0001\u0005\u000b\u0007I\u0011\u0001\u000b\u0002\u000bA\u0014x\u000e]:\u0016\u0003U\u0001\"AF\u000e\u000e\u0003]Q!\u0001G\r\u0002\tU$\u0018\u000e\u001c\u0006\u00025\u0005!!.\u0019<b\u0013\tarC\u0001\u0006Qe>\u0004XM\u001d;jKND\u0001B\b\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0007aJ|\u0007o\u001d\u0011\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\t\u00113\u0005\u0005\u0002\u0010\u0001!)1c\ba\u0001+!9Q\u0005\u0001b\u0001\n\u00131\u0013\u0001\u0004:fM\u0016\u0014XM\\2f'\u0016$X#A\u0014\u0011\u0007!js&D\u0001*\u0015\tQ3&A\u0004nkR\f'\r\\3\u000b\u00051R\u0011AC2pY2,7\r^5p]&\u0011a&\u000b\u0002\b\u0011\u0006\u001c\bnU3u!\t\u0001tG\u0004\u00022kA\u0011!GC\u0007\u0002g)\u0011AGB\u0001\u0007yI|w\u000e\u001e \n\u0005YR\u0011A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!A\u000e\u0006\t\rm\u0002\u0001\u0015!\u0003(\u00035\u0011XMZ3sK:\u001cWmU3uA!)\u0001\u0005\u0001C\u0001{Q\t!\u0005C\u0003@\u0001\u0011\u0005\u0001)A\u0006d_:$\u0018-\u001b8t\u0017\u0016LHCA!E!\tI!)\u0003\u0002D\u0015\t9!i\\8mK\u0006t\u0007\"B#?\u0001\u0004y\u0013\u0001\u00028b[\u0016DQa\u0012\u0001\u0005\u0002!\u000b1bZ3u!J|\u0007/\u001a:usR\u0011q&\u0013\u0005\u0006\u000b\u001a\u0003\ra\f\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0007O\u0016$\u0018J\u001c;\u0015\u00055\u0003\u0006CA\u0005O\u0013\ty%BA\u0002J]RDQ!\u0012&A\u0002=BQA\u0015\u0001\u0005\u0002M\u000bQbZ3u\u0013:$\u0018J\u001c*b]\u001e,GcA'U+\")Q)\u0015a\u0001_!)a+\u0015a\u0001/\u0006)!/\u00198hKB!\u0011\u0002W'N\u0013\tI&B\u0001\u0004UkBdWM\r\u0005\u0006\u0017\u0002!\ta\u0017\u000b\u0004\u001brk\u0006\"B#[\u0001\u0004y\u0003\"\u00020[\u0001\u0004i\u0015a\u00023fM\u0006,H\u000e\u001e\u0005\u0006A\u0002!\t!Y\u0001\tO\u0016$8\u000b[8siR\u0019!-\u001a4\u0011\u0005%\u0019\u0017B\u00013\u000b\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0015)u\f1\u00010\u0011\u0015qv\f1\u0001c\u0011\u0015\u0011\u0006\u0001\"\u0001i)\u0011i\u0015N[6\t\u000b\u0015;\u0007\u0019A\u0018\t\u000by;\u0007\u0019A'\t\u000bY;\u0007\u0019A,\t\u000b5\u0004A\u0011\u00018\u0002\u001f\u001d,Go\u00155peRLeNU1oO\u0016$BAY8qc\")Q\t\u001ca\u0001_!)a\f\u001ca\u0001E\")a\u000b\u001ca\u0001eB!\u0011\u0002\u00172c\u0011\u0015!\b\u0001\"\u0001v\u0003\u001d9W\r\u001e'p]\u001e$\"A^=\u0011\u0005%9\u0018B\u0001=\u000b\u0005\u0011auN\\4\t\u000b\u0015\u001b\b\u0019A\u0018\t\u000bQ\u0004A\u0011A>\u0015\u0007YdX\u0010C\u0003Fu\u0002\u0007q\u0006C\u0003_u\u0002\u0007a\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001\u000fO\u0016$Hj\u001c8h\u0013:\u0014\u0016M\\4f)\u001d1\u00181AA\u0003\u0003\u000fAQ!\u0012@A\u0002=BQA\u0018@A\u0002YDaA\u0016@A\u0002\u0005%\u0001\u0003B\u0005YmZDq!!\u0004\u0001\t\u0003\ty!A\u0005hKR$u.\u001e2mKR!\u0011\u0011CA\f!\rI\u00111C\u0005\u0004\u0003+Q!A\u0002#pk\ndW\r\u0003\u0004F\u0003\u0017\u0001\ra\f\u0005\b\u0003\u001b\u0001A\u0011AA\u000e)\u0019\t\t\"!\b\u0002 !1Q)!\u0007A\u0002=BqAXA\r\u0001\u0004\t\t\u0002C\u0004\u0002$\u0001!\t!!\n\u0002\u0015\u001d,GOQ8pY\u0016\fg\u000eF\u0003B\u0003O\tI\u0003\u0003\u0004F\u0003C\u0001\ra\f\u0005\u0007=\u0006\u0005\u0002\u0019A!\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002.Q\u0019\u0011)a\f\t\r\u0015\u000bY\u00031\u00010\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003k\t\u0011bZ3u'R\u0014\u0018N\\4\u0015\u000b=\n9$!\u000f\t\r\u0015\u000b\t\u00041\u00010\u0011\u0019q\u0016\u0011\u0007a\u0001_!9\u00111\u0007\u0001\u0005\u0002\u0005uBcA\u0018\u0002@!1Q)a\u000fA\u0002=Bq!a\u0011\u0001\t\u0003\t)%\u0001\u0004hKRl\u0015\r\u001d\u000b\u0007\u0003\u000f\ny%!\u0015\u0011\r\u0005%\u00131J\u00180\u001b\u0005Y\u0013bAA'W\t\u0019Q*\u00199\t\r\u0015\u000b\t\u00051\u00010\u0011)\t\u0019&!\u0011\u0011\u0002\u0003\u0007\u0011QK\u0001\u0006m\u0006d\u0017\u000e\u001a\t\u0006\u0013\u0005]s&Q\u0005\u0004\u00033R!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\n1cZ3u\u0007>l\u0007O]3tg&|gnQ8eK\u000e$b!!\u0019\u0002n\u0005=\u0004\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001dD!A\u0004nKN\u001c\u0018mZ3\n\t\u0005-\u0014Q\r\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000eDa!RA.\u0001\u0004y\u0003b\u00020\u0002\\\u0001\u0007\u0011\u0011\r\u0005\b\u0003g\u0002A\u0011AA;\u0003\u00191XM]5gsR\u0011\u0011q\u000f\t\u0004\u0013\u0005e\u0014bAA>\u0015\t!QK\\5u\u0011\u001d\ty\b\u0001C!\u0003\u0003\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002_!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011qQ\u0001\u0011O\u0016$X*\u00199%I\u00164\u0017-\u001e7uII*\"!!#+\t\u0005U\u00131R\u0016\u0003\u0003\u001b\u0003B!a$\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0013\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001c\u0006E%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class VerifiableProperties
implements Logging {
    private final Properties props;
    private final HashSet<String> referenceSet;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        VerifiableProperties verifiableProperties = this;
        synchronized (verifiableProperties) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Properties props() {
        return this.props;
    }

    private HashSet<String> referenceSet() {
        return this.referenceSet;
    }

    public boolean containsKey(String name) {
        return this.props().containsKey(name);
    }

    public String getProperty(String name) {
        String value = this.props().getProperty(name);
        this.referenceSet().add((Object)name);
        return value == null ? value : value.trim();
    }

    public int getInt(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(this.getString(name))).toInt();
    }

    public int getIntInRange(String name, Tuple2<Object, Object> range) {
        Predef$.MODULE$.require(this.containsKey(name), (Function0 & Serializable & scala.Serializable)() -> "Missing required property '" + name + "'");
        return this.getIntInRange(name, -1, range);
    }

    public int getInt(String name, int n) {
        return this.getIntInRange(name, n, (Tuple2<Object, Object>)new Tuple2.mcII.sp(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    public short getShort(String name, short s) {
        return this.getShortInRange(name, s, (Tuple2<Object, Object>)new Tuple2((Object)BoxesRunTime.boxToShort((short)Short.MIN_VALUE), (Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
    }

    public int getIntInRange(String name, int n, Tuple2<Object, Object> range) {
        int v = this.containsKey(name) ? new StringOps(Predef$.MODULE$.augmentString(this.getProperty(name))).toInt() : n;
        Predef$.MODULE$.require(v >= range._1$mcI$sp() && v <= range._2$mcI$sp(), (Function0 & Serializable & scala.Serializable)() -> name + " has value " + v + " which is not in the range " + range + ".");
        return v;
    }

    public short getShortInRange(String name, short s, Tuple2<Object, Object> range) {
        short v = this.containsKey(name) ? new StringOps(Predef$.MODULE$.augmentString(this.getProperty(name))).toShort() : s;
        Predef$.MODULE$.require(v >= BoxesRunTime.unboxToShort((Object)range._1()) && v <= BoxesRunTime.unboxToShort((Object)range._2()), (Function0 & Serializable & scala.Serializable)() -> name + " has value " + v + " which is not in the range " + range + ".");
        return v;
    }

    public long getLong(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(this.getString(name))).toLong();
    }

    public long getLong(String name, long l) {
        return this.getLongInRange(name, l, (Tuple2<Object, Object>)new Tuple2.mcJJ.sp(Long.MIN_VALUE, Long.MAX_VALUE));
    }

    public long getLongInRange(String name, long l, Tuple2<Object, Object> range) {
        long v = this.containsKey(name) ? new StringOps(Predef$.MODULE$.augmentString(this.getProperty(name))).toLong() : l;
        Predef$.MODULE$.require(v >= range._1$mcJ$sp() && v <= range._2$mcJ$sp(), (Function0 & Serializable & scala.Serializable)() -> name + " has value " + v + " which is not in the range " + range + ".");
        return v;
    }

    public double getDouble(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(this.getString(name))).toDouble();
    }

    public double getDouble(String name, double d) {
        return this.containsKey(name) ? this.getDouble(name) : d;
    }

    /*
     * Unable to fully structure code
     */
    public boolean getBoolean(String name, boolean default) {
        block3: {
            block2: {
                if (this.containsKey(name)) break block2;
                v0 = default;
                break block3;
            }
            v1 = v = this.getProperty(name);
            var4_4 = "true";
            if (!(v1 == null ? var4_4 != null : v1.equals(var4_4) == false)) ** GOTO lbl-1000
            v2 = v;
            var5_5 = "false";
            if (!(v2 != null ? v2.equals(var5_5) == false : var5_5 != null)) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            Predef$.MODULE$.require(v3, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getBoolean$1(java.lang.String ), ()Ljava/lang/String;)((String)name));
            v0 = new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean();
        }
        return v0;
    }

    public boolean getBoolean(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(this.getString(name))).toBoolean();
    }

    public String getString(String name, String string) {
        return this.containsKey(name) ? this.getProperty(name) : string;
    }

    public String getString(String name) {
        Predef$.MODULE$.require(this.containsKey(name), (Function0 & Serializable & scala.Serializable)() -> "Missing required property '" + name + "'");
        return this.getProperty(name);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> getMap(String name, Function1<String, Object> valid) {
        void v0;
        try {
            void var3_3;
            Map<String, String> m = CoreUtils$.MODULE$.parseCsvMap(this.getString(name, ""));
            m.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                VerifiableProperties.$anonfun$getMap$1(name, valid, x0$1);
                return BoxedUnit.UNIT;
            });
            v0 = var3_3;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Error parsing configuration property '%s': %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, e.getMessage()})));
        }
        return v0;
    }

    public Function1<String, Object> getMap$default$2() {
        return (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)VerifiableProperties.$anonfun$getMap$default$2$1(x$1));
    }

    public CompressionCodec getCompressionCodec(String name, CompressionCodec compressionCodec) {
        CompressionCodec compressionCodec2;
        String prop = this.getString(name, NoCompressionCodec$.MODULE$.name());
        try {
            compressionCodec2 = CompressionCodec$.MODULE$.getCompressionCodec(new StringOps(Predef$.MODULE$.augmentString(prop)).toInt());
        }
        catch (NumberFormatException numberFormatException) {
            compressionCodec2 = CompressionCodec$.MODULE$.getCompressionCodec(prop);
        }
        return compressionCodec2;
    }

    public void verify() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Verifying properties");
        Buffer propNames = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.list(this.props().propertyNames())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
        propNames.foreach((Function1 & Serializable & scala.Serializable)key -> {
            VerifiableProperties.$anonfun$verify$3(this, key);
            return BoxedUnit.UNIT;
        });
    }

    public String toString() {
        return this.props().toString();
    }

    public static final /* synthetic */ String $anonfun$getBoolean$1(String name$2) {
        return "Unacceptable value for property '" + name$2 + "', boolean values must be either 'true' or 'false";
    }

    public static final /* synthetic */ void $anonfun$getMap$1(String name$7, Function1 valid$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            if (!BoxesRunTime.unboxToBoolean((Object)valid$1.apply((Object)value))) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid entry '%s' = '%s' for property '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value, name$7})));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getMap$default$2$1(String x$1) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$verify$3(VerifiableProperties $this, String key) {
        if (!$this.referenceSet().contains((Object)key) && !key.startsWith("external")) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Property %s is not valid")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
        } else {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Property %s is overridden to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, $this.props().getProperty(key)})));
        }
    }

    public VerifiableProperties(Properties props) {
        this.props = props;
        Logging.$init$(this);
        this.referenceSet = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public VerifiableProperties() {
        this(new Properties());
    }
}

