/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.kafka.javaapi.consumer.ConsumerConnector;
import io.confluent.kafka.message.MessageAndMetadata;
import io.confluent.kafka.serializer.Decoder;
import io.confluent.kafka.shaded.serializers.KafkaAvroDecoder;
import io.confluent.kafka.utils.VerifiableProperties;
import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.ConsumerState;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.converters.AvroConverter;
import io.confluent.kafkarest.entities.AvroConsumerRecord;
import io.confluent.kafkarest.entities.ConsumerRecord;
import java.util.Map;
import java.util.Properties;

public class AvroConsumerState
extends ConsumerState<Object, Object, JsonNode, JsonNode> {
    private Decoder<Object> decoder = null;

    public AvroConsumerState(KafkaRestConfig config, ConsumerInstanceId instanceId, ConsumerConnector consumer) {
        super(config, instanceId, consumer);
        Properties props = new Properties();
        props.setProperty("schema.registry.url", config.getString("schema.registry.url"));
        props.putAll((Map<?, ?>)config.originalsWithPrefix("schema.registry", false));
        this.decoder = new KafkaAvroDecoder(new VerifiableProperties(props));
    }

    @Override
    protected Decoder<Object> getKeyDecoder() {
        return this.decoder;
    }

    @Override
    protected Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public ConsumerRecordAndSize<JsonNode, JsonNode> createConsumerRecord(MessageAndMetadata<Object, Object> msg) {
        AvroConverter.JsonNodeAndSize keyNode = AvroConverter.toJson((Object)msg.key());
        AvroConverter.JsonNodeAndSize valueNode = AvroConverter.toJson((Object)msg.message());
        return new ConsumerRecordAndSize((ConsumerRecord)new AvroConsumerRecord(msg.topic(), keyNode.json, valueNode.json, msg.partition(), msg.offset()), keyNode.size + valueNode.size);
    }
}

