/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafka.javaapi.consumer.ConsumerConnector;
import io.confluent.kafka.message.MessageAndMetadata;
import io.confluent.kafka.serializer.Decoder;
import io.confluent.kafka.serializer.DefaultDecoder;
import io.confluent.kafka.utils.VerifiableProperties;
import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.ConsumerState;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.BinaryConsumerRecord;
import io.confluent.kafkarest.entities.ConsumerRecord;

public class BinaryConsumerState
extends ConsumerState<byte[], byte[], byte[], byte[]> {
    private static final Decoder<byte[]> decoder = new DefaultDecoder(new VerifiableProperties());

    public BinaryConsumerState(KafkaRestConfig config, ConsumerInstanceId instanceId, ConsumerConnector consumer) {
        super(config, instanceId, consumer);
    }

    @Override
    protected Decoder<byte[]> getKeyDecoder() {
        return decoder;
    }

    @Override
    protected Decoder<byte[]> getValueDecoder() {
        return decoder;
    }

    @Override
    public ConsumerRecordAndSize<byte[], byte[]> createConsumerRecord(MessageAndMetadata<byte[], byte[]> msg) {
        long approxSize = (msg.key() != null ? msg.key().length : 0) + (msg.message() != null ? msg.message().length : 0);
        return new ConsumerRecordAndSize((ConsumerRecord)new BinaryConsumerRecord(msg.topic(), msg.key(), msg.message(), msg.partition(), msg.offset()), approxSize);
    }
}

