/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.clients;

import io.confluent.org.apache.kafka.clients.RequestCompletionHandler;
import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.requests.AbstractRequest;
import io.confluent.org.apache.kafka.common.requests.RequestHeader;

public final class ClientRequest {
    private final String destination;
    private final AbstractRequest.Builder<?> requestBuilder;
    private final int correlationId;
    private final String clientId;
    private final long createdTimeMs;
    private final boolean expectResponse;
    private final RequestCompletionHandler callback;

    public ClientRequest(String destination, AbstractRequest.Builder<?> requestBuilder, int correlationId, String clientId, long createdTimeMs, boolean expectResponse, RequestCompletionHandler callback) {
        this.destination = destination;
        this.requestBuilder = requestBuilder;
        this.correlationId = correlationId;
        this.clientId = clientId;
        this.createdTimeMs = createdTimeMs;
        this.expectResponse = expectResponse;
        this.callback = callback;
    }

    public String toString() {
        return "ClientRequest(expectResponse=" + this.expectResponse + ", callback=" + this.callback + ", destination=" + this.destination + ", correlationId=" + this.correlationId + ", clientId=" + this.clientId + ", createdTimeMs=" + this.createdTimeMs + ", requestBuilder=" + this.requestBuilder + ")";
    }

    public boolean expectResponse() {
        return this.expectResponse;
    }

    public ApiKeys apiKey() {
        return this.requestBuilder.apiKey();
    }

    public RequestHeader makeHeader(short version) {
        return new RequestHeader(this.apiKey(), version, this.clientId, this.correlationId);
    }

    public AbstractRequest.Builder<?> requestBuilder() {
        return this.requestBuilder;
    }

    public String destination() {
        return this.destination;
    }

    public RequestCompletionHandler callback() {
        return this.callback;
    }

    public long createdTimeMs() {
        return this.createdTimeMs;
    }

    public int correlationId() {
        return this.correlationId;
    }
}

