/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.clients.admin;

import io.confluent.org.apache.kafka.clients.admin.ConfigEntry;
import io.confluent.org.apache.kafka.common.annotation.InterfaceStability;
import java.util.Collection;
import java.util.Collections;

@InterfaceStability.Evolving
public class Config {
    private final Collection<ConfigEntry> entries;

    public Config(Collection<ConfigEntry> entries) {
        this.entries = Collections.unmodifiableCollection(entries);
    }

    public Collection<ConfigEntry> entries() {
        return this.entries;
    }

    public ConfigEntry get(String name) {
        for (ConfigEntry entry : this.entries) {
            if (!entry.name().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return this.entries.equals(config.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        return "Config(entries=" + this.entries + ")";
    }
}

