/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.metrics.stats;

import io.confluent.org.apache.kafka.common.MetricName;
import io.confluent.org.apache.kafka.common.metrics.CompoundStat;
import io.confluent.org.apache.kafka.common.metrics.MetricConfig;
import io.confluent.org.apache.kafka.common.metrics.stats.Rate;
import io.confluent.org.apache.kafka.common.metrics.stats.SampledStat;
import io.confluent.org.apache.kafka.common.metrics.stats.Total;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Meter
implements CompoundStat {
    private final MetricName rateMetricName;
    private final MetricName totalMetricName;
    private final Rate rate;
    private final Total total = new Total();

    public Meter(MetricName rateMetricName, MetricName totalMetricName) {
        this(TimeUnit.SECONDS, new Rate.SampledTotal(), rateMetricName, totalMetricName);
    }

    public Meter(TimeUnit unit, MetricName rateMetricName, MetricName totalMetricName) {
        this(unit, new Rate.SampledTotal(), rateMetricName, totalMetricName);
    }

    public Meter(SampledStat rateStat, MetricName rateMetricName, MetricName totalMetricName) {
        this(TimeUnit.SECONDS, rateStat, rateMetricName, totalMetricName);
    }

    public Meter(TimeUnit unit, SampledStat rateStat, MetricName rateMetricName, MetricName totalMetricName) {
        this.rate = new Rate(unit, rateStat);
        this.rateMetricName = rateMetricName;
        this.totalMetricName = totalMetricName;
    }

    @Override
    public List<CompoundStat.NamedMeasurable> stats() {
        return Arrays.asList(new CompoundStat.NamedMeasurable(this.totalMetricName, this.total), new CompoundStat.NamedMeasurable(this.rateMetricName, this.rate));
    }

    @Override
    public void record(MetricConfig config, double value, long timeMs) {
        this.rate.record(config, value, timeMs);
        this.total.record(config, value, timeMs);
    }
}

