/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.CommonFields;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.protocol.types.ArrayOf;
import io.confluent.org.apache.kafka.common.protocol.types.Field;
import io.confluent.org.apache.kafka.common.protocol.types.Schema;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import io.confluent.org.apache.kafka.common.requests.ApiError;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CreatePartitionsResponse
extends AbstractResponse {
    private static final String TOPIC_ERRORS_KEY_NAME = "topic_errors";
    private static final Schema CREATE_PARTITIONS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field("topic_errors", new ArrayOf(new Schema(CommonFields.TOPIC_NAME, CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE)), "Per topic results for the create partitions request"));
    private final int throttleTimeMs;
    private final Map<String, ApiError> errors;

    public static Schema[] schemaVersions() {
        return new Schema[]{CREATE_PARTITIONS_RESPONSE_V0};
    }

    public CreatePartitionsResponse(int throttleTimeMs, Map<String, ApiError> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public CreatePartitionsResponse(Struct struct) {
        Object[] topicErrorsArray = struct.getArray(TOPIC_ERRORS_KEY_NAME);
        HashMap<String, ApiError> errors = new HashMap<String, ApiError>(topicErrorsArray.length);
        for (Object topicErrorObj : topicErrorsArray) {
            Struct topicErrorStruct = (Struct)topicErrorObj;
            String topic = topicErrorStruct.get(CommonFields.TOPIC_NAME);
            ApiError error = new ApiError(topicErrorStruct);
            errors.put(topic, error);
        }
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        this.errors = errors;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.CREATE_PARTITIONS.responseSchema(version));
        ArrayList<Struct> topicErrors = new ArrayList<Struct>(this.errors.size());
        for (Map.Entry<String, ApiError> error : this.errors.entrySet()) {
            Struct errorStruct = struct.instance(TOPIC_ERRORS_KEY_NAME);
            errorStruct.set(CommonFields.TOPIC_NAME, error.getKey());
            error.getValue().write(errorStruct);
            topicErrors.add(errorStruct);
        }
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        struct.set(TOPIC_ERRORS_KEY_NAME, (Object)topicErrors.toArray(new Object[topicErrors.size()]));
        return struct;
    }

    public Map<String, ApiError> errors() {
        return this.errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.apiErrorCounts(this.errors);
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public static CreatePartitionsResponse parse(ByteBuffer buffer, short version) {
        return new CreatePartitionsResponse(ApiKeys.CREATE_PARTITIONS.parseResponse(version, buffer));
    }
}

