/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.CommonFields;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.protocol.types.ArrayOf;
import io.confluent.org.apache.kafka.common.protocol.types.Field;
import io.confluent.org.apache.kafka.common.protocol.types.Schema;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.requests.AbstractRequest;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import io.confluent.org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import io.confluent.org.apache.kafka.common.security.auth.KafkaPrincipal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DescribeDelegationTokenRequest
extends AbstractRequest {
    private static final String OWNER_KEY_NAME = "owners";
    private final List<KafkaPrincipal> owners;
    public static final Schema TOKEN_DESCRIBE_REQUEST_V0 = new Schema(new Field("owners", ArrayOf.nullable(new Schema(CommonFields.PRINCIPAL_TYPE, CommonFields.PRINCIPAL_NAME)), "An array of token owners."));

    private DescribeDelegationTokenRequest(short version, List<KafkaPrincipal> owners) {
        super(version);
        this.owners = owners;
    }

    public DescribeDelegationTokenRequest(Struct struct, short versionId) {
        super(versionId);
        Object[] ownerArray = struct.getArray(OWNER_KEY_NAME);
        if (ownerArray != null) {
            this.owners = new ArrayList<KafkaPrincipal>();
            for (Object ownerObj : ownerArray) {
                Struct ownerObjStruct = (Struct)ownerObj;
                String principalType = ownerObjStruct.get(CommonFields.PRINCIPAL_TYPE);
                String principalName = ownerObjStruct.get(CommonFields.PRINCIPAL_NAME);
                this.owners.add(new KafkaPrincipal(principalType, principalName));
            }
        } else {
            this.owners = null;
        }
    }

    public static Schema[] schemaVersions() {
        return new Schema[]{TOKEN_DESCRIBE_REQUEST_V0};
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.DESCRIBE_DELEGATION_TOKEN.requestSchema(version));
        if (this.owners == null) {
            struct.set(OWNER_KEY_NAME, null);
        } else {
            Object[] ownersArray = new Object[this.owners.size()];
            int i = 0;
            for (KafkaPrincipal principal : this.owners) {
                Struct ownerStruct = struct.instance(OWNER_KEY_NAME);
                ownerStruct.set(CommonFields.PRINCIPAL_TYPE, principal.getPrincipalType());
                ownerStruct.set(CommonFields.PRINCIPAL_NAME, principal.getName());
                ownersArray[i++] = ownerStruct;
            }
            struct.set(OWNER_KEY_NAME, (Object)ownersArray);
        }
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DescribeDelegationTokenResponse(throttleTimeMs, Errors.forException(e));
    }

    public List<KafkaPrincipal> owners() {
        return this.owners;
    }

    public boolean ownersListEmpty() {
        return this.owners != null && this.owners.isEmpty();
    }

    public static DescribeDelegationTokenRequest parse(ByteBuffer buffer, short version) {
        return new DescribeDelegationTokenRequest(ApiKeys.DESCRIBE_DELEGATION_TOKEN.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeDelegationTokenRequest> {
        private final List<KafkaPrincipal> owners;

        public Builder(List<KafkaPrincipal> owners) {
            super(ApiKeys.DESCRIBE_DELEGATION_TOKEN);
            this.owners = owners;
        }

        @Override
        public DescribeDelegationTokenRequest build(short version) {
            return new DescribeDelegationTokenRequest(version, this.owners);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: DescribeDelegationTokenRequest").append(", owners=").append(this.owners).append(")");
            return bld.toString();
        }
    }
}

