/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.protocol.Errors;

public class EpochEndOffset {
    public static final long UNDEFINED_EPOCH_OFFSET = -1L;
    public static final int UNDEFINED_EPOCH = -1;
    private Errors error;
    private long endOffset;

    public EpochEndOffset(Errors error, long endOffset) {
        this.error = error;
        this.endOffset = endOffset;
    }

    public EpochEndOffset(long endOffset) {
        this.error = Errors.NONE;
        this.endOffset = endOffset;
    }

    public Errors error() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != Errors.NONE;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public String toString() {
        return "EpochEndOffset{error=" + (Object)((Object)this.error) + ", endOffset=" + this.endOffset + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EpochEndOffset that = (EpochEndOffset)o;
        if (this.error != that.error) {
            return false;
        }
        return this.endOffset == that.endOffset;
    }

    public int hashCode() {
        int result = this.error.code();
        result = 31 * result + (int)(this.endOffset ^ this.endOffset >>> 32);
        return result;
    }
}

