/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.CommonFields;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.protocol.types.ArrayOf;
import io.confluent.org.apache.kafka.common.protocol.types.Field;
import io.confluent.org.apache.kafka.common.protocol.types.Schema;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LeaderAndIsrResponse
extends AbstractResponse {
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final Schema LEADER_AND_ISR_RESPONSE_PARTITION_V0 = new Schema(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID, CommonFields.ERROR_CODE);
    private static final Schema LEADER_AND_ISR_RESPONSE_V0;
    private static final Schema LEADER_AND_ISR_RESPONSE_V1;
    private final Errors error;
    private final Map<TopicPartition, Errors> responses;

    public static Schema[] schemaVersions() {
        return new Schema[]{LEADER_AND_ISR_RESPONSE_V0, LEADER_AND_ISR_RESPONSE_V1};
    }

    public LeaderAndIsrResponse(Errors error, Map<TopicPartition, Errors> responses) {
        this.responses = responses;
        this.error = error;
    }

    public LeaderAndIsrResponse(Struct struct) {
        this.responses = new HashMap<TopicPartition, Errors>();
        for (Object responseDataObj : struct.getArray(PARTITIONS_KEY_NAME)) {
            Struct responseData = (Struct)responseDataObj;
            String topic = responseData.get(CommonFields.TOPIC_NAME);
            int partition = responseData.get(CommonFields.PARTITION_ID);
            Errors error = Errors.forCode(responseData.get(CommonFields.ERROR_CODE));
            this.responses.put(new TopicPartition(topic, partition), error);
        }
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
    }

    public Map<TopicPartition, Errors> responses() {
        return this.responses;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        if (this.error != Errors.NONE) {
            return Collections.singletonMap(this.error, this.responses.size());
        }
        return this.errorCounts(this.responses);
    }

    public static LeaderAndIsrResponse parse(ByteBuffer buffer, short version) {
        return new LeaderAndIsrResponse(ApiKeys.LEADER_AND_ISR.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.LEADER_AND_ISR.responseSchema(version));
        ArrayList<Struct> responseDatas = new ArrayList<Struct>(this.responses.size());
        for (Map.Entry<TopicPartition, Errors> response : this.responses.entrySet()) {
            Struct partitionData = struct.instance(PARTITIONS_KEY_NAME);
            TopicPartition partition = response.getKey();
            partitionData.set(CommonFields.TOPIC_NAME, partition.topic());
            partitionData.set(CommonFields.PARTITION_ID, partition.partition());
            partitionData.set(CommonFields.ERROR_CODE, response.getValue().code());
            responseDatas.add(partitionData);
        }
        struct.set(PARTITIONS_KEY_NAME, (Object)responseDatas.toArray());
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        return struct;
    }

    static {
        LEADER_AND_ISR_RESPONSE_V1 = LEADER_AND_ISR_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, new Field(PARTITIONS_KEY_NAME, new ArrayOf(LEADER_AND_ISR_RESPONSE_PARTITION_V0)));
    }
}

