/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.TopicPartition;
import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.CommonFields;
import io.confluent.org.apache.kafka.common.protocol.Errors;
import io.confluent.org.apache.kafka.common.protocol.types.ArrayOf;
import io.confluent.org.apache.kafka.common.protocol.types.Field;
import io.confluent.org.apache.kafka.common.protocol.types.Schema;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.protocol.types.Type;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import io.confluent.org.apache.kafka.common.utils.CollectionUtils;
import io.confluent.org.apache.kafka.common.utils.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListOffsetResponse
extends AbstractResponse {
    public static final long UNKNOWN_TIMESTAMP = -1L;
    public static final long UNKNOWN_OFFSET = -1L;
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    @Deprecated
    private static final String OFFSETS_KEY_NAME = "offsets";
    private static final String TIMESTAMP_KEY_NAME = "timestamp";
    private static final String OFFSET_KEY_NAME = "offset";
    private static final Schema LIST_OFFSET_RESPONSE_PARTITION_V0 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field("offsets", new ArrayOf(Type.INT64), "A list of offsets."));
    private static final Schema LIST_OFFSET_RESPONSE_PARTITION_V1 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field("timestamp", Type.INT64, "The timestamp associated with the returned offset"), new Field("offset", Type.INT64, "offset found"));
    private static final Schema LIST_OFFSET_RESPONSE_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partition_responses", new ArrayOf(LIST_OFFSET_RESPONSE_PARTITION_V0)));
    private static final Schema LIST_OFFSET_RESPONSE_TOPIC_V1 = new Schema(CommonFields.TOPIC_NAME, new Field("partition_responses", new ArrayOf(LIST_OFFSET_RESPONSE_PARTITION_V1)));
    private static final Schema LIST_OFFSET_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(LIST_OFFSET_RESPONSE_TOPIC_V0)));
    private static final Schema LIST_OFFSET_RESPONSE_V1 = new Schema(new Field("responses", new ArrayOf(LIST_OFFSET_RESPONSE_TOPIC_V1)));
    private static final Schema LIST_OFFSET_RESPONSE_V2 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field("responses", new ArrayOf(LIST_OFFSET_RESPONSE_TOPIC_V1)));
    private final int throttleTimeMs;
    private final Map<TopicPartition, PartitionData> responseData;

    public static Schema[] schemaVersions() {
        return new Schema[]{LIST_OFFSET_RESPONSE_V0, LIST_OFFSET_RESPONSE_V1, LIST_OFFSET_RESPONSE_V2};
    }

    public ListOffsetResponse(Map<TopicPartition, PartitionData> responseData) {
        this(0, responseData);
    }

    public ListOffsetResponse(int throttleTimeMs, Map<TopicPartition, PartitionData> responseData) {
        this.throttleTimeMs = throttleTimeMs;
        this.responseData = responseData;
    }

    public ListOffsetResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.responseData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                PartitionData partitionData;
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.get(CommonFields.PARTITION_ID);
                Errors error = Errors.forCode(partitionResponse.get(CommonFields.ERROR_CODE));
                if (partitionResponse.hasField(OFFSETS_KEY_NAME)) {
                    Object[] offsets = partitionResponse.getArray(OFFSETS_KEY_NAME);
                    ArrayList<Long> offsetsList = new ArrayList<Long>();
                    for (Object offset : offsets) {
                        offsetsList.add((Long)offset);
                    }
                    partitionData = new PartitionData(error, offsetsList);
                } else {
                    long timestamp = partitionResponse.getLong(TIMESTAMP_KEY_NAME);
                    long offset = partitionResponse.getLong(OFFSET_KEY_NAME);
                    partitionData = new PartitionData(error, timestamp, offset);
                }
                this.responseData.put(new TopicPartition(topic, partition), partitionData);
            }
        }
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<TopicPartition, PartitionData> responseData() {
        return this.responseData;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (PartitionData response : this.responseData.values()) {
            this.updateErrorCounts(errorCounts, response.error);
        }
        return errorCounts;
    }

    public static ListOffsetResponse parse(ByteBuffer buffer, short version) {
        return new ListOffsetResponse(ApiKeys.LIST_OFFSETS.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.LIST_OFFSETS.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(this.responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = struct.instance(RESPONSES_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                PartitionData offsetPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionData.set(CommonFields.ERROR_CODE, offsetPartitionData.error.code());
                if (version == 0) {
                    partitionData.set(OFFSETS_KEY_NAME, (Object)offsetPartitionData.offsets.toArray());
                } else {
                    partitionData.set(TIMESTAMP_KEY_NAME, (Object)offsetPartitionData.timestamp);
                    partitionData.set(OFFSET_KEY_NAME, (Object)offsetPartitionData.offset);
                }
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        return struct;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("(type=ListOffsetResponse").append(", throttleTimeMs=").append(this.throttleTimeMs).append(", responseData=").append(this.responseData).append(")");
        return bld.toString();
    }

    public static final class PartitionData {
        public final Errors error;
        @Deprecated
        public final List<Long> offsets;
        public final Long timestamp;
        public final Long offset;

        @Deprecated
        public PartitionData(Errors error, List<Long> offsets) {
            this.error = error;
            this.offsets = offsets;
            this.timestamp = null;
            this.offset = null;
        }

        public PartitionData(Errors error, long timestamp, long offset) {
            this.error = error;
            this.timestamp = timestamp;
            this.offset = offset;
            this.offsets = null;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("PartitionData{").append("errorCode: ").append(this.error.code()).append(", timestamp: ").append(this.timestamp).append(", offset: ").append(this.offset).append(", offsets: ");
            if (this.offsets == null) {
                bld.append(this.offsets);
            } else {
                bld.append("[").append(Utils.join(this.offsets, ",")).append("]");
            }
            bld.append("}");
            return bld.toString();
        }
    }
}

