/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.requests;

import io.confluent.org.apache.kafka.common.errors.InvalidRequestException;
import io.confluent.org.apache.kafka.common.network.ListenerName;
import io.confluent.org.apache.kafka.common.network.Send;
import io.confluent.org.apache.kafka.common.protocol.ApiKeys;
import io.confluent.org.apache.kafka.common.protocol.types.Struct;
import io.confluent.org.apache.kafka.common.requests.AbstractRequest;
import io.confluent.org.apache.kafka.common.requests.AbstractResponse;
import io.confluent.org.apache.kafka.common.requests.ApiVersionsRequest;
import io.confluent.org.apache.kafka.common.requests.RequestAndSize;
import io.confluent.org.apache.kafka.common.requests.RequestHeader;
import io.confluent.org.apache.kafka.common.requests.ResponseHeader;
import io.confluent.org.apache.kafka.common.security.auth.KafkaPrincipal;
import io.confluent.org.apache.kafka.common.security.auth.SecurityProtocol;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public class RequestContext {
    public final RequestHeader header;
    public final String connectionId;
    public final InetAddress clientAddress;
    public final KafkaPrincipal principal;
    public final ListenerName listenerName;
    public final SecurityProtocol securityProtocol;

    public RequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol) {
        this.header = header;
        this.connectionId = connectionId;
        this.clientAddress = clientAddress;
        this.principal = principal;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
    }

    public RequestAndSize parseRequest(ByteBuffer buffer) {
        if (this.isUnsupportedApiVersionsRequest()) {
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(0, (Short)this.header.apiVersion());
            return new RequestAndSize(apiVersionsRequest, 0);
        }
        ApiKeys apiKey = this.header.apiKey();
        try {
            short apiVersion = this.header.apiVersion();
            Struct struct = apiKey.parseRequest(apiVersion, buffer);
            AbstractRequest body = AbstractRequest.parseRequest(apiKey, apiVersion, struct);
            return new RequestAndSize(body, struct.sizeOf());
        }
        catch (Throwable ex) {
            throw new InvalidRequestException("Error getting request for apiKey: " + (Object)((Object)apiKey) + ", apiVersion: " + this.header.apiVersion() + ", connectionId: " + this.connectionId + ", listenerName: " + this.listenerName + ", principal: " + this.principal, ex);
        }
    }

    public Send buildResponse(AbstractResponse body) {
        ResponseHeader responseHeader = this.header.toResponseHeader();
        return body.toSend(this.connectionId, responseHeader, this.apiVersion());
    }

    private boolean isUnsupportedApiVersionsRequest() {
        return this.header.apiKey() == ApiKeys.API_VERSIONS && !ApiKeys.API_VERSIONS.isVersionSupported(this.header.apiVersion());
    }

    public short apiVersion() {
        if (this.isUnsupportedApiVersionsRequest()) {
            return 0;
        }
        return this.header.apiVersion();
    }
}

