/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.serialization;

import io.confluent.org.apache.kafka.common.header.Headers;
import io.confluent.org.apache.kafka.common.serialization.Deserializer;
import java.util.Map;

public interface ExtendedDeserializer<T>
extends Deserializer<T> {
    public T deserialize(String var1, Headers var2, byte[] var3);

    public static class Wrapper<T>
    implements ExtendedDeserializer<T> {
        private final Deserializer<T> deserializer;

        public Wrapper(Deserializer<T> deserializer) {
            this.deserializer = deserializer;
        }

        @Override
        public T deserialize(String topic, Headers headers, byte[] data) {
            return this.deserialize(topic, data);
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
            this.deserializer.configure(configs, isKey);
        }

        @Override
        public T deserialize(String topic, byte[] data) {
            return this.deserializer.deserialize(topic, data);
        }

        @Override
        public void close() {
            this.deserializer.close();
        }

        public static <T> ExtendedDeserializer<T> ensureExtended(Deserializer<T> deserializer) {
            return deserializer == null ? null : (deserializer instanceof ExtendedDeserializer ? (ExtendedDeserializer)deserializer : new Wrapper<T>(deserializer));
        }
    }
}

