/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.utils;

import io.confluent.org.apache.kafka.common.TopicPartition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Map<String, Map<Integer, T>> groupDataByTopic(Map<TopicPartition, ? extends T> data) {
        HashMap<String, Map<Integer, T>> dataByTopic = new HashMap<String, Map<Integer, T>>();
        for (Map.Entry<TopicPartition, T> entry : data.entrySet()) {
            String topic = entry.getKey().topic();
            int partition = entry.getKey().partition();
            HashMap<Integer, T> topicData = (HashMap<Integer, T>)dataByTopic.get(topic);
            if (topicData == null) {
                topicData = new HashMap<Integer, T>();
                dataByTopic.put(topic, topicData);
            }
            topicData.put(partition, entry.getValue());
        }
        return dataByTopic;
    }

    public static Map<String, List<Integer>> groupDataByTopic(List<TopicPartition> partitions) {
        HashMap<String, List<Integer>> partitionsByTopic = new HashMap<String, List<Integer>>();
        for (TopicPartition tp : partitions) {
            String topic = tp.topic();
            ArrayList<Integer> topicData = (ArrayList<Integer>)partitionsByTopic.get(topic);
            if (topicData == null) {
                topicData = new ArrayList<Integer>();
                partitionsByTopic.put(topic, topicData);
            }
            topicData.add(tp.partition());
        }
        return partitionsByTopic;
    }
}

