/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.org.apache.kafka.common.utils;

public class Exit {
    private static final Procedure DEFAULT_HALT_PROCEDURE = new Procedure(){

        @Override
        public void execute(int statusCode, String message) {
            Runtime.getRuntime().halt(statusCode);
        }
    };
    private static final Procedure DEFAULT_EXIT_PROCEDURE;
    private static volatile Procedure exitProcedure;
    private static volatile Procedure haltProcedure;

    public static void exit(int statusCode) {
        Exit.exit(statusCode, null);
    }

    public static void exit(int statusCode, String message) {
        exitProcedure.execute(statusCode, message);
    }

    public static void halt(int statusCode) {
        Exit.halt(statusCode, null);
    }

    public static void halt(int statusCode, String message) {
        haltProcedure.execute(statusCode, message);
    }

    public static void setExitProcedure(Procedure procedure) {
        exitProcedure = procedure;
    }

    public static void setHaltProcedure(Procedure procedure) {
        haltProcedure = procedure;
    }

    public static void resetExitProcedure() {
        exitProcedure = DEFAULT_EXIT_PROCEDURE;
    }

    public static void resetHaltProcedure() {
        haltProcedure = DEFAULT_HALT_PROCEDURE;
    }

    static {
        exitProcedure = DEFAULT_EXIT_PROCEDURE = new Procedure(){

            @Override
            public void execute(int statusCode, String message) {
                System.exit(statusCode);
            }
        };
        haltProcedure = DEFAULT_HALT_PROCEDURE;
    }

    public static interface Procedure {
        public void execute(int var1, String var2);
    }
}

