/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.RestConfigUtils;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.PartitionReplica;
import io.confluent.kafkarest.entities.Topic;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;

public class AdminClientWrapper {
    private AdminClient adminClient;
    private int initTimeOut;

    public AdminClientWrapper(KafkaRestConfig kafkaRestConfig, AdminClient adminClient) {
        this.adminClient = adminClient;
        this.initTimeOut = kafkaRestConfig.getInt("client.init.timeout.ms");
    }

    public static Properties adminProperties(KafkaRestConfig kafkaRestConfig) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)kafkaRestConfig.getAdminProperties());
        properties.put("bootstrap.servers", RestConfigUtils.bootstrapBrokers(kafkaRestConfig));
        return properties;
    }

    public List<Integer> getBrokerIds() throws Exception {
        Vector<Integer> brokerIds = new Vector<Integer>();
        DescribeClusterResult clusterResults = this.adminClient.describeCluster();
        Collection nodeCollection = (Collection)clusterResults.nodes().get((long)this.initTimeOut, TimeUnit.MILLISECONDS);
        for (Node node : nodeCollection) {
            brokerIds.add(node.id());
        }
        return brokerIds;
    }

    public Collection<String> getTopicNames() throws Exception {
        TreeSet<String> allTopics = null;
        allTopics = new TreeSet<String>((Collection)this.adminClient.listTopics().names().get((long)this.initTimeOut, TimeUnit.MILLISECONDS));
        return allTopics;
    }

    public boolean topicExists(String topic) throws Exception {
        Collection<String> allTopics = this.getTopicNames();
        return allTopics.contains(topic);
    }

    public Topic getTopic(String topicName) throws Exception {
        Topic topic = null;
        if (this.topicExists(topicName)) {
            TopicDescription topicDescription = this.getTopicDescription(topicName);
            topic = this.buildTopic(topicName, topicDescription);
        }
        return topic;
    }

    public List<Partition> getTopicPartitions(String topicName) throws Exception {
        TopicDescription topicDescription = this.getTopicDescription(topicName);
        List<Partition> partitions = this.buildPartitonsData(topicDescription.partitions(), null);
        return partitions;
    }

    public Partition getTopicPartition(String topicName, int partition) throws Exception {
        TopicDescription topicDescription = this.getTopicDescription(topicName);
        List<Partition> partitions = this.buildPartitonsData(topicDescription.partitions(), partition);
        if (partitions.isEmpty()) {
            return null;
        }
        return partitions.get(0);
    }

    public boolean partitionExists(String topicName, int partition) throws Exception {
        Topic topic = this.getTopic(topicName);
        return partition >= 0 && partition < topic.getPartitions().size();
    }

    private Topic buildTopic(String topicName, TopicDescription topicDescription) throws Exception {
        List<Partition> partitions = this.buildPartitonsData(topicDescription.partitions(), null);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, topicName);
        Config config = (Config)((KafkaFuture)this.adminClient.describeConfigs(Collections.unmodifiableList(Arrays.asList(topicResource))).values().get(topicResource)).get();
        Properties topicProps = new Properties();
        for (ConfigEntry configEntry : config.entries()) {
            topicProps.put(configEntry.name(), configEntry.value());
        }
        Topic topic = new Topic(topicName, topicProps, partitions);
        return topic;
    }

    private List<Partition> buildPartitonsData(List<TopicPartitionInfo> partitions, Integer partitionsFilter) {
        Vector<Partition> partitionList = new Vector<Partition>();
        for (TopicPartitionInfo topicPartitionInfo : partitions) {
            if (partitionsFilter != null && !partitionsFilter.equals(topicPartitionInfo.partition())) continue;
            Partition p = new Partition();
            p.setPartition(topicPartitionInfo.partition());
            Node partitionLeader = topicPartitionInfo.leader();
            int leaderId = partitionLeader != null ? partitionLeader.id() : -1;
            p.setLeader(leaderId);
            Vector<PartitionReplica> partitionReplicas = new Vector<PartitionReplica>();
            for (Node replicaNode : topicPartitionInfo.replicas()) {
                partitionReplicas.add(new PartitionReplica(replicaNode.id(), replicaNode.id() == p.getLeader(), topicPartitionInfo.isr().contains(replicaNode)));
            }
            p.setReplicas(partitionReplicas);
            partitionList.add(p);
        }
        return partitionList;
    }

    private TopicDescription getTopicDescription(String topicName) throws Exception {
        return (TopicDescription)((KafkaFuture)this.adminClient.describeTopics(Collections.unmodifiableList(Arrays.asList(topicName))).values().get(topicName)).get((long)this.initTimeOut, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.adminClient.close();
    }
}

