/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import io.confluent.kafkarest.KafkaRestConfig;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.kafka.common.config.ConfigException;

public class UriUtils {
    public static UriBuilder absoluteUriBuilder(KafkaRestConfig config, UriInfo uriInfo) {
        String hostname = config.getString("host.name");
        UriBuilder builder = uriInfo.getAbsolutePathBuilder();
        if (hostname.length() > 0) {
            builder.host(hostname);
            URI origAbsoluteUri = uriInfo.getAbsolutePath();
            builder.scheme(origAbsoluteUri.getScheme());
            if (origAbsoluteUri.getPort() != -1) {
                try {
                    builder.port(config.consumerPort(origAbsoluteUri.getScheme()));
                }
                catch (URISyntaxException e) {
                    throw new ConfigException(e.getMessage());
                }
            }
        }
        return builder;
    }
}

