/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.EntityUtils;
import io.confluent.kafkarest.entities.ProduceRecordBase;
import io.confluent.rest.validation.ConstraintViolations;
import java.io.IOException;
import java.util.Arrays;

public class BinaryProduceRecord
extends ProduceRecordBase<byte[], byte[]> {
    @JsonCreator
    public BinaryProduceRecord(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value) throws IOException {
        super(null, null);
        try {
            this.key = key != null ? EntityUtils.parseBase64Binary((String)key) : null;
        }
        catch (IllegalArgumentException e) {
            throw ConstraintViolations.simpleException((String)"Record key contains invalid base64 encoding");
        }
        try {
            this.value = value != null ? EntityUtils.parseBase64Binary((String)value) : null;
        }
        catch (IllegalArgumentException e) {
            throw ConstraintViolations.simpleException((String)"Record value contains invalid base64 encoding");
        }
    }

    public BinaryProduceRecord(byte[] key, byte[] value) {
        super(key, value);
    }

    public BinaryProduceRecord(byte[] unencodedValue) {
        this(null, unencodedValue);
    }

    @Override
    @JsonProperty(value="key")
    public String getJsonKey() {
        return this.key == null ? null : EntityUtils.encodeBase64Binary((byte[])((byte[])this.key));
    }

    @Override
    @JsonProperty(value="value")
    public String getJsonValue() {
        return this.value == null ? null : EntityUtils.encodeBase64Binary((byte[])((byte[])this.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryProduceRecord that = (BinaryProduceRecord)o;
        if (!Arrays.equals((byte[])this.key, (byte[])that.key)) {
            return false;
        }
        return Arrays.equals((byte[])this.value, (byte[])that.value);
    }

    public int hashCode() {
        int result = this.key != null ? Arrays.hashCode((byte[])this.key) : 0;
        result = 31 * result + (this.value != null ? Arrays.hashCode((byte[])this.value) : 0);
        return result;
    }
}

