/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.extension;

import io.confluent.kafkarest.AdminClientWrapper;
import io.confluent.kafkarest.DefaultKafkaRestContext;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.ProducerPool;
import io.confluent.kafkarest.ScalaConsumersContext;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.core.Configurable;

public class KafkaRestContextProvider {
    private static KafkaRestContext defaultContext = null;
    private static KafkaRestConfig defaultAppConfig = null;
    private static final InheritableThreadLocal<KafkaRestContext> restContextInheritableThreadLocal = new InheritableThreadLocal();
    private static AtomicBoolean initialized = new AtomicBoolean();

    public static void initialize(Configurable<?> config, KafkaRestConfig appConfig, ProducerPool producerPool, KafkaConsumerManager kafkaConsumerManager, AdminClientWrapper adminClientWrapper, ScalaConsumersContext scalaConsumersContext) {
        if (initialized.compareAndSet(false, true)) {
            if (scalaConsumersContext == null) {
                scalaConsumersContext = new ScalaConsumersContext(appConfig);
                ScalaConsumersContext.registerExceptionMappers(config, (KafkaRestConfig)appConfig);
            }
            defaultContext = new DefaultKafkaRestContext(appConfig, producerPool, kafkaConsumerManager, adminClientWrapper, scalaConsumersContext);
            defaultAppConfig = appConfig;
        }
    }

    public static KafkaRestConfig getDefaultAppConfig() {
        return defaultAppConfig;
    }

    public static KafkaRestContext getDefaultContext() {
        return defaultContext;
    }

    public static KafkaRestContext getCurrentContext() {
        if (restContextInheritableThreadLocal.get() != null) {
            return (KafkaRestContext)restContextInheritableThreadLocal.get();
        }
        return defaultContext;
    }

    public static void setCurrentContext(KafkaRestContext kafkaRestContext) {
        restContextInheritableThreadLocal.set(kafkaRestContext);
    }

    public static void clearCurrentContext() {
        restContextInheritableThreadLocal.remove();
    }

    public static synchronized void clean() {
        defaultContext.shutdown();
        defaultContext = null;
        initialized.set(false);
    }
}

