/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.v2;

import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.ConsumerAssignmentRequest;
import io.confluent.kafkarest.entities.ConsumerCommittedRequest;
import io.confluent.kafkarest.entities.ConsumerCommittedResponse;
import io.confluent.kafkarest.entities.ConsumerOffsetCommitRequest;
import io.confluent.kafkarest.entities.ConsumerSeekToOffsetRequest;
import io.confluent.kafkarest.entities.ConsumerSeekToRequest;
import io.confluent.kafkarest.entities.ConsumerSubscriptionRecord;
import io.confluent.kafkarest.entities.TopicPartition;
import io.confluent.kafkarest.entities.TopicPartitionOffset;
import io.confluent.kafkarest.entities.TopicPartitionOffsetMetadata;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.ws.rs.InternalServerErrorException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;

public abstract class KafkaConsumerState<KafkaKeyT, KafkaValueT, ClientKeyT, ClientValueT> {
    private KafkaRestConfig config;
    private ConsumerInstanceId instanceId;
    private Consumer<KafkaKeyT, KafkaValueT> consumer;
    private Queue<ConsumerRecord<KafkaKeyT, KafkaValueT>> consumerRecords = new ArrayDeque<ConsumerRecord<KafkaKeyT, KafkaValueT>>();
    volatile long expiration;
    private ReentrantLock lock;

    KafkaConsumerState(KafkaRestConfig config, ConsumerInstanceId instanceId, Consumer<KafkaKeyT, KafkaValueT> consumer) {
        this.config = config;
        this.instanceId = instanceId;
        this.consumer = consumer;
        this.expiration = config.getTime().milliseconds() + (long)config.getInt("consumer.instance.timeout.ms").intValue();
        this.lock = new ReentrantLock();
    }

    public ConsumerInstanceId getId() {
        return this.instanceId;
    }

    public abstract ConsumerRecordAndSize<ClientKeyT, ClientValueT> createConsumerRecord(ConsumerRecord<KafkaKeyT, KafkaValueT> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopicPartitionOffset> commitOffsets(String async, ConsumerOffsetCommitRequest offsetCommitRequest) {
        this.lock.lock();
        try {
            if (offsetCommitRequest == null) {
                if (async == null) {
                    this.consumer.commitSync();
                } else {
                    this.consumer.commitAsync();
                }
            } else {
                HashMap<org.apache.kafka.common.TopicPartition, OffsetAndMetadata> offsetMap = new HashMap<org.apache.kafka.common.TopicPartition, OffsetAndMetadata>();
                for (TopicPartitionOffsetMetadata t : offsetCommitRequest.offsets) {
                    if (t.getMetadata() == null) {
                        offsetMap.put(new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition()), new OffsetAndMetadata(t.getOffset() + 1L));
                        continue;
                    }
                    offsetMap.put(new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition()), new OffsetAndMetadata(t.getOffset() + 1L, t.getMetadata()));
                }
                this.consumer.commitSync(offsetMap);
            }
            Vector result = new Vector();
            Vector vector = result;
            return vector;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekToBeginning(ConsumerSeekToRequest seekToRequest) {
        this.lock.lock();
        try {
            if (seekToRequest != null) {
                Vector<org.apache.kafka.common.TopicPartition> topicPartitions = new Vector<org.apache.kafka.common.TopicPartition>();
                for (TopicPartition t : seekToRequest.partitions) {
                    topicPartitions.add(new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition()));
                }
                this.consumer.seekToBeginning(topicPartitions);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekToEnd(ConsumerSeekToRequest seekToRequest) {
        this.lock.lock();
        try {
            if (seekToRequest != null) {
                Vector<org.apache.kafka.common.TopicPartition> topicPartitions = new Vector<org.apache.kafka.common.TopicPartition>();
                for (TopicPartition t : seekToRequest.partitions) {
                    topicPartitions.add(new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition()));
                }
                this.consumer.seekToEnd(topicPartitions);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekToOffset(ConsumerSeekToOffsetRequest seekToOffsetRequest) {
        this.lock.lock();
        try {
            if (seekToOffsetRequest != null) {
                for (TopicPartitionOffsetMetadata t : seekToOffsetRequest.offsets) {
                    org.apache.kafka.common.TopicPartition topicPartition = new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition());
                    this.consumer.seek(topicPartition, t.getOffset());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(ConsumerAssignmentRequest assignmentRequest) {
        this.lock.lock();
        try {
            if (assignmentRequest != null) {
                Vector<org.apache.kafka.common.TopicPartition> topicPartitions = new Vector<org.apache.kafka.common.TopicPartition>();
                for (TopicPartition t : assignmentRequest.partitions) {
                    topicPartitions.add(new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition()));
                }
                this.consumer.assign(topicPartitions);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.lock.lock();
        try {
            if (this.consumer != null) {
                this.consumer.close();
            }
            this.consumer = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(ConsumerSubscriptionRecord subscription) {
        if (subscription == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.consumer != null) {
                if (subscription.topics != null) {
                    this.consumer.subscribe(subscription.topics);
                } else if (subscription.getTopicPattern() != null) {
                    Pattern topicPattern = Pattern.compile(subscription.getTopicPattern());
                    NoOpOnRebalance noOpOnRebalance = new NoOpOnRebalance();
                    this.consumer.subscribe(topicPattern, (ConsumerRebalanceListener)noOpOnRebalance);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unsubscribe() {
        this.lock.lock();
        try {
            if (this.consumer != null) {
                this.consumer.unsubscribe();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<String> subscription() {
        Set currSubscription = null;
        this.lock.lock();
        try {
            if (this.consumer != null) {
                currSubscription = this.consumer.subscription();
            }
        }
        finally {
            this.lock.unlock();
        }
        return currSubscription;
    }

    public Set<org.apache.kafka.common.TopicPartition> assignment() {
        Set currAssignment = null;
        this.lock.lock();
        try {
            if (this.consumer != null) {
                currAssignment = this.consumer.assignment();
            }
        }
        finally {
            this.lock.unlock();
        }
        return currAssignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerCommittedResponse committed(ConsumerCommittedRequest request) {
        ConsumerCommittedResponse response = new ConsumerCommittedResponse();
        response.offsets = new Vector<TopicPartitionOffsetMetadata>();
        this.lock.lock();
        try {
            if (this.consumer != null) {
                for (TopicPartition t : request.partitions) {
                    org.apache.kafka.common.TopicPartition partition = new org.apache.kafka.common.TopicPartition(t.getTopic(), t.getPartition());
                    OffsetAndMetadata offsetMetadata = this.consumer.committed(partition);
                    if (offsetMetadata == null) continue;
                    response.offsets.add(new TopicPartitionOffsetMetadata(partition.topic(), partition.partition(), offsetMetadata.offset(), offsetMetadata.metadata()));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getBeginningOffset(String topic, int partition) {
        this.lock.lock();
        try {
            if (this.consumer == null) {
                throw new IllegalStateException("KafkaConsumerState has been closed.");
            }
            Map response = this.consumer.beginningOffsets(Collections.singletonList(new org.apache.kafka.common.TopicPartition(topic, partition)));
            if (response.size() != 1) {
                throw new InternalServerErrorException(String.format("Expected one offset, but got %d instead.", response.size()));
            }
            long l = (Long)response.values().stream().findAny().get();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEndOffset(String topic, int partition) {
        this.lock.lock();
        try {
            if (this.consumer == null) {
                throw new IllegalStateException("KafkaConsumerState has been closed.");
            }
            Map response = this.consumer.endOffsets(Collections.singletonList(new org.apache.kafka.common.TopicPartition(topic, partition)));
            if (response.size() != 1) {
                throw new InternalServerErrorException(String.format("Expected one offset, but got %d instead.", response.size()));
            }
            long l = (Long)response.values().stream().findAny().get();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<Long> getOffsetForTime(String topic, int partition, Instant timestamp) {
        this.lock.lock();
        try {
            if (this.consumer == null) {
                throw new IllegalStateException("KafkaConsumerState has been closed.");
            }
            Map response = this.consumer.offsetsForTimes(Collections.singletonMap(new org.apache.kafka.common.TopicPartition(topic, partition), timestamp.toEpochMilli()));
            if (response.size() != 1) {
                throw new InternalServerErrorException(String.format("Expected one offset, but got %d instead.", response.size()));
            }
            Optional<Long> optional = response.values().stream().filter(Objects::nonNull).findAny().map(OffsetAndTimestamp::offset);
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean expired(long nowMs) {
        return this.expiration <= nowMs;
    }

    public void updateExpiration() {
        this.expiration = this.config.getTime().milliseconds() + (long)this.config.getInt("consumer.instance.timeout.ms").intValue();
    }

    public KafkaRestConfig getConfig() {
        return this.config;
    }

    public void setConfig(KafkaRestConfig config) {
        this.config = config;
    }

    ConsumerRecord<KafkaKeyT, KafkaValueT> peek() {
        return this.consumerRecords.peek();
    }

    boolean hasNext() {
        this.lock.lock();
        try {
            if (this.hasNextCached()) {
                boolean bl = true;
                return bl;
            }
            this.getOrCreateConsumerRecords();
            boolean bl = this.hasNextCached();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean hasNextCached() {
        return !this.consumerRecords.isEmpty();
    }

    ConsumerRecord<KafkaKeyT, KafkaValueT> next() {
        return this.consumerRecords.poll();
    }

    private void getOrCreateConsumerRecords() {
        this.consumerRecords = new ArrayDeque<ConsumerRecord<KafkaKeyT, KafkaValueT>>();
        ConsumerRecords polledRecords = this.consumer.poll(0L);
        for (ConsumerRecord consumerRecord : polledRecords) {
            this.consumerRecords.add(consumerRecord);
        }
    }

    private class NoOpOnRebalance
    implements ConsumerRebalanceListener {
        public void onPartitionsRevoked(Collection<org.apache.kafka.common.TopicPartition> partitions) {
        }

        public void onPartitionsAssigned(Collection<org.apache.kafka.common.TopicPartition> partitions) {
        }
    }
}

