/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;

public class CachedSchemaRegistryClient
implements SchemaRegistryClient {
    private final RestService restService;
    private final int identityMapCapacity;
    private final Map<String, Map<org.apache.avro.Schema, Integer>> schemaCache;
    private final Map<String, Map<Integer, org.apache.avro.Schema>> idCache;
    private final Map<String, Map<org.apache.avro.Schema, Integer>> versionCache;

    public CachedSchemaRegistryClient(String baseUrl, int identityMapCapacity) {
        this(new RestService(baseUrl), identityMapCapacity);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int identityMapCapacity) {
        this(new RestService(baseUrls), identityMapCapacity);
    }

    public CachedSchemaRegistryClient(RestService restService, int identityMapCapacity) {
        this.identityMapCapacity = identityMapCapacity;
        this.schemaCache = new HashMap<String, Map<org.apache.avro.Schema, Integer>>();
        this.idCache = new HashMap<String, Map<Integer, org.apache.avro.Schema>>();
        this.versionCache = new HashMap<String, Map<org.apache.avro.Schema, Integer>>();
        this.restService = restService;
        this.idCache.put(null, new HashMap());
    }

    private int registerAndGetId(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        return this.restService.registerSchema(schema.toString(), subject);
    }

    private org.apache.avro.Schema getSchemaByIdFromRegistry(int id) throws IOException, RestClientException {
        SchemaString restSchema = this.restService.getId(id);
        return new Schema.Parser().parse(restSchema.getSchemaString());
    }

    private int getVersionFromRegistry(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        Schema response = this.restService.lookUpSubjectVersion(schema.toString(), subject, true);
        return response.getVersion();
    }

    @Override
    public synchronized int register(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        Map<Object, Object> schemaIdMap;
        if (this.schemaCache.containsKey(subject)) {
            schemaIdMap = this.schemaCache.get(subject);
        } else {
            schemaIdMap = new IdentityHashMap();
            this.schemaCache.put(subject, schemaIdMap);
        }
        if (schemaIdMap.containsKey(schema)) {
            return (Integer)schemaIdMap.get(schema);
        }
        if (schemaIdMap.size() >= this.identityMapCapacity) {
            throw new IllegalStateException("Too many schema objects created for " + subject + "!");
        }
        int id = this.registerAndGetId(subject, schema);
        schemaIdMap.put(schema, id);
        this.idCache.get(null).put(id, schema);
        return id;
    }

    @Override
    public org.apache.avro.Schema getByID(int id) throws IOException, RestClientException {
        return this.getById(id);
    }

    @Override
    public synchronized org.apache.avro.Schema getById(int id) throws IOException, RestClientException {
        return this.getBySubjectAndId(null, id);
    }

    @Override
    public org.apache.avro.Schema getBySubjectAndID(String subject, int id) throws IOException, RestClientException {
        return this.getBySubjectAndId(subject, id);
    }

    @Override
    public synchronized org.apache.avro.Schema getBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        Map<Object, Object> idSchemaMap;
        if (this.idCache.containsKey(subject)) {
            idSchemaMap = this.idCache.get(subject);
        } else {
            idSchemaMap = new HashMap();
            this.idCache.put(subject, idSchemaMap);
        }
        if (idSchemaMap.containsKey(id)) {
            return (org.apache.avro.Schema)idSchemaMap.get(id);
        }
        org.apache.avro.Schema schema = this.getSchemaByIdFromRegistry(id);
        idSchemaMap.put(id, schema);
        return schema;
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        Schema response = this.restService.getVersion(subject, version);
        int id = response.getId();
        String schema = response.getSchema();
        return new SchemaMetadata(id, version, schema);
    }

    @Override
    public synchronized SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        Schema response = this.restService.getLatestVersion(subject);
        int id = response.getId();
        int version = response.getVersion();
        String schema = response.getSchema();
        return new SchemaMetadata(id, version, schema);
    }

    @Override
    public synchronized int getVersion(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        Map<Object, Object> schemaVersionMap;
        if (this.versionCache.containsKey(subject)) {
            schemaVersionMap = this.versionCache.get(subject);
        } else {
            schemaVersionMap = new IdentityHashMap();
            this.versionCache.put(subject, schemaVersionMap);
        }
        if (schemaVersionMap.containsKey(schema)) {
            return (Integer)schemaVersionMap.get(schema);
        }
        if (schemaVersionMap.size() >= this.identityMapCapacity) {
            throw new IllegalStateException("Too many schema objects created for " + subject + "!");
        }
        int version = this.getVersionFromRegistry(subject, schema);
        schemaVersionMap.put(schema, version);
        return version;
    }

    @Override
    public boolean testCompatibility(String subject, org.apache.avro.Schema schema) throws IOException, RestClientException {
        return this.restService.testCompatibility(schema.toString(), subject, "latest");
    }

    @Override
    public String updateCompatibility(String subject, String compatibility) throws IOException, RestClientException {
        ConfigUpdateRequest response = this.restService.updateCompatibility(compatibility, subject);
        return response.getCompatibilityLevel();
    }

    @Override
    public String getCompatibility(String subject) throws IOException, RestClientException {
        Config response = this.restService.getConfig(subject);
        return response.getCompatibilityLevel();
    }

    @Override
    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        return this.restService.getAllSubjects();
    }
}

