/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.ServerClusterId;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.CompatibilityCheckResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeGetResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.UrlList;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProviderFactory;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProviderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestService
implements Configurable {
    private static final Logger log = LoggerFactory.getLogger(RestService.class);
    private static final TypeReference<RegisterSchemaResponse> REGISTER_RESPONSE_TYPE = new TypeReference<RegisterSchemaResponse>(){};
    private static final TypeReference<Config> GET_CONFIG_RESPONSE_TYPE = new TypeReference<Config>(){};
    private static final TypeReference<List<ModeGetResponse>> GET_MODES_RESPONSE_TYPE = new TypeReference<List<ModeGetResponse>>(){};
    private static final TypeReference<ModeGetResponse> GET_MODE_RESPONSE_TYPE = new TypeReference<ModeGetResponse>(){};
    private static final TypeReference<SchemaString> GET_SCHEMA_BY_ID_RESPONSE_TYPE = new TypeReference<SchemaString>(){};
    private static final TypeReference<JsonNode> GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE = new TypeReference<JsonNode>(){};
    private static final TypeReference<Schema> GET_SCHEMA_BY_VERSION_RESPONSE_TYPE = new TypeReference<Schema>(){};
    private static final TypeReference<List<Integer>> ALL_VERSIONS_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
    private static final TypeReference<List<String>> ALL_TOPICS_RESPONSE_TYPE = new TypeReference<List<String>>(){};
    private static final TypeReference<CompatibilityCheckResponse> COMPATIBILITY_CHECK_RESPONSE_TYPE_REFERENCE = new TypeReference<CompatibilityCheckResponse>(){};
    private static final TypeReference<Schema> SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE = new TypeReference<Schema>(){};
    private static final TypeReference<ConfigUpdateRequest> UPDATE_CONFIG_RESPONSE_TYPE_REFERENCE = new TypeReference<ConfigUpdateRequest>(){};
    private static final TypeReference<ModeUpdateRequest> UPDATE_MODE_RESPONSE_TYPE_REFERENCE = new TypeReference<ModeUpdateRequest>(){};
    private static final TypeReference<Integer> DELETE_SUBJECT_VERSION_RESPONSE_TYPE = new TypeReference<Integer>(){};
    private static final TypeReference<? extends List<Integer>> DELETE_SUBJECT_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
    private static final TypeReference<String> DELETE_MODE_RESPONSE_TYPE = new TypeReference<String>(){};
    private static final TypeReference<ServerClusterId> GET_CLUSTER_ID_RESPONSE_TYPE = new TypeReference<ServerClusterId>(){};
    private static final int HTTP_CONNECT_TIMEOUT_MS = 60000;
    private static final int HTTP_READ_TIMEOUT_MS = 60000;
    private static final int JSON_PARSE_ERROR_CODE = 50005;
    private static ObjectMapper jsonDeserializer = new ObjectMapper();
    private static final String AUTHORIZATION_HEADER = "Authorization";
    public static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = Collections.singletonMap("Content-Type", "application/vnd.schemaregistry.v1+json");
    private UrlList baseUrls;
    private SSLSocketFactory sslSocketFactory;
    private BasicAuthCredentialProvider basicAuthCredentialProvider;
    private BearerAuthCredentialProvider bearerAuthCredentialProvider;
    private Map<String, String> httpHeaders;
    private Proxy proxy;

    public RestService(UrlList baseUrls) {
        this.baseUrls = baseUrls;
    }

    public RestService(List<String> baseUrls) {
        this(new UrlList(baseUrls));
    }

    public RestService(String baseUrlConfig) {
        this(RestService.parseBaseUrl(baseUrlConfig));
    }

    public void configure(Map<String, ?> configs) {
        String basicCredentialsSource = (String)configs.get("basic.auth.credentials.source");
        String bearerCredentialsSource = (String)configs.get("bearer.auth.credentials.source");
        if (RestService.isNonEmpty(basicCredentialsSource) && RestService.isNonEmpty(bearerCredentialsSource)) {
            throw new ConfigException(String.format("Only one of '%s' and '%s' may be specified", "basic.auth.credentials.source", "bearer.auth.credentials.source"));
        }
        if (RestService.isNonEmpty(basicCredentialsSource)) {
            BasicAuthCredentialProvider basicAuthCredentialProvider = BasicAuthCredentialProviderFactory.getBasicAuthCredentialProvider(basicCredentialsSource, configs);
            this.setBasicAuthCredentialProvider(basicAuthCredentialProvider);
        } else if (RestService.isNonEmpty(bearerCredentialsSource)) {
            BearerAuthCredentialProvider bearerAuthCredentialProvider = BearerAuthCredentialProviderFactory.getBearerAuthCredentialProvider(bearerCredentialsSource, configs);
            this.setBearerAuthCredentialProvider(bearerAuthCredentialProvider);
        }
        String proxyHost = (String)configs.get("proxy.host");
        Integer proxyPort = (Integer)configs.get("proxy.port");
        if (RestService.isValidProxyConfig(proxyHost, proxyPort)) {
            this.setProxy(proxyHost, proxyPort);
        }
    }

    private static boolean isNonEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    private static boolean isValidProxyConfig(String proxyHost, Integer proxyPort) {
        return RestService.isNonEmpty(proxyHost) && proxyPort != null && proxyPort > 0;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    private <T> T sendHttpRequest(String requestUrl, String method, byte[] requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        String requestData = requestBodyData == null ? "null" : new String(requestBodyData, StandardCharsets.UTF_8);
        log.debug(String.format("Sending %s with input %s to %s", method, requestData, requestUrl));
        HttpURLConnection connection = null;
        try {
            ErrorMessage errorMessage;
            InputStream is;
            int responseCode;
            URL url = new URL(requestUrl);
            connection = this.buildConnection(url, method, requestProperties);
            if (requestBodyData != null) {
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(requestBodyData);
                    os.flush();
                }
                catch (IOException e) {
                    log.error("Failed to send HTTP request to endpoint: " + url, (Throwable)e);
                    throw e;
                }
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                is = connection.getInputStream();
                Object result = jsonDeserializer.readValue(is, responseFormat);
                is.close();
                Object object = result;
                return (T)object;
            }
            if (responseCode == 204) {
                is = null;
                return (T)is;
            }
            try (InputStream es = connection.getErrorStream();){
                errorMessage = (ErrorMessage)jsonDeserializer.readValue(es, ErrorMessage.class);
            }
            catch (JsonProcessingException e) {
                errorMessage = new ErrorMessage(50005, e.getMessage());
            }
            throw new RestClientException(errorMessage.getMessage(), responseCode, errorMessage.getErrorCode());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private HttpURLConnection buildConnection(URL url, String method, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection connection = null;
        connection = this.proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(this.proxy);
        connection.setConnectTimeout(60000);
        connection.setReadTimeout(60000);
        this.setupSsl(connection);
        connection.setRequestMethod(method);
        this.setAuthRequestHeaders(connection);
        this.setCustomHeaders(connection);
        connection.setDoInput(true);
        for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        connection.setUseCaches(false);
        return connection;
    }

    private void setupSsl(HttpURLConnection connection) {
        if (connection instanceof HttpsURLConnection && this.sslSocketFactory != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
        }
    }

    private <T> T httpRequest(String path, String method, byte[] requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        int n = this.baseUrls.size();
        for (int i = 0; i < n; ++i) {
            String baseUrl = this.baseUrls.current();
            String requestUrl = RestService.buildRequestUrl(baseUrl, path);
            try {
                return this.sendHttpRequest(requestUrl, method, requestBodyData, requestProperties, responseFormat);
            }
            catch (IOException e) {
                this.baseUrls.fail(baseUrl);
                if (i != n - 1) continue;
                throw e;
            }
        }
        throw new IOException("Internal HTTP retry error");
    }

    static String buildRequestUrl(String baseUrl, String path) {
        return baseUrl.replaceFirst("/$", "") + "/" + path.replaceFirst("^/", "");
    }

    public Schema lookUpSubjectVersion(String schemaString, String subject) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.lookUpSubjectVersion(request, subject);
    }

    public Schema lookUpSubjectVersion(RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        return this.lookUpSubjectVersion(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject, false);
    }

    public Schema lookUpSubjectVersion(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s", subject);
        if (requestProperties.isEmpty()) {
            requestProperties = DEFAULT_REQUEST_PROPERTIES;
        }
        Schema schema = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE);
        return schema;
    }

    public Schema lookUpSubjectVersion(String schemaString, String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.lookUpSubjectVersion(DEFAULT_REQUEST_PROPERTIES, request, subject, lookupDeletedSchema);
    }

    public Schema lookUpSubjectVersion(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        String path = String.format("/subjects/%s?deleted=%s", subject, lookupDeletedSchema);
        Schema schema = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE);
        return schema;
    }

    public int registerSchema(String schemaString, String subject) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.registerSchema(request, subject);
    }

    public int registerSchema(String schemaString, String subject, int version, int id) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        request.setVersion(version);
        request.setId(id);
        return this.registerSchema(request, subject);
    }

    public int registerSchema(RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        return this.registerSchema(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject);
    }

    public int registerSchema(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions", subject);
        RegisterSchemaResponse response = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, REGISTER_RESPONSE_TYPE);
        return response.getId();
    }

    public boolean testCompatibility(String schemaString, String subject, String version) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.testCompatibility(request, subject, version);
    }

    public boolean testCompatibility(RegisterSchemaRequest registerSchemaRequest, String subject, String version) throws IOException, RestClientException {
        return this.testCompatibility(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject, version);
    }

    public boolean testCompatibility(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject, String version) throws IOException, RestClientException {
        String path = String.format("/compatibility/subjects/%s/versions/%s", subject, version);
        CompatibilityCheckResponse response = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, COMPATIBILITY_CHECK_RESPONSE_TYPE_REFERENCE);
        return response.getIsCompatible();
    }

    public ConfigUpdateRequest updateCompatibility(String compatibility, String subject) throws IOException, RestClientException {
        ConfigUpdateRequest request = new ConfigUpdateRequest();
        request.setCompatibilityLevel(compatibility);
        return this.updateConfig(request, subject);
    }

    public ConfigUpdateRequest updateConfig(ConfigUpdateRequest configUpdateRequest, String subject) throws IOException, RestClientException {
        return this.updateConfig(DEFAULT_REQUEST_PROPERTIES, configUpdateRequest, subject);
    }

    public ConfigUpdateRequest updateConfig(Map<String, String> requestProperties, ConfigUpdateRequest configUpdateRequest, String subject) throws IOException, RestClientException {
        String path = subject != null ? String.format("/config/%s", subject) : "/config";
        ConfigUpdateRequest response = this.httpRequest(path, "PUT", configUpdateRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, UPDATE_CONFIG_RESPONSE_TYPE_REFERENCE);
        return response;
    }

    public Config getConfig(String subject) throws IOException, RestClientException {
        return this.getConfig(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public Config getConfig(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = subject != null ? String.format("/config/%s", subject) : "/config";
        Config config = this.httpRequest(path, "GET", null, requestProperties, GET_CONFIG_RESPONSE_TYPE);
        return config;
    }

    public ModeUpdateRequest setMode(String mode) throws IOException, RestClientException {
        return this.setMode(mode, null);
    }

    public ModeUpdateRequest setMode(String mode, String subject) throws IOException, RestClientException {
        ModeUpdateRequest request = new ModeUpdateRequest();
        request.setMode(mode);
        return this.setMode(DEFAULT_REQUEST_PROPERTIES, request, subject);
    }

    public ModeUpdateRequest setMode(Map<String, String> requestProperties, ModeUpdateRequest modeUpdateRequest, String subject) throws IOException, RestClientException {
        String path = subject != null ? String.format("/mode/%s", subject) : "/mode";
        ModeUpdateRequest response = this.httpRequest(path, "PUT", modeUpdateRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, UPDATE_MODE_RESPONSE_TYPE_REFERENCE);
        return response;
    }

    public ModeGetResponse getMode() throws IOException, RestClientException {
        return this.getMode(null);
    }

    public ModeGetResponse getMode(String subject) throws IOException, RestClientException {
        String path = subject != null ? String.format("/mode/%s", subject) : "/mode";
        ModeGetResponse mode = this.httpRequest(path, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_MODE_RESPONSE_TYPE);
        return mode;
    }

    public SchemaString getId(int id) throws IOException, RestClientException {
        return this.getId(DEFAULT_REQUEST_PROPERTIES, id, false);
    }

    public SchemaString getId(Map<String, String> requestProperties, int id) throws IOException, RestClientException {
        return this.getId(requestProperties, id, false);
    }

    public SchemaString getId(int id, boolean fetchMaxId) throws IOException, RestClientException {
        return this.getId(DEFAULT_REQUEST_PROPERTIES, id, fetchMaxId);
    }

    public SchemaString getId(Map<String, String> requestProperties, int id, boolean fetchMaxId) throws IOException, RestClientException {
        String path = String.format("/schemas/ids/%d?fetchMaxId=%b", id, fetchMaxId);
        SchemaString response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_ID_RESPONSE_TYPE);
        return response;
    }

    public Schema getVersion(String subject, int version) throws IOException, RestClientException {
        return this.getVersion(DEFAULT_REQUEST_PROPERTIES, subject, version);
    }

    public Schema getVersion(Map<String, String> requestProperties, String subject, int version) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/%d", subject, version);
        Schema response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public Schema getLatestVersion(String subject) throws IOException, RestClientException {
        return this.getLatestVersion(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public Schema getLatestVersion(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/latest", subject);
        Schema response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public String getVersionSchemaOnly(String subject, int version) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/%d/schema", subject, version);
        JsonNode response = this.httpRequest(path, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE);
        return response.toString();
    }

    public String getLatestVersionSchemaOnly(String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/latest/schema", subject);
        JsonNode response = this.httpRequest(path, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE);
        return response.toString();
    }

    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        return this.getAllVersions(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public List<Integer> getAllVersions(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions", subject);
        List<Integer> response = this.httpRequest(path, "GET", null, requestProperties, ALL_VERSIONS_RESPONSE_TYPE);
        return response;
    }

    public List<String> getAllSubjects() throws IOException, RestClientException {
        return this.getAllSubjects(DEFAULT_REQUEST_PROPERTIES);
    }

    public List<String> getAllSubjects(Map<String, String> requestProperties) throws IOException, RestClientException {
        List<String> response = this.httpRequest("/subjects", "GET", null, requestProperties, ALL_TOPICS_RESPONSE_TYPE);
        return response;
    }

    public List<String> getAllSubjectsById(int id) throws IOException, RestClientException {
        return this.getAllSubjectsById(DEFAULT_REQUEST_PROPERTIES, id);
    }

    public List<String> getAllSubjectsById(Map<String, String> requestProperties, int id) throws IOException, RestClientException {
        String path = String.format("/schemas/ids/%d/subjects", id);
        List<String> response = this.httpRequest(path, "GET", null, requestProperties, ALL_TOPICS_RESPONSE_TYPE);
        return response;
    }

    public Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version) throws IOException, RestClientException {
        String path = String.format("/subjects/%s/versions/%s", subject, version);
        Integer response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_VERSION_RESPONSE_TYPE);
        return response;
    }

    public List<Integer> deleteSubject(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = String.format("/subjects/%s", subject);
        List<Integer> response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_RESPONSE_TYPE);
        return response;
    }

    public ServerClusterId getClusterId() throws IOException, RestClientException {
        return this.getClusterId(DEFAULT_REQUEST_PROPERTIES);
    }

    public ServerClusterId getClusterId(Map<String, String> requestProperties) throws IOException, RestClientException {
        return this.httpRequest("/v1/metadata/id", "GET", null, requestProperties, GET_CLUSTER_ID_RESPONSE_TYPE);
    }

    private static List<String> parseBaseUrl(String baseUrl) {
        List<String> baseUrls = Arrays.asList(baseUrl.split("\\s*,\\s*"));
        if (baseUrls.isEmpty()) {
            throw new IllegalArgumentException("Missing required schema registry url list");
        }
        return baseUrls;
    }

    public UrlList getBaseUrls() {
        return this.baseUrls;
    }

    private void setAuthRequestHeaders(HttpURLConnection connection) {
        String bearerToken;
        String userInfo;
        if (this.basicAuthCredentialProvider != null && (userInfo = this.basicAuthCredentialProvider.getUserInfo(connection.getURL())) != null) {
            String authHeader = Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty(AUTHORIZATION_HEADER, "Basic " + authHeader);
        }
        if (this.bearerAuthCredentialProvider != null && (bearerToken = this.bearerAuthCredentialProvider.getBearerToken(connection.getURL())) != null) {
            connection.setRequestProperty(AUTHORIZATION_HEADER, "Bearer " + bearerToken);
        }
    }

    private void setCustomHeaders(HttpURLConnection connection) {
        if (this.httpHeaders != null) {
            this.httpHeaders.forEach((k, v) -> connection.setRequestProperty((String)k, (String)v));
        }
    }

    public void setBasicAuthCredentialProvider(BasicAuthCredentialProvider basicAuthCredentialProvider) {
        this.basicAuthCredentialProvider = basicAuthCredentialProvider;
    }

    public void setBearerAuthCredentialProvider(BearerAuthCredentialProvider bearerAuthCredentialProvider) {
        this.bearerAuthCredentialProvider = bearerAuthCredentialProvider;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
    }
}

