/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaValidator;
import io.confluent.kafka.schemaregistry.SchemaValidatorBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompatibilityChecker {
    private static final SchemaValidator BACKWARD_VALIDATOR = new SchemaValidatorBuilder().canReadStrategy().validateLatest();
    public static final CompatibilityChecker BACKWARD_CHECKER = new CompatibilityChecker(BACKWARD_VALIDATOR);
    private static final SchemaValidator FORWARD_VALIDATOR = new SchemaValidatorBuilder().canBeReadStrategy().validateLatest();
    public static final CompatibilityChecker FORWARD_CHECKER = new CompatibilityChecker(FORWARD_VALIDATOR);
    private static final SchemaValidator FULL_VALIDATOR = new SchemaValidatorBuilder().mutualReadStrategy().validateLatest();
    public static final CompatibilityChecker FULL_CHECKER = new CompatibilityChecker(FULL_VALIDATOR);
    private static final SchemaValidator BACKWARD_TRANSITIVE_VALIDATOR = new SchemaValidatorBuilder().canReadStrategy().validateAll();
    public static final CompatibilityChecker BACKWARD_TRANSITIVE_CHECKER = new CompatibilityChecker(BACKWARD_TRANSITIVE_VALIDATOR);
    private static final SchemaValidator FORWARD_TRANSITIVE_VALIDATOR = new SchemaValidatorBuilder().canBeReadStrategy().validateAll();
    public static final CompatibilityChecker FORWARD_TRANSITIVE_CHECKER = new CompatibilityChecker(FORWARD_TRANSITIVE_VALIDATOR);
    private static final SchemaValidator FULL_TRANSITIVE_VALIDATOR = new SchemaValidatorBuilder().mutualReadStrategy().validateAll();
    public static final CompatibilityChecker FULL_TRANSITIVE_CHECKER = new CompatibilityChecker(FULL_TRANSITIVE_VALIDATOR);
    private static final SchemaValidator NO_OP_VALIDATOR = (schema, schemas) -> true;
    public static final CompatibilityChecker NO_OP_CHECKER = new CompatibilityChecker(NO_OP_VALIDATOR);
    private final SchemaValidator validator;

    private CompatibilityChecker(SchemaValidator validator) {
        this.validator = validator;
    }

    public boolean isCompatible(ParsedSchema newSchema, List<? extends ParsedSchema> previousSchemas) {
        ArrayList<? extends ParsedSchema> previousSchemasCopy = new ArrayList<ParsedSchema>(previousSchemas);
        Collections.reverse(previousSchemasCopy);
        return this.validator.validate(newSchema, previousSchemasCopy);
    }

    public static CompatibilityChecker checker(CompatibilityLevel level) {
        switch (level) {
            case NONE: {
                return NO_OP_CHECKER;
            }
            case BACKWARD: {
                return BACKWARD_CHECKER;
            }
            case BACKWARD_TRANSITIVE: {
                return BACKWARD_TRANSITIVE_CHECKER;
            }
            case FORWARD: {
                return FORWARD_CHECKER;
            }
            case FORWARD_TRANSITIVE: {
                return FORWARD_TRANSITIVE_CHECKER;
            }
            case FULL: {
                return FULL_CHECKER;
            }
            case FULL_TRANSITIVE: {
                return FULL_TRANSITIVE_CHECKER;
            }
        }
        throw new IllegalArgumentException("Invalid level " + (Object)((Object)level));
    }
}

