/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth;

import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.OauthTokenCache;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.exceptions.SchemaRegistryOauthTokenRetrieverException;
import java.io.IOException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.secured.ValidateException;

class CachedOauthTokenRetriever {
    private AccessTokenRetriever accessTokenRetriever;
    private AccessTokenValidator accessTokenValidator;
    private OauthTokenCache oauthTokenCache;

    CachedOauthTokenRetriever() {
    }

    public void configure(AccessTokenRetriever accessTokenRetriever, AccessTokenValidator accessTokenValidator, OauthTokenCache oauthTokenCache) {
        this.accessTokenRetriever = accessTokenRetriever;
        this.accessTokenValidator = accessTokenValidator;
        this.oauthTokenCache = oauthTokenCache;
    }

    public String getToken() {
        if (this.oauthTokenCache.isTokenExpired()) {
            OAuthBearerToken oauthBearerToken;
            String token = null;
            try {
                token = this.accessTokenRetriever.retrieve();
            }
            catch (IOException | RuntimeException e) {
                throw new SchemaRegistryOauthTokenRetrieverException("Failed to Retrieve OAuth Token for Schema Registry", e);
            }
            try {
                oauthBearerToken = this.accessTokenValidator.validate(token);
            }
            catch (ValidateException e) {
                throw new SchemaRegistryOauthTokenRetrieverException("OAuth Token for Schema Registry is Invalid", e);
            }
            this.oauthTokenCache.setCurrentToken(oauthBearerToken);
        }
        return this.oauthTokenCache.getCurrentToken().value();
    }
}

