/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RuleSet {
    private final List<Rule> migrationRules;
    private final List<Rule> domainRules;

    @JsonCreator
    public RuleSet(@JsonProperty(value="migrationRules") List<Rule> migrationRules, @JsonProperty(value="domainRules") List<Rule> domainRules) {
        this.migrationRules = migrationRules != null ? Collections.unmodifiableList(migrationRules) : Collections.emptyList();
        this.domainRules = domainRules != null ? Collections.unmodifiableList(domainRules) : Collections.emptyList();
    }

    public List<Rule> getMigrationRules() {
        return this.migrationRules;
    }

    public List<Rule> getDomainRules() {
        return this.domainRules;
    }

    public boolean hasRules(RuleMode mode) {
        switch (mode) {
            case UPGRADE: 
            case DOWNGRADE: {
                return this.getMigrationRules().stream().anyMatch(r -> r.getMode() == mode || r.getMode() == RuleMode.UPDOWN);
            }
            case UPDOWN: {
                return this.getMigrationRules().stream().anyMatch(r -> r.getMode() == mode);
            }
            case WRITE: 
            case READ: {
                return this.getDomainRules().stream().anyMatch(r -> r.getMode() == mode || r.getMode() == RuleMode.WRITEREAD);
            }
            case WRITEREAD: {
                return this.getDomainRules().stream().anyMatch(r -> r.getMode() == mode);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleSet ruleSet = (RuleSet)o;
        return Objects.equals(this.migrationRules, ruleSet.migrationRules) && Objects.equals(this.domainRules, ruleSet.domainRules);
    }

    public int hashCode() {
        return Objects.hash(this.migrationRules, this.domainRules);
    }

    public String toString() {
        return "Rules{migrationRules=" + this.migrationRules + ", domainRules=" + this.domainRules + '}';
    }

    public void updateHash(MessageDigest md) {
        if (this.migrationRules != null) {
            this.migrationRules.forEach(r -> r.updateHash(md));
        }
        if (this.domainRules != null) {
            this.domainRules.forEach(r -> r.updateHash(md));
        }
    }

    public void validate() throws RuleException {
        String name;
        HashSet<String> names;
        if (this.migrationRules != null) {
            names = new HashSet<String>();
            for (Rule rule : this.migrationRules) {
                name = rule.getName();
                if (names.contains(name)) {
                    throw new RuleException("Found rule with duplicate name '" + name + "'");
                }
                names.add(name);
                rule.validate();
                if (rule.getMode().isMigrationRule()) continue;
                throw new RuleException("Migration rules can only be UPGRADE, DOWNGRADE, UPDOWN");
            }
        }
        if (this.domainRules != null) {
            names = new HashSet();
            for (Rule rule : this.domainRules) {
                name = rule.getName();
                if (names.contains(name)) {
                    throw new RuleException("Found rule with duplicate name '" + name + "'");
                }
                names.add(name);
                rule.validate();
                if (rule.getMode().isDomainRule()) continue;
                throw new RuleException("Domain rules can only be WRITE, READ, WRITEREAD");
            }
        }
    }

    public static RuleSet mergeRuleSets(RuleSet oldRuleSet, RuleSet newRuleSet) {
        if (oldRuleSet == null) {
            return newRuleSet;
        }
        if (newRuleSet == null) {
            return oldRuleSet;
        }
        return new RuleSet(RuleSet.merge(oldRuleSet.migrationRules, newRuleSet.migrationRules), RuleSet.merge(oldRuleSet.domainRules, newRuleSet.domainRules));
    }

    private static List<Rule> merge(List<Rule> oldRules, List<Rule> newRules) {
        if (oldRules == null || oldRules.isEmpty()) {
            return newRules;
        }
        if (newRules == null || newRules.isEmpty()) {
            return oldRules;
        }
        Set newRuleNames = newRules.stream().map(Rule::getName).collect(Collectors.toSet());
        List filteredOldRules = oldRules.stream().filter(r -> !newRuleNames.contains(r.getName())).collect(Collectors.toCollection(ArrayList::new));
        filteredOldRules.addAll(newRules);
        return filteredOldRules;
    }
}

