/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules;

import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.rules.FieldTransform;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.rules.RuleExecutor;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FieldRuleExecutor
extends RuleExecutor {
    public static final Logger log = LoggerFactory.getLogger(FieldRuleExecutor.class);

    public FieldTransform newTransform(RuleContext var1) throws RuleException;

    @Override
    default public Object transform(RuleContext ctx, Object message) throws RuleException {
        switch (ctx.ruleMode()) {
            case WRITE: 
            case UPGRADE: {
                Rule otherRule;
                int i;
                for (i = ctx.index() + 1; i < ctx.rules().size(); ++i) {
                    otherRule = ctx.rules().get(i);
                    if (!FieldRuleExecutor.areTransformsWithSameTags(ctx.rule(), otherRule)) continue;
                    log.debug("Ignoring rule '{}' during {} as rule '{}' has the same tag(s) and overrides it", new Object[]{ctx.rule().getName(), ctx.ruleMode(), otherRule.getName()});
                    return message;
                }
                break;
            }
            case READ: 
            case DOWNGRADE: {
                Rule otherRule;
                int i;
                for (i = 0; i < ctx.index(); ++i) {
                    otherRule = ctx.rules().get(i);
                    if (!FieldRuleExecutor.areTransformsWithSameTags(ctx.rule(), otherRule)) continue;
                    log.debug("Ignoring rule '{}' during {} as rule '{}' has the same tag(s) and overrides it", new Object[]{ctx.rule().getName(), ctx.ruleMode(), otherRule.getName()});
                    return message;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rule mode " + (Object)((Object)ctx.ruleMode()));
            }
        }
        try (FieldTransform transform = this.newTransform(ctx);){
            if (transform != null) {
                Object object = ctx.target().transformMessage(ctx, transform, message);
                return object;
            }
            Object object = message;
            return object;
        }
    }

    public static boolean areTransformsWithSameTags(Rule rule1, Rule rule2) {
        return rule1.getTags().size() > 0 && rule1.getKind() == RuleKind.TRANSFORM && rule1.getKind() == rule2.getKind() && rule1.getMode() == rule2.getMode() && Objects.equals(rule1.getType(), rule2.getType()) && Objects.equals(rule1.getTags(), rule2.getTags());
    }
}

