/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.Lists;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.avro.Difference;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.rules.FieldTransform;
import io.confluent.kafka.schemaregistry.rules.RuleConditionException;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchema
implements ParsedSchema {
    private static final Logger log = LoggerFactory.getLogger(AvroSchema.class);
    public static final String TYPE = "AVRO";
    public static final String TAGS = "confluent:tags";
    public static final String NAME_FIELD = "name";
    public static final String FIELDS_FIELD = "fields";
    private final Schema schemaObj;
    private String canonicalString;
    private final Integer version;
    private final List<SchemaReference> references;
    private final Map<String, String> resolvedReferences;
    private final Metadata metadata;
    private final RuleSet ruleSet;
    private final boolean isNew;
    private transient int hashCode = Integer.MIN_VALUE;
    private static final int NO_HASHCODE = Integer.MIN_VALUE;
    private static final ObjectMapper jsonMapper = JacksonMapper.INSTANCE;

    public AvroSchema(String schemaString) {
        this(schemaString, Collections.emptyList(), Collections.emptyMap(), null);
    }

    public AvroSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version) {
        this(schemaString, references, resolvedReferences, version, false);
    }

    public AvroSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version, boolean isNew) {
        this(schemaString, references, resolvedReferences, null, null, version, isNew);
    }

    public AvroSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Metadata metadata, RuleSet ruleSet, Integer version, boolean isNew) {
        this.isNew = isNew;
        Schema.Parser parser = this.getParser();
        for (String schema : resolvedReferences.values()) {
            parser.parse(schema);
        }
        this.schemaObj = schemaString != null ? parser.parse(schemaString) : null;
        this.references = Collections.unmodifiableList(references);
        this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
        this.metadata = metadata;
        this.ruleSet = ruleSet;
        this.version = version;
    }

    public AvroSchema(Schema schemaObj) {
        this(schemaObj, null);
    }

    public AvroSchema(Schema schemaObj, Integer version) {
        this.isNew = false;
        this.schemaObj = schemaObj;
        this.references = Collections.emptyList();
        this.resolvedReferences = Collections.emptyMap();
        this.metadata = null;
        this.ruleSet = null;
        this.version = version;
    }

    private AvroSchema(Schema schemaObj, String canonicalString, List<SchemaReference> references, Map<String, String> resolvedReferences, Metadata metadata, RuleSet ruleSet, Integer version, boolean isNew) {
        this.isNew = isNew;
        this.schemaObj = schemaObj;
        this.canonicalString = canonicalString;
        this.references = references;
        this.resolvedReferences = resolvedReferences;
        this.metadata = metadata;
        this.ruleSet = ruleSet;
        this.version = version;
    }

    @Override
    public AvroSchema copy() {
        return new AvroSchema(this.schemaObj, this.canonicalString, this.references, this.resolvedReferences, this.metadata, this.ruleSet, this.version, this.isNew);
    }

    @Override
    public AvroSchema copy(Integer version) {
        return new AvroSchema(this.schemaObj, this.canonicalString, this.references, this.resolvedReferences, this.metadata, this.ruleSet, version, this.isNew);
    }

    @Override
    public AvroSchema copy(Metadata metadata, RuleSet ruleSet) {
        return new AvroSchema(this.schemaObj, this.canonicalString, this.references, this.resolvedReferences, metadata, ruleSet, this.version, this.isNew);
    }

    @Override
    public ParsedSchema copy(Map<SchemaEntity, Set<String>> tagsToAdd, Map<SchemaEntity, Set<String>> tagsToRemove) {
        JsonNode original;
        AvroSchema schemaCopy = this.copy();
        try {
            original = jsonMapper.readTree(schemaCopy.canonicalString());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.modifySchemaTags(original, tagsToAdd, tagsToRemove);
        return new AvroSchema(original.toString(), schemaCopy.references(), schemaCopy.resolvedReferences(), schemaCopy.metadata(), schemaCopy.ruleSet(), schemaCopy.version(), schemaCopy.isNew());
    }

    protected Schema.Parser getParser() {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(this.isNew());
        return parser;
    }

    public Schema rawSchema() {
        return this.schemaObj;
    }

    @Override
    public boolean hasTopLevelField(String field) {
        return this.schemaObj != null && this.schemaObj.getType() == Schema.Type.RECORD && this.schemaObj.getField(field) != null;
    }

    @Override
    public String schemaType() {
        return TYPE;
    }

    @Override
    public String name() {
        if (this.schemaObj != null && this.schemaObj.getType() == Schema.Type.RECORD) {
            return this.schemaObj.getFullName();
        }
        return null;
    }

    @Override
    public String canonicalString() {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.canonicalString == null) {
            Schema.Parser parser = this.getParser();
            ArrayList<Schema> schemaRefs = new ArrayList<Schema>();
            for (String schema : this.resolvedReferences.values()) {
                Schema schemaRef = parser.parse(schema);
                schemaRefs.add(schemaRef);
            }
            this.canonicalString = this.schemaObj.toString(schemaRefs, false);
        }
        return this.canonicalString;
    }

    @Override
    public String formattedString(String format) {
        if (format == null || format.trim().isEmpty()) {
            return this.canonicalString();
        }
        Format formatEnum = Format.get(format);
        switch (formatEnum) {
            case DEFAULT: {
                return this.canonicalString();
            }
            case RESOLVED: {
                return this.schemaObj != null ? this.schemaObj.toString() : null;
            }
        }
        log.warn("Unsupported format {}", (Object)format);
        return this.canonicalString();
    }

    @Override
    public Integer version() {
        return this.version;
    }

    @Override
    public List<SchemaReference> references() {
        return this.references;
    }

    public Map<String, String> resolvedReferences() {
        return this.resolvedReferences;
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public RuleSet ruleSet() {
        return this.ruleSet;
    }

    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public AvroSchema normalize() {
        String normalized = AvroSchemaUtils.toNormalizedString(this);
        return new AvroSchema(normalized, this.references.stream().sorted().distinct().collect(Collectors.toList()), this.resolvedReferences, this.version, this.isNew);
    }

    @Override
    public List<String> isBackwardCompatible(ParsedSchema previousSchema) {
        if (!this.schemaType().equals(previousSchema.schemaType())) {
            return Lists.newArrayList((Object[])new String[]{"Incompatible because of different schema type"});
        }
        try {
            SchemaCompatibility.SchemaPairCompatibility result = SchemaCompatibility.checkReaderWriterCompatibility((Schema)this.schemaObj, (Schema)((AvroSchema)previousSchema).schemaObj);
            return result.getResult().getIncompatibilities().stream().map(Difference::new).map(Difference::toString).collect(Collectors.toCollection(ArrayList::new));
        }
        catch (Exception e) {
            log.error("Unexpected exception during compatibility check", (Throwable)e);
            return Lists.newArrayList((Object[])new String[]{"Unexpected exception during compatibility check: " + e.getMessage()});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroSchema that = (AvroSchema)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.references, that.references) && Objects.equals(this.schemaObj, that.schemaObj) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ruleSet, that.ruleSet) && this.metaEqual(this.schemaObj, that.schemaObj, new HashMap<IdentityPair<Schema, Schema>, Boolean>());
    }

    private boolean metaEqual(Schema schema1, Schema schema2, Map<IdentityPair<Schema, Schema>, Boolean> cache) {
        Schema.Type type2;
        if (schema1 == schema2) {
            return true;
        }
        if (schema1 == null || schema2 == null) {
            return false;
        }
        Schema.Type type1 = schema1.getType();
        if (type1 != (type2 = schema2.getType())) {
            return false;
        }
        switch (type1) {
            case RECORD: {
                IdentityPair<Schema, Schema> sp = new IdentityPair<Schema, Schema>(schema1, schema2);
                Boolean cacheHit = cache.putIfAbsent(sp, true);
                if (cacheHit != null) {
                    return cacheHit;
                }
                boolean equals = Objects.equals(schema1.getAliases(), schema2.getAliases()) && Objects.equals(schema1.getDoc(), schema2.getDoc()) && this.fieldMetaEqual(schema1.getFields(), schema2.getFields(), cache);
                cache.put(sp, equals);
                return equals;
            }
            case ENUM: {
                return Objects.equals(schema1.getAliases(), schema2.getAliases()) && Objects.equals(schema1.getDoc(), schema2.getDoc()) && Objects.equals(schema1.getEnumDefault(), schema2.getEnumDefault());
            }
            case FIXED: {
                return Objects.equals(schema1.getAliases(), schema2.getAliases()) && Objects.equals(schema1.getDoc(), schema2.getDoc());
            }
            case UNION: {
                List types1 = schema1.getTypes();
                List types2 = schema2.getTypes();
                if (types1.size() != types2.size()) {
                    return false;
                }
                for (int i = 0; i < types1.size(); ++i) {
                    if (this.metaEqual((Schema)types1.get(i), (Schema)types2.get(i), cache)) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private boolean fieldMetaEqual(List<Schema.Field> fields1, List<Schema.Field> fields2, Map<IdentityPair<Schema, Schema>, Boolean> cache) {
        if (fields1.size() != fields2.size()) {
            return false;
        }
        for (int i = 0; i < fields1.size(); ++i) {
            Schema.Field field2;
            Schema.Field field1 = fields1.get(i);
            if (field1 == (field2 = fields2.get(i))) continue;
            if (!Objects.equals(field1.aliases(), field2.aliases()) || !Objects.equals(field1.doc(), field2.doc())) {
                return false;
            }
            boolean fieldSchemaMetaEqual = this.metaEqual(field1.schema(), field2.schema(), cache);
            if (fieldSchemaMetaEqual) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = Objects.hash(this.schemaObj, this.references, this.version, this.metadata, this.ruleSet) + this.metaHash(this.schemaObj, new IdentityHashMap<Schema, Integer>());
        }
        return this.hashCode;
    }

    private int metaHash(Schema schema, Map<Schema, Integer> cache) {
        if (schema == null) {
            return 0;
        }
        switch (schema.getType()) {
            case RECORD: {
                Integer cacheHit = cache.putIfAbsent(schema, 0);
                if (cacheHit != null) {
                    return cacheHit;
                }
                int result = Objects.hash(schema.getAliases(), schema.getDoc()) + this.fieldMetaHash(schema.getFields(), cache);
                cache.put(schema, result);
                return result;
            }
            case ENUM: {
                return Objects.hash(schema.getAliases(), schema.getDoc(), schema.getEnumDefault());
            }
            case FIXED: {
                return Objects.hash(schema.getAliases(), schema.getDoc());
            }
            case UNION: {
                int hash = 0;
                List types = schema.getTypes();
                for (Schema type : types) {
                    hash += this.metaHash(type, cache);
                }
                return hash;
            }
        }
        return 0;
    }

    private int fieldMetaHash(List<Schema.Field> fields, Map<Schema, Integer> cache) {
        int hash = 0;
        for (Schema.Field field : fields) {
            hash += Objects.hash(field.aliases(), field.doc()) + this.metaHash(field.schema(), cache);
        }
        return hash;
    }

    public String toString() {
        return this.canonicalString();
    }

    @Override
    public Object fromJson(JsonNode json) throws IOException {
        return AvroSchemaUtils.toObject(json, this);
    }

    @Override
    public JsonNode toJson(Object message) throws IOException {
        if (message instanceof JsonNode) {
            return (JsonNode)message;
        }
        return JacksonMapper.INSTANCE.readTree(AvroSchemaUtils.toJson(message));
    }

    @Override
    public Object copyMessage(Object message) {
        GenericData data = AvroSchemaUtils.getData(this.rawSchema(), message, false, false);
        return data.deepCopy(this.rawSchema(), message);
    }

    @Override
    public Object transformMessage(RuleContext ctx, FieldTransform transform, Object message) throws RuleException {
        try {
            return this.toTransformedMessage(ctx, this.rawSchema(), message, transform);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RuleException) {
                throw (RuleException)e.getCause();
            }
            throw e;
        }
    }

    private Object toTransformedMessage(RuleContext ctx, Schema schema, Object message, FieldTransform transform) {
        RuleContext.FieldContext fieldCtx = ctx.currentField();
        if (schema == null) {
            return message;
        }
        if (fieldCtx != null) {
            fieldCtx.setType(this.getType(schema));
        }
        Schema.Type st = schema.getType();
        switch (st) {
            case UNION: {
                GenericData data = AvroSchemaUtils.getData(schema, message, false, false);
                int unionIndex = data.resolveUnion(schema, message);
                return this.toTransformedMessage(ctx, (Schema)schema.getTypes().get(unionIndex), message, transform);
            }
            case ARRAY: {
                if (!(message instanceof Iterable)) {
                    log.warn("Object does not match an array schema");
                    return message;
                }
                return StreamSupport.stream(((Iterable)message).spliterator(), false).map(it -> this.toTransformedMessage(ctx, schema.getElementType(), it, transform)).collect(Collectors.toList());
            }
            case MAP: {
                if (!(message instanceof Map)) {
                    log.warn("Object does not match a map schema");
                    return message;
                }
                return ((Map)message).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toTransformedMessage(ctx, schema.getValueType(), e.getValue(), transform), (e1, e2) -> e1));
            }
            case RECORD: {
                if (message == null) {
                    return null;
                }
                GenericData data = AvroSchemaUtils.getData(schema, message, false, false);
                for (Schema.Field f : schema.getFields()) {
                    String fullName = schema.getFullName() + "." + f.name();
                    RuleContext.FieldContext fc = ctx.enterField(message, fullName, f.name(), this.getType(f.schema()), this.getInlineTags(f));
                    Throwable throwable = null;
                    try {
                        if (fc == null) continue;
                        Object value = data.getField(message, f.name(), f.pos());
                        if (value instanceof Utf8) {
                            value = value.toString();
                        }
                        Object newValue = this.toTransformedMessage(ctx, f.schema(), value, transform);
                        if (ctx.rule().getKind() == RuleKind.CONDITION) {
                            if (!Boolean.FALSE.equals(newValue)) continue;
                            throw new RuntimeException(new RuleConditionException(ctx.rule()));
                        }
                        data.setField(message, f.name(), f.pos(), newValue);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fc == null) continue;
                        if (throwable != null) {
                            try {
                                fc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fc.close();
                    }
                }
                return message;
            }
        }
        if (fieldCtx != null) {
            try {
                SortedSet<String> ruleTags = ctx.rule().getTags();
                if (ruleTags.isEmpty()) {
                    return AvroSchema.fieldTransform(ctx, message, transform, fieldCtx);
                }
                if (!RuleContext.disjoint(fieldCtx.getTags(), ruleTags)) {
                    return AvroSchema.fieldTransform(ctx, message, transform, fieldCtx);
                }
            }
            catch (RuleException e3) {
                throw new RuntimeException(e3);
            }
        }
        return message;
    }

    private static Object fieldTransform(RuleContext ctx, Object message, FieldTransform transform, RuleContext.FieldContext fieldCtx) throws RuleException {
        Object result;
        if (message instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)message;
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            message = bytes;
        }
        if ((result = transform.transform(ctx, fieldCtx, message)) instanceof byte[]) {
            result = ByteBuffer.wrap((byte[])result);
        }
        return result;
    }

    private RuleContext.Type getType(Schema schema) {
        switch (schema.getType()) {
            case RECORD: {
                return RuleContext.Type.RECORD;
            }
            case ENUM: {
                return RuleContext.Type.ENUM;
            }
            case ARRAY: {
                return RuleContext.Type.ARRAY;
            }
            case MAP: {
                return RuleContext.Type.MAP;
            }
            case UNION: {
                return RuleContext.Type.COMBINED;
            }
            case FIXED: {
                return RuleContext.Type.FIXED;
            }
            case STRING: {
                return RuleContext.Type.STRING;
            }
            case BYTES: {
                return RuleContext.Type.BYTES;
            }
            case INT: {
                return RuleContext.Type.INT;
            }
            case LONG: {
                return RuleContext.Type.LONG;
            }
            case FLOAT: {
                return RuleContext.Type.FLOAT;
            }
            case DOUBLE: {
                return RuleContext.Type.DOUBLE;
            }
            case BOOLEAN: {
                return RuleContext.Type.BOOLEAN;
            }
        }
        return RuleContext.Type.NULL;
    }

    @Override
    public Set<String> inlineTags() {
        try {
            LinkedHashSet<String> tags = new LinkedHashSet<String>();
            String canonicalString = this.canonicalString();
            if (canonicalString == null) {
                return tags;
            }
            JsonNode jsonNode = jsonMapper.readTree(canonicalString);
            this.getInlineTagsRecursively(tags, jsonNode);
            return tags;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not parse schema: " + this.canonicalString());
        }
    }

    private void getInlineTagsRecursively(Set<String> tags, JsonNode node) {
        tags.addAll(this.getInlineTags(node));
        node.forEach(n -> this.getInlineTagsRecursively(tags, (JsonNode)n));
    }

    @Override
    public Map<SchemaEntity, Set<String>> inlineTaggedEntities() {
        LinkedHashMap<SchemaEntity, Set<String>> tags = new LinkedHashMap<SchemaEntity, Set<String>>();
        Schema schema = this.rawSchema();
        if (schema == null) {
            return tags;
        }
        this.getInlineTaggedEntitiesRecursively(tags, schema);
        return tags;
    }

    private void getInlineTaggedEntitiesRecursively(Map<SchemaEntity, Set<String>> tags, Schema schema) {
        switch (schema.getType()) {
            case UNION: {
                for (Schema subtype : schema.getTypes()) {
                    this.getInlineTaggedEntitiesRecursively(tags, subtype);
                }
                break;
            }
            case ARRAY: {
                this.getInlineTaggedEntitiesRecursively(tags, schema.getElementType());
                break;
            }
            case MAP: {
                this.getInlineTaggedEntitiesRecursively(tags, schema.getValueType());
                break;
            }
            case RECORD: {
                Set<String> recordTags = this.getInlineTags(schema);
                if (!recordTags.isEmpty()) {
                    tags.put(new SchemaEntity(schema.getFullName(), SchemaEntity.EntityType.SR_RECORD), recordTags);
                }
                for (Schema.Field f : schema.getFields()) {
                    Set<String> fieldTags = this.getInlineTags(f);
                    if (!fieldTags.isEmpty()) {
                        String x = schema.getFullName() + "." + f.name();
                        tags.put(new SchemaEntity(schema.getFullName() + "." + f.name(), SchemaEntity.EntityType.SR_FIELD), fieldTags);
                    }
                    this.getInlineTaggedEntitiesRecursively(tags, f.schema());
                }
                break;
            }
        }
    }

    private Set<String> getInlineTags(Schema record) {
        Object prop = record.getObjectProp(TAGS);
        if (prop instanceof List) {
            List tags = (List)prop;
            LinkedHashSet<String> result = new LinkedHashSet<String>(tags.size());
            for (Object tag : tags) {
                result.add(tag.toString());
            }
            return result;
        }
        return Collections.emptySet();
    }

    private Set<String> getInlineTags(Schema.Field field) {
        Object prop = field.getObjectProp(TAGS);
        if (prop instanceof List) {
            List tags = (List)prop;
            LinkedHashSet<String> result = new LinkedHashSet<String>(tags.size());
            for (Object tag : tags) {
                result.add(tag.toString());
            }
            return result;
        }
        return Collections.emptySet();
    }

    private Set<String> getInlineTags(JsonNode tagNode) {
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        if (tagNode.has(TAGS)) {
            ArrayNode tagArray = (ArrayNode)tagNode.get(TAGS);
            tagArray.elements().forEachRemaining(tag -> tags.add(tag.asText()));
        }
        return tags;
    }

    private void modifySchemaTags(JsonNode node, Map<SchemaEntity, Set<String>> tagsToAddMap, Map<SchemaEntity, Set<String>> tagsToRemoveMap) {
        LinkedHashSet<SchemaEntity> entityToModify = new LinkedHashSet<SchemaEntity>(tagsToAddMap.keySet());
        entityToModify.addAll(tagsToRemoveMap.keySet());
        for (SchemaEntity entity : entityToModify) {
            Set<String> tagsToRemove;
            JsonNode nodePtr = AvroSchemaUtils.findMatchingEntity(node, entity);
            Set<String> allTags = this.getInlineTags(nodePtr);
            Set<String> tagsToAdd = tagsToAddMap.get(entity);
            if (tagsToAdd != null && !tagsToAdd.isEmpty()) {
                allTags.addAll(tagsToAdd);
            }
            if ((tagsToRemove = tagsToRemoveMap.get(entity)) != null && !tagsToRemove.isEmpty()) {
                allTags.removeAll(tagsToRemove);
            }
            if (allTags.isEmpty()) {
                ((ObjectNode)nodePtr).remove(TAGS);
                continue;
            }
            ((ObjectNode)nodePtr).replace(TAGS, jsonMapper.valueToTree(allTags));
        }
    }

    public static enum Format {
        DEFAULT("default"),
        RESOLVED("resolved");

        private static final EnumHashBiMap<Format, String> lookup;
        private final String symbol;

        private Format(String symbol) {
            this.symbol = symbol;
        }

        public String symbol() {
            return this.symbol;
        }

        public static Format get(String symbol) {
            return (Format)((Object)lookup.inverse().get((Object)symbol));
        }

        public static Set<String> symbols() {
            return lookup.inverse().keySet();
        }

        public String toString() {
            return this.symbol();
        }

        static {
            lookup = EnumHashBiMap.create(Format.class);
            for (Format type : Format.values()) {
                lookup.put((Enum)type, (Object)type.symbol());
            }
        }
    }

    static class IdentityPair<K, V> {
        private final K key;
        private final V value;

        public IdentityPair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdentityPair pair = (IdentityPair)o;
            return this.key == pair.key && this.value == pair.value;
        }

        public int hashCode() {
            return System.identityHashCode(this.key) + System.identityHashCode(this.value);
        }

        public String toString() {
            return "IdentityPair{key=" + this.key + ", value=" + this.value + '}';
        }
    }
}

