/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.kafka.schemaregistry.AbstractSchemaProvider;
import io.confluent.kafka.schemaregistry.CompatibilityChecker;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.client.SchemaVersionFetcher;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.rules.FieldTransform;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public interface ParsedSchema {
    public static final String RESERVED = "confluent:reserved";

    public String schemaType();

    public String name();

    public String canonicalString();

    default public String formattedString(String format) {
        if (format == null || format.trim().isEmpty()) {
            return this.canonicalString();
        }
        throw new IllegalArgumentException("Format not supported: " + format);
    }

    public Integer version();

    public List<SchemaReference> references();

    public Metadata metadata();

    public RuleSet ruleSet();

    default public Set<String> tags() {
        Set<String> inlineTags = this.inlineTags();
        Metadata metadata = this.metadata();
        if (metadata == null || metadata.getTags() == null) {
            return inlineTags;
        }
        LinkedHashSet<String> allTags = new LinkedHashSet<String>(inlineTags);
        metadata.getTags().forEach((key, value) -> allTags.addAll((Collection<String>)value));
        return allTags;
    }

    default public Set<String> inlineTags() {
        return Collections.emptySet();
    }

    default public Map<SchemaEntity, Set<String>> inlineTaggedEntities() {
        return Collections.emptyMap();
    }

    public ParsedSchema copy();

    public ParsedSchema copy(Integer var1);

    public ParsedSchema copy(Metadata var1, RuleSet var2);

    public ParsedSchema copy(Map<SchemaEntity, Set<String>> var1, Map<SchemaEntity, Set<String>> var2);

    default public ParsedSchema normalize() {
        return this;
    }

    default public void validate() {
        this.validate(false);
    }

    default public void validate(boolean strict) {
    }

    public List<String> isBackwardCompatible(ParsedSchema var1);

    default public List<String> isCompatible(CompatibilityLevel level, List<ParsedSchemaHolder> previousSchemas) {
        return CompatibilityChecker.checker(level).isCompatibleWithHolders(this, previousSchemas);
    }

    public Object rawSchema();

    default public boolean hasTopLevelField(String field) {
        throw new UnsupportedOperationException();
    }

    default public boolean deepEquals(ParsedSchema schema) {
        return this.equivalent(schema);
    }

    default public boolean equivalent(ParsedSchema schema) {
        if (this == schema) {
            return true;
        }
        if (schema == null || this.getClass() != schema.getClass()) {
            return false;
        }
        return Objects.equals(this.canonicalString(), schema.canonicalString()) && Objects.equals(this.metadata(), schema.metadata()) && Objects.equals(this.ruleSet(), schema.ruleSet());
    }

    default public Object fromJson(JsonNode json) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public JsonNode toJson(Object object) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public Object copyMessage(Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public Object transformMessage(RuleContext ctx, FieldTransform transform, Object message) throws RuleException {
        throw new UnsupportedOperationException();
    }

    default public Set<String> getReservedFields() {
        if (this.metadata() == null || this.metadata().getProperties() == null || !this.metadata().getProperties().containsKey(RESERVED)) {
            return Collections.emptySet();
        }
        return Arrays.stream(((String)this.metadata().getProperties().get(RESERVED)).split(",")).map(String::trim).filter(field -> !field.isEmpty()).collect(Collectors.toSet());
    }

    default public boolean canLookup(ParsedSchema prev, SchemaVersionFetcher fetcher) {
        if (this.references().isEmpty() && !prev.references().isEmpty() && AbstractSchemaProvider.canLookupIgnoringVersion(this, prev)) {
            return true;
        }
        boolean areRefsEquivalent = AbstractSchemaProvider.replaceLatestVersion(this.references(), fetcher).equals(AbstractSchemaProvider.replaceLatestVersion(prev.references(), fetcher));
        return areRefsEquivalent && AbstractSchemaProvider.canLookupIgnoringVersion(this, prev);
    }
}

