/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Context ID pair")
public class ContextId
implements Comparable<ContextId> {
    private String context;
    private Integer id;

    @JsonCreator
    public ContextId(@JsonProperty(value="context") String context, @JsonProperty(value="id") Integer id) {
        this.context = context;
        this.id = id;
    }

    @JsonProperty(value="context")
    public String getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    public void setContext(String context) {
        this.context = context;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextId schema1 = (ContextId)o;
        return Objects.equals(this.context, schema1.context) && Objects.equals(this.id, schema1.id);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{context=" + this.context + ",");
        sb.append("id=" + this.id + "}");
        return sb.toString();
    }

    @Override
    public int compareTo(ContextId that) {
        int result = this.context.compareTo(that.context);
        if (result != 0) {
            return result;
        }
        result = this.id - that.id;
        return result;
    }
}

