/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.maven.UploadSchemaRegistryMojo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="test-compatibility", configurator="custom-basic")
public class TestCompatibilitySchemaRegistryMojo
extends UploadSchemaRegistryMojo {
    @Parameter(required=false)
    boolean verbose = true;
    Map<String, Boolean> schemaCompatibility = new HashMap<String, Boolean>();

    @Override
    protected boolean processSchema(String subject, ParsedSchema schema, Map<String, Integer> schemaVersions) throws IOException, RestClientException {
        List errorMessages;
        boolean compatible;
        File schemaPath = (File)this.subjects.get(subject);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Calling testCompatibility('%s', '%s')", subject, schema));
        }
        if (compatible = (errorMessages = this.client().testCompatibilityVerbose(subject, schema)).isEmpty()) {
            this.getLog().info((CharSequence)String.format("Schema %s is compatible with subject(%s)", schemaPath, subject));
        } else {
            String errorLog = String.format("Schema %s is not compatible with subject(%s)", schemaPath, subject);
            if (this.verbose) {
                errorLog = errorLog + " with error " + errorMessages.toString();
            }
            this.getLog().error((CharSequence)errorLog);
        }
        this.schemaCompatibility.put(subject, compatible);
        return compatible;
    }

    @Override
    protected String failureMessage() {
        return "One or more schemas found to be incompatible with the current version.";
    }
}

