/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import com.google.common.base.Preconditions;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.maven.MojoUtils;
import io.confluent.kafka.schemaregistry.maven.Reference;
import io.confluent.kafka.schemaregistry.maven.SchemaRegistryMojo;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class UploadSchemaRegistryMojo
extends SchemaRegistryMojo {
    public static final String PERCENT_REPLACEMENT = "_x";
    @Parameter(required=true)
    Map<String, File> subjects = new HashMap<String, File>();
    @Parameter(required=false)
    Map<String, String> schemaTypes = new HashMap<String, String>();
    @Parameter(required=false)
    Map<String, List<Reference>> references = new HashMap<String, List<Reference>>();
    @Parameter(required=false)
    boolean decodeSubject = true;
    Map<String, ParsedSchema> schemas = new HashMap<String, ParsedSchema>();
    Map<String, Integer> schemaVersions = new HashMap<String, Integer>();
    Set<String> subjectsProcessed = new HashSet<String>();
    int errors = 0;
    int failures = 0;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Plugin execution has been skipped");
            return;
        }
        this.errors = 0;
        this.failures = 0;
        if (this.decodeSubject) {
            this.subjects = UploadSchemaRegistryMojo.decode(this.subjects);
            this.schemaTypes = UploadSchemaRegistryMojo.decode(this.schemaTypes);
            this.references = UploadSchemaRegistryMojo.decode(this.references);
        }
        for (String subject : this.subjects.keySet()) {
            this.processSubject(subject, false);
        }
        Preconditions.checkState((this.errors == 0 ? 1 : 0) != 0, (Object)"One or more exceptions were encountered.");
        Preconditions.checkState((this.failures == 0 ? 1 : 0) != 0, (Object)this.failureMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSubject(String key, boolean isReference) {
        if (this.subjectsProcessed.contains(key)) {
            return;
        }
        this.getLog().debug((CharSequence)String.format("Processing schema for subject(%s).", key));
        String schemaType = this.schemaTypes.getOrDefault(key, "AVRO");
        try {
            List<SchemaReference> schemaReferences = this.getReferences(key, this.schemaVersions);
            File file = this.subjects.get(key);
            if (file == null) {
                if (!isReference) {
                    this.getLog().error((CharSequence)("File for " + key + " could not be found."));
                    ++this.errors;
                }
                return;
            }
            String schemaString = MojoUtils.readFile(file, StandardCharsets.UTF_8);
            Optional schema = this.client().parseSchema(schemaType, schemaString, schemaReferences);
            if (!schema.isPresent()) {
                this.getLog().error((CharSequence)("Schema for " + key + " could not be parsed."));
                ++this.errors;
                return;
            }
            this.schemas.put(key, (ParsedSchema)schema.get());
            boolean success = this.processSchema(key, file, (ParsedSchema)schema.get(), this.schemaVersions);
            if (!success) {
                ++this.failures;
            }
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)("Exception thrown while processing " + key), (Throwable)ex);
            ++this.errors;
        }
        finally {
            this.subjectsProcessed.add(key);
        }
    }

    protected static <V> Map<String, V> decode(Map<String, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).contains(PERCENT_REPLACEMENT) ? UploadSchemaRegistryMojo.decode((String)e.getKey()) : (String)e.getKey(), Map.Entry::getValue));
    }

    protected static String decode(String subject) {
        try {
            subject = subject.replaceAll(PERCENT_REPLACEMENT, "%");
            return URLDecoder.decode(subject, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract boolean processSchema(String var1, File var2, ParsedSchema var3, Map<String, Integer> var4) throws IOException, RestClientException;

    protected String failureMessage() {
        return "Failed to process one or more schemas.";
    }

    private List<SchemaReference> getReferences(String subject, Map<String, Integer> schemaVersions) {
        List refs = this.references.getOrDefault(subject, Collections.emptyList());
        ArrayList<SchemaReference> result = new ArrayList<SchemaReference>();
        for (Reference ref : refs) {
            Integer version;
            this.processSubject(ref.subject, true);
            Integer n = version = ref.version != null ? ref.version : schemaVersions.get(ref.subject);
            if (version == null) {
                this.getLog().warn((CharSequence)String.format("Version not specified for ref with name '%s' and subject '%s', using latest version", ref.name, ref.subject));
                version = -1;
            }
            result.add(new SchemaReference(ref.name, ref.subject, version));
        }
        return result;
    }
}

