/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven.derive.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchema;
import io.confluent.kafka.schemaregistry.maven.derive.schema.DeriveSchemaUtils;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DeriveProtobufSchema
extends DeriveSchema {
    public static final String DOUBLE = "double";
    public static final String STRING = "string";
    public static final String BOOL = "bool";
    public static final String INT_32 = "int32";
    public static final String INT_64 = "int64";
    public static final String ANY_FIELD = "google.protobuf.Any";
    public static final String IMPORT_ANY_FIELD = "import \"google/protobuf/any.proto\";\n";
    public static final String FIELD_ENTRY = " %s %s = %d;%n";
    public static final String PROTOBUF_SYNTAX = "syntax = \"proto3\";\n";

    public DeriveProtobufSchema() {
        this.classToDataType.put(DoubleNode.class.getName(), DOUBLE);
        this.classToDataType.put(TextNode.class.getName(), STRING);
        this.classToDataType.put(BigIntegerNode.class.getName(), DOUBLE);
        this.classToDataType.put(IntNode.class.getName(), INT_32);
        this.classToDataType.put(LongNode.class.getName(), INT_64);
        this.classToDataType.put(BooleanNode.class.getName(), BOOL);
        this.classToDataType.put(NullNode.class.getName(), ANY_FIELD);
        this.classToDataType.put(MissingNode.class.getName(), ANY_FIELD);
    }

    @Override
    protected ArrayNode mergeMultipleMessages(List<JsonNode> uniqueSchemas, Map<JsonNode, ArrayNode> schemaToIndex) {
        HashSet<JsonNode> mergedSchemas = new HashSet<JsonNode>();
        ArrayNode schemaInfoList = mapper.createArrayNode();
        for (int i = 0; i < uniqueSchemas.size(); ++i) {
            ArrayNode messagesMatched = mapper.createArrayNode();
            JsonNode mergedSchema = uniqueSchemas.get(i).deepCopy();
            for (JsonNode uniqueSchema : uniqueSchemas) {
                try {
                    mergedSchema = this.mergeArrays(Arrays.asList(mergedSchema, uniqueSchema.deepCopy()), false, false).get("items");
                    messagesMatched.addAll(schemaToIndex.get(uniqueSchema));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (mergedSchemas.contains(mergedSchema)) continue;
            this.updateSchemaInformation(mergedSchema, messagesMatched, schemaInfoList);
            mergedSchemas.add(mergedSchema);
        }
        return schemaInfoList;
    }

    @Override
    protected ObjectNode mergeMultipleDataTypes(ObjectNode mergedArray, List<JsonNode> primitives, List<JsonNode> records, List<JsonNode> arrays, boolean checkElements) {
        ArrayNode items = mapper.createArrayNode();
        if (checkElements) {
            if (arrays.size() > 0) {
                throw new IllegalArgumentException(String.format("Found nested array: %s", arrays));
            }
            if (primitives.stream().anyMatch(o -> o.get("type").asText().equals(ANY_FIELD))) {
                throw new IllegalArgumentException("Repeated field elements cannot be null");
            }
        }
        DeriveSchemaUtils.mergeNumberTypes(primitives);
        items.addAll(DeriveSchemaUtils.getUnique(primitives));
        if (arrays.size() > 0) {
            this.mergeArrays(arrays, true, false);
        }
        items.addAll(DeriveSchemaUtils.getUnique(arrays));
        if (records.size() > 0) {
            items.add((JsonNode)this.mergeRecords(records));
        }
        this.getSingleDataType(mergedArray, items);
        return mergedArray;
    }

    @Override
    protected void checkName(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        if (!name.matches("[a-zA-Z\\d-._]+")) {
            throw new IllegalArgumentException("Name must only contain alphanumerics or one of \"-\", \"_\" and \".\" ");
        }
        if (Character.isDigit(name.charAt(0))) {
            throw new IllegalArgumentException("Name cannot begin with a digit");
        }
    }

    protected TextNode convertToFormat(JsonNode schema, String name) {
        String schemaForRecord = this.convertToFormatRecord(schema, name);
        StringBuilder schemaBuilder = new StringBuilder(PROTOBUF_SYNTAX);
        if (schemaForRecord.contains(ANY_FIELD)) {
            schemaBuilder.append(IMPORT_ANY_FIELD);
        }
        schemaBuilder.append(schemaForRecord);
        ProtobufSchema protobufSchema = new ProtobufSchema(schemaBuilder.toString());
        protobufSchema.validate(false);
        return (TextNode)mapper.convertValue((Object)protobufSchema.toString(), TextNode.class);
    }

    protected String convertToFormatRecord(JsonNode schema, String name) {
        int fieldNum = 1;
        StringBuilder protobufSchema = new StringBuilder();
        protobufSchema.append(String.format("message %s { %n", name));
        JsonNode properties = schema.get("properties");
        block8: for (String fieldName : DeriveSchemaUtils.getSortedKeys(properties)) {
            String fieldType;
            JsonNode field = properties.get(fieldName);
            switch (fieldType = field.get("type").asText()) {
                case "array": {
                    protobufSchema.append(this.convertToFormatArray(field, fieldName, fieldNum++));
                    continue block8;
                }
                case "object": {
                    String recursiveRecord = this.convertToFormatRecord(field, fieldName + "Message");
                    protobufSchema.append(recursiveRecord);
                    protobufSchema.append(String.format(FIELD_ENTRY, fieldName + "Message", fieldName, fieldNum++));
                    continue block8;
                }
            }
            protobufSchema.append(String.format(FIELD_ENTRY, field.get("type").asText(), fieldName, fieldNum++));
        }
        protobufSchema.append("}\n");
        return protobufSchema.toString();
    }

    protected String convertToFormatArray(JsonNode schema, String name, int fieldNum) {
        StringBuilder protobufSchema = new StringBuilder();
        JsonNode items = schema.get("items");
        String itemsType = items.get("type").asText();
        if (itemsType.equals("object")) {
            String recursiveRecord = this.convertToFormatRecord(items, name + "Message");
            protobufSchema.append(recursiveRecord);
            protobufSchema.append(String.format("repeated %s %s = %d;%n", name + "Message", name, fieldNum));
        } else {
            protobufSchema.append(String.format("repeated %s %s = %d;%n", itemsType, name, fieldNum));
        }
        return protobufSchema.toString();
    }
}

