/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.HashMap;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/subjects")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SubjectsResource {
    public static final String MESSAGE_SUBJECT_NOT_FOUND = "Subject not found.";
    private static final Logger log = LoggerFactory.getLogger(SubjectsResource.class);
    private final KafkaSchemaRegistry schemaRegistry;

    public SubjectsResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @POST
    @Path(value="/{subject}")
    @PerformanceMetric(value="subjects.get-schema")
    public void lookUpSchemaUnderSubject(@Suspended AsyncResponse asyncResponse, @HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="Accept") String accept, @PathParam(value="subject") String subject, @NotNull RegisterSchemaRequest request) {
        HashMap<String, String> headerProperties = new HashMap<String, String>();
        headerProperties.put("Content-Type", contentType);
        headerProperties.put("Accept", accept);
        Schema schema = new Schema(subject, Integer.valueOf(0), Integer.valueOf(0), request.getSchema());
        Schema matchingSchema = null;
        try {
            if (!this.schemaRegistry.listSubjects().contains(subject)) {
                throw Errors.subjectNotFoundException();
            }
            matchingSchema = this.schemaRegistry.lookUpSchemaUnderSubject(subject, schema);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while looking up schema under subject " + subject, e);
        }
        if (matchingSchema == null) {
            throw Errors.schemaNotFoundException();
        }
        asyncResponse.resume((Object)matchingSchema);
    }

    @GET
    @Valid
    @PerformanceMetric(value="subjects.list")
    public Set<String> list() {
        try {
            return this.schemaRegistry.listSubjects();
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Error while listing subjects", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while listing subjects", e);
        }
    }
}

