/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

public enum SchemaRegistryKeyType {
    CONFIG("CONFIG"),
    SCHEMA("SCHEMA"),
    NOOP("NOOP");

    public final String keyType;

    private SchemaRegistryKeyType(String keyType) {
        this.keyType = keyType;
    }

    public static SchemaRegistryKeyType forName(String keyType) {
        if (SchemaRegistryKeyType.CONFIG.keyType.equals(keyType)) {
            return CONFIG;
        }
        if (SchemaRegistryKeyType.SCHEMA.keyType.equals(keyType)) {
            return SCHEMA;
        }
        if (SchemaRegistryKeyType.NOOP.keyType.equals(keyType)) {
            return NOOP;
        }
        throw new IllegalArgumentException("Unknown schema registry key type : " + keyType + " Valid key types are {config, schema}");
    }
}

