/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.zookeeper;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class SchemaRegistryIdentity {
    public static int CURRENT_VERSION = 1;
    private Integer version = CURRENT_VERSION;
    private String host;
    private Integer port;
    private Boolean masterEligibility;

    public SchemaRegistryIdentity(@JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="master_eligibility") Boolean masterEligibility) {
        this.host = host;
        this.port = port;
        this.masterEligibility = masterEligibility;
    }

    public static SchemaRegistryIdentity fromJson(String json) throws IOException {
        return (SchemaRegistryIdentity)new ObjectMapper().readValue(json, SchemaRegistryIdentity.class);
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonProperty(value="master_eligibility")
    public boolean getMasterEligibility() {
        return this.masterEligibility;
    }

    @JsonProperty(value="master_eligibility")
    public void setMasterEligibility(Boolean eligibility) {
        this.masterEligibility = eligibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRegistryIdentity that = (SchemaRegistryIdentity)o;
        if (!this.version.equals(that.version)) {
            return false;
        }
        if (!this.host.equals(that.host)) {
            return false;
        }
        if (!this.port.equals(that.port)) {
            return false;
        }
        return this.masterEligibility.equals(that.masterEligibility);
    }

    public int hashCode() {
        int result = this.port;
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.version;
        result = 31 * result + this.masterEligibility.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("version=" + this.version + ",");
        sb.append("host=" + this.host + ",");
        sb.append("port=" + this.port + ",");
        sb.append("masterEligibility=" + this.masterEligibility);
        return sb.toString();
    }

    public String toJson() throws IOException {
        return new ObjectMapper().writeValueAsString((Object)this);
    }
}

