/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.common.config.ConfigDef;
import io.confluent.common.config.ConfigException;
import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.rest.Versions;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.protocol.SecurityProtocol;

public class SchemaRegistryConfig
extends RestConfig {
    private static final int SCHEMAREGISTRY_PORT_DEFAULT = 8081;
    private static final String SCHEMAREGISTRY_LISTENERS_DEFAULT = "";
    @Deprecated
    public static final String KAFKASTORE_SECURITY_PROTOCOL_SSL = "SSL";
    @Deprecated
    public static final String KAFKASTORE_SECURITY_PROTOCOL_PLAINTEXT = "PLAINTEXT";
    public static final String KAFKASTORE_CONNECTION_URL_CONFIG = "kafkastore.connection.url";
    public static final String KAFKASTORE_BOOTSTRAP_SERVERS_CONFIG = "kafkastore.bootstrap.servers";
    public static final String KAFKASTORE_GROUP_ID_CONFIG = "kafkastore.group.id";
    public static final String KAFKASTORE_ZK_SESSION_TIMEOUT_MS_CONFIG = "kafkastore.zk.session.timeout.ms";
    public static final String KAFKASTORE_TOPIC_CONFIG = "kafkastore.topic";
    public static final String DEFAULT_KAFKASTORE_TOPIC = "_schemas";
    public static final String KAFKASTORE_TOPIC_REPLICATION_FACTOR_CONFIG = "kafkastore.topic.replication.factor";
    public static final int DEFAULT_KAFKASTORE_TOPIC_REPLICATION_FACTOR = 3;
    public static final String KAFKASTORE_TIMEOUT_CONFIG = "kafkastore.timeout.ms";
    public static final String KAFKASTORE_INIT_TIMEOUT_CONFIG = "kafkastore.init.timeout.ms";
    public static final String MASTER_ELIGIBILITY = "master.eligibility";
    public static final boolean DEFAULT_MASTER_ELIGIBILITY = true;
    public static final String SCHEMAREGISTRY_ZK_NAMESPACE = "schema.registry.zk.namespace";
    public static final String DEFAULT_SCHEMAREGISTRY_ZK_NAMESPACE = "schema_registry";
    public static final String HOST_NAME_CONFIG = "host.name";
    public static final String COMPATIBILITY_CONFIG = "avro.compatibility.level";
    public static final String ZOOKEEPER_SET_ACL_CONFIG = "zookeeper.set.acl";
    public static final String KAFKASTORE_SECURITY_PROTOCOL_CONFIG = "kafkastore.security.protocol";
    public static final String KAFKASTORE_SSL_TRUSTSTORE_LOCATION_CONFIG = "kafkastore.ssl.truststore.location";
    public static final String KAFKASTORE_SSL_TRUSTSTORE_PASSWORD_CONFIG = "kafkastore.ssl.truststore.password";
    public static final String KAFKASTORE_SSL_KEYSTORE_LOCATION_CONFIG = "kafkastore.ssl.keystore.location";
    public static final String KAFKASTORE_SSL_TRUSTSTORE_TYPE_CONFIG = "kafkastore.ssl.truststore.type";
    public static final String KAFKASTORE_SSL_TRUSTMANAGER_ALGORITHM_CONFIG = "kafkastore.ssl.trustmanager.algorithm";
    public static final String KAFKASTORE_SSL_KEYSTORE_PASSWORD_CONFIG = "kafkastore.ssl.keystore.password";
    public static final String KAFKASTORE_SSL_KEYSTORE_TYPE_CONFIG = "kafkastore.ssl.keystore.type";
    public static final String KAFKASTORE_SSL_KEYMANAGER_ALGORITHM_CONFIG = "kafkastore.ssl.keymanager.algorithm";
    public static final String KAFKASTORE_SSL_KEY_PASSWORD_CONFIG = "kafkastore.ssl.key.password";
    public static final String KAFKASTORE_SSL_ENABLED_PROTOCOLS_CONFIG = "kafkastore.ssl.enabled.protocols";
    public static final String KAFKASTORE_SSL_PROTOCOL_CONFIG = "kafkastore.ssl.protocol";
    public static final String KAFKASTORE_SSL_PROVIDER_CONFIG = "kafkastore.ssl.provider";
    public static final String KAFKASTORE_SSL_CIPHER_SUITES_CONFIG = "kafkastore.ssl.cipher.suites";
    public static final String KAFKASTORE_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_CONFIG = "kafkastore.ssl.endpoint.identification.algorithm";
    public static final String KAFKASTORE_SASL_KERBEROS_SERVICE_NAME_CONFIG = "kafkastore.sasl.kerberos.service.name";
    public static final String KAFKASTORE_SASL_MECHANISM_CONFIG = "kafkastore.sasl.mechanism";
    public static final String KAFKASTORE_SASL_KERBEROS_KINIT_CMD_CONFIG = "kafkastore.sasl.kerberos.kinit.cmd";
    public static final String KAFKASTORE_SASL_KERBEROS_MIN_TIME_BEFORE_RELOGIN_CONFIG = "kafkastore.sasl.kerberos.min.time.before.relogin";
    public static final String KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_JITTER_CONFIG = "kafkastore.sasl.kerberos.ticket.renew.jitter";
    public static final String KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_WINDOW_FACTOR_CONFIG = "kafkastore.sasl.kerberos.ticket.renew.window.factor";
    protected static final String KAFKASTORE_CONNECTION_URL_DOC = "Zookeeper url for the Kafka cluster";
    protected static final String KAFKASTORE_BOOTSTRAP_SERVERS_DOC = "A list of Kafka brokers to connect to. For example, `PLAINTEXT://hostname:9092,SSL://hostname2:9092`\n\nIf this configuration is not specified, the Schema Registry's internal Kafka clients will get their Kafka bootstrap server list\nfrom ZooKeeper (configured with `kafkastore.connection.url`). In that case, all available listeners matching the\n`kafkastore.security.protocol` setting will be used. Note that if `kafkastore.bootstrap.servers` is configured,\n`kafkastore.connection.url` still needs to be configured, too.\n\nThis configuration is particularly important when Kafka security is enabled, because Kafka may expose multiple endpoints that\nall will be stored in ZooKeeper, but the Schema Registry may need to be configured with just one of those endpoints.";
    protected static final String KAFKASTORE_GROUP_ID_DOC = "Use this setting to override the group.id for the KafkaStore consumer.\nThis setting can become important when security is enabled, to ensure stability over the schema registry consumer's group.id\nWithout this configuration, group.id will be \"schema-registry-<host>-<port>\"";
    protected static final String SCHEMAREGISTRY_ZK_NAMESPACE_DOC = "The string that is used as the zookeeper namespace for storing schema registry metadata. SchemaRegistry instances which are part of the same schema registry service should have the same ZooKeeper namespace.";
    protected static final String KAFKASTORE_ZK_SESSION_TIMEOUT_MS_DOC = "Zookeeper session timeout";
    protected static final String KAFKASTORE_TOPIC_DOC = "The durable single partition topic that actsas the durable log for the data";
    protected static final String KAFKASTORE_TOPIC_REPLICATION_FACTOR_DOC = "The desired replication factor of the schema topic. The actual replication factor will be the smaller of this value and the number of live Kafka brokers.";
    protected static final String KAFKASTORE_WRITE_RETRIES_DOC = "Retry a failed register schema request to the underlying Kafka store up to this many times,  for example in case of a Kafka broker failure";
    protected static final String KAFKASTORE_WRITE_RETRY_BACKOFF_MS_DOC = "The amount of time in milliseconds to wait before attempting to retry a failed write to the Kafka store";
    protected static final String KAFKASTORE_INIT_TIMEOUT_DOC = "The timeout for initialization of the Kafka store, including creation of the Kafka topic that stores schema data.";
    protected static final String KAFKASTORE_TIMEOUT_DOC = "The timeout for an operation on the Kafka store";
    protected static final String HOST_DOC = "The host name advertised in Zookeeper. Make sure to set this if running SchemaRegistry with multiple nodes.";
    protected static final String ZOOKEEPER_SET_ACL_DOC = "Whether or not to set an ACL in ZooKeeper when znodes are created and ZooKeeper SASL authentication is configured. IMPORTANT: if set to `true`, the SASL principal must be the same as the Kafka brokers.";
    protected static final String COMPATIBILITY_DOC = "The Avro compatibility type. Valid values are: none (new schema can be any valid Avro schema), backward (new schema can read data produced by latest registered schema), forward (latest registered schema can read data produced by the new schema), full (new schema is backward and forward compatible with latest registered schema)";
    protected static final String MASTER_ELIGIBILITY_DOC = "If true, this node can participate in master election. In a multi-colo setup, turn this off for clusters in the slave data center.";
    protected static final String KAFKASTORE_SECURITY_PROTOCOL_DOC = "The security protocol to use when connecting with Kafka, the underlying persistent storage. Values can be `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.";
    protected static final String KAFKASTORE_SSL_TRUSTSTORE_LOCATION_DOC = "The location of the SSL trust store file.";
    protected static final String KAFKASTORE_SSL_TRUSTSTORE_PASSWORD_DOC = "The password to access the trust store.";
    protected static final String KAFAKSTORE_SSL_TRUSTSTORE_TYPE_DOC = "The file format of the trust store.";
    protected static final String KAFKASTORE_SSL_TRUSTMANAGER_ALGORITHM_DOC = "The algorithm used by the trust manager factory for SSL connections.";
    protected static final String KAFKASTORE_SSL_KEYSTORE_LOCATION_DOC = "The location of the SSL keystore file.";
    protected static final String KAFKASTORE_SSL_KEYSTORE_PASSWORD_DOC = "The password to access the keystore.";
    protected static final String KAFAKSTORE_SSL_KEYSTORE_TYPE_DOC = "The file format of the keystore.";
    protected static final String KAFKASTORE_SSL_KEYMANAGER_ALGORITHM_DOC = "The algorithm used by key manager factory for SSL connections.";
    protected static final String KAFKASTORE_SSL_KEY_PASSWORD_DOC = "The password of the key contained in the keystore.";
    protected static final String KAFAKSTORE_SSL_ENABLED_PROTOCOLS_DOC = "Protocols enabled for SSL connections.";
    protected static final String KAFAKSTORE_SSL_PROTOCOL_DOC = "The SSL protocol used.";
    protected static final String KAFAKSTORE_SSL_PROVIDER_DOC = "The name of the security provider used for SSL.";
    protected static final String KAFKASTORE_SSL_CIPHER_SUITES_DOC = "A list of cipher suites used for SSL.";
    protected static final String KAFKASTORE_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM_DOC = "The endpoint identification algorithm to validate the server hostname using the server certificate.";
    public static final String KAFKASTORE_SASL_KERBEROS_SERVICE_NAME_DOC = "The Kerberos principal name that the Kafka client runs as. This can be defined either in the JAAS config file or here.";
    public static final String KAFKASTORE_SASL_MECHANISM_DOC = "The SASL mechanism used for Kafka connections. GSSAPI is the default.";
    public static final String KAFKASTORE_SASL_KERBEROS_KINIT_CMD_DOC = "The Kerberos kinit command path.";
    public static final String KAFKASTORE_SASL_KERBEROS_MIN_TIME_BEFORE_RELOGIN_DOC = "The login time between refresh attempts.";
    public static final String KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_JITTER_DOC = "The percentage of random jitter added to the renewal time.";
    public static final String KAFKASTORE_SASL_KERBEROS_TICKET_RENEW_WINDOW_FACTOR_DOC = "Login thread will sleep until the specified window factor of time from last refresh to ticket's expiry has been reached, at which time it will try to renew the ticket.";
    private static final boolean ZOOKEEPER_SET_ACL_DEFAULT = false;
    private static final String COMPATIBILITY_DEFAULT = "backward";
    private static final String METRICS_JMX_PREFIX_DEFAULT_OVERRIDE = "kafka.schema.registry";
    private static final ConfigDef config = SchemaRegistryConfig.baseConfigDef().defineOverride("port", ConfigDef.Type.INT, (Object)8081, ConfigDef.Importance.LOW, "DEPRECATED: port to listen on for new HTTP connections. Use listeners instead.").defineOverride("listeners", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.HIGH, "List of listeners. http and https are supported. Each listener must include the protocol, hostname, and port. For example: http://myhost:8080, https://0.0.0.0:8081\n\nSchema Registry identities are stored in ZooKeeper and are made up of a hostname and port. If multiple listeners are configured, the first listener's port is used for its identity.").defineOverride("response.mediatype.preferred", ConfigDef.Type.LIST, (Object)Versions.PREFERRED_RESPONSE_TYPES, ConfigDef.Importance.HIGH, "An ordered list of the server's preferred media types used for responses, from most preferred to least.").defineOverride("response.mediatype.default", ConfigDef.Type.STRING, (Object)"application/vnd.schemaregistry.v1+json", ConfigDef.Importance.HIGH, "The default response media type that should be used if no specify types are requested in an Accept header.").define("kafkastore.connection.url", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Zookeeper url for the Kafka cluster").define("kafkastore.bootstrap.servers", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.MEDIUM, "A list of Kafka brokers to connect to. For example, `PLAINTEXT://hostname:9092,SSL://hostname2:9092`\n\nIf this configuration is not specified, the Schema Registry's internal Kafka clients will get their Kafka bootstrap server list\nfrom ZooKeeper (configured with `kafkastore.connection.url`). In that case, all available listeners matching the\n`kafkastore.security.protocol` setting will be used. Note that if `kafkastore.bootstrap.servers` is configured,\n`kafkastore.connection.url` still needs to be configured, too.\n\nThis configuration is particularly important when Kafka security is enabled, because Kafka may expose multiple endpoints that\nall will be stored in ZooKeeper, but the Schema Registry may need to be configured with just one of those endpoints.").define("schema.registry.zk.namespace", ConfigDef.Type.STRING, (Object)"schema_registry", ConfigDef.Importance.LOW, "The string that is used as the zookeeper namespace for storing schema registry metadata. SchemaRegistry instances which are part of the same schema registry service should have the same ZooKeeper namespace.").define("kafkastore.zk.session.timeout.ms", ConfigDef.Type.INT, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "Zookeeper session timeout").define("kafkastore.topic", ConfigDef.Type.STRING, (Object)"_schemas", ConfigDef.Importance.HIGH, "The durable single partition topic that actsas the durable log for the data").define("kafkastore.topic.replication.factor", ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.HIGH, "The desired replication factor of the schema topic. The actual replication factor will be the smaller of this value and the number of live Kafka brokers.").define("kafkastore.init.timeout.ms", ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The timeout for initialization of the Kafka store, including creation of the Kafka topic that stores schema data.").define("kafkastore.timeout.ms", ConfigDef.Type.INT, (Object)500, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The timeout for an operation on the Kafka store").define("host.name", ConfigDef.Type.STRING, (Object)SchemaRegistryConfig.getDefaultHost(), ConfigDef.Importance.HIGH, "The host name advertised in Zookeeper. Make sure to set this if running SchemaRegistry with multiple nodes.").define("avro.compatibility.level", ConfigDef.Type.STRING, (Object)"backward", ConfigDef.Importance.HIGH, "The Avro compatibility type. Valid values are: none (new schema can be any valid Avro schema), backward (new schema can read data produced by latest registered schema), forward (latest registered schema can read data produced by the new schema), full (new schema is backward and forward compatible with latest registered schema)").define("zookeeper.set.acl", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Whether or not to set an ACL in ZooKeeper when znodes are created and ZooKeeper SASL authentication is configured. IMPORTANT: if set to `true`, the SASL principal must be the same as the Kafka brokers.").define("master.eligibility", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, "If true, this node can participate in master election. In a multi-colo setup, turn this off for clusters in the slave data center.").defineOverride("metrics.jmx.prefix", ConfigDef.Type.STRING, (Object)"kafka.schema.registry", ConfigDef.Importance.LOW, "Prefix to apply to metric names for the default JMX reporter.").define("kafkastore.security.protocol", ConfigDef.Type.STRING, (Object)SecurityProtocol.PLAINTEXT.toString(), ConfigDef.Importance.MEDIUM, "The security protocol to use when connecting with Kafka, the underlying persistent storage. Values can be `PLAINTEXT`, `SSL`, `SASL_PLAINTEXT`, or `SASL_SSL`.").define("kafkastore.ssl.truststore.location", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "The location of the SSL trust store file.").define("kafkastore.ssl.truststore.password", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "The password to access the trust store.").define("kafkastore.ssl.truststore.type", ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, "The file format of the trust store.").define("kafkastore.ssl.trustmanager.algorithm", ConfigDef.Type.STRING, (Object)"PKIX", ConfigDef.Importance.LOW, "The algorithm used by the trust manager factory for SSL connections.").define("kafkastore.ssl.keystore.location", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "The location of the SSL keystore file.").define("kafkastore.ssl.keystore.password", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "The password to access the keystore.").define("kafkastore.ssl.keystore.type", ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, "The file format of the keystore.").define("kafkastore.ssl.keymanager.algorithm", ConfigDef.Type.STRING, (Object)"SunX509", ConfigDef.Importance.LOW, "The algorithm used by key manager factory for SSL connections.").define("kafkastore.ssl.key.password", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "The password of the key contained in the keystore.").define("kafkastore.ssl.enabled.protocols", ConfigDef.Type.STRING, (Object)"TLSv1.2,TLSv1.1,TLSv1", ConfigDef.Importance.MEDIUM, "Protocols enabled for SSL connections.").define("kafkastore.ssl.protocol", ConfigDef.Type.STRING, (Object)"TLS", ConfigDef.Importance.MEDIUM, "The SSL protocol used.").define("kafkastore.ssl.provider", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The name of the security provider used for SSL.").define("kafkastore.ssl.cipher.suites", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "A list of cipher suites used for SSL.").define("kafkastore.ssl.endpoint.identification.algorithm", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "The endpoint identification algorithm to validate the server hostname using the server certificate.").define("kafkastore.sasl.kerberos.service.name", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The Kerberos principal name that the Kafka client runs as. This can be defined either in the JAAS config file or here.").define("kafkastore.sasl.mechanism", ConfigDef.Type.STRING, (Object)"GSSAPI", ConfigDef.Importance.MEDIUM, "The SASL mechanism used for Kafka connections. GSSAPI is the default.").define("kafkastore.sasl.kerberos.kinit.cmd", ConfigDef.Type.STRING, (Object)"/usr/bin/kinit", ConfigDef.Importance.LOW, "The Kerberos kinit command path.").define("kafkastore.sasl.kerberos.min.time.before.relogin", ConfigDef.Type.LONG, (Object)60000, ConfigDef.Importance.LOW, "The login time between refresh attempts.").define("kafkastore.sasl.kerberos.ticket.renew.jitter", ConfigDef.Type.DOUBLE, (Object)0.05, ConfigDef.Importance.LOW, "The percentage of random jitter added to the renewal time.").define("kafkastore.sasl.kerberos.ticket.renew.window.factor", ConfigDef.Type.DOUBLE, (Object)0.8, ConfigDef.Importance.LOW, "Login thread will sleep until the specified window factor of time from last refresh to ticket's expiry has been reached, at which time it will try to renew the ticket.").define("kafkastore.group.id", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Use this setting to override the group.id for the KafkaStore consumer.\nThis setting can become important when security is enabled, to ensure stability over the schema registry consumer's group.id\nWithout this configuration, group.id will be \"schema-registry-<host>-<port>\"");
    private final AvroCompatibilityLevel compatibilityType;

    public SchemaRegistryConfig(Map<? extends Object, ? extends Object> props) throws RestConfigException {
        super(config, props);
        String compatibilityTypeString = this.getString(COMPATIBILITY_CONFIG);
        this.compatibilityType = AvroCompatibilityLevel.forName((String)compatibilityTypeString);
        if (this.compatibilityType == null) {
            throw new RestConfigException("Unknown Avro compatibility level: " + compatibilityTypeString);
        }
    }

    public SchemaRegistryConfig(String propsFile) throws RestConfigException {
        this(SchemaRegistryConfig.getPropsFromFile((String)propsFile));
    }

    public SchemaRegistryConfig(Properties props) throws RestConfigException {
        super(config, (Map)props);
        String compatibilityTypeString = this.getString(COMPATIBILITY_CONFIG);
        this.compatibilityType = AvroCompatibilityLevel.forName((String)compatibilityTypeString);
        if (this.compatibilityType == null) {
            throw new RestConfigException("Unknown Avro compatibility level: " + compatibilityTypeString);
        }
    }

    private static String getDefaultHost() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new ConfigException("Unknown local hostname", (Object)e);
        }
    }

    public static void main(String[] args) {
        System.out.println(config.toRst());
    }

    public AvroCompatibilityLevel compatibilityType() {
        return this.compatibilityType;
    }
}

