/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import io.confluent.kafka.schemaregistry.storage.DeleteSubjectValue;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.MD5;
import io.confluent.kafka.schemaregistry.storage.SchemaIdAndSubjects;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.Store;
import io.confluent.kafka.schemaregistry.storage.StoreUpdateHandler;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStoreMessageHandler
implements StoreUpdateHandler<SchemaRegistryKey, SchemaRegistryValue> {
    private static final Logger log = LoggerFactory.getLogger(KafkaStoreMessageHandler.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final Store store;

    public KafkaStoreMessageHandler(KafkaSchemaRegistry schemaRegistry, Store store) {
        this.schemaRegistry = schemaRegistry;
        this.store = store;
    }

    @Override
    public void handleUpdate(SchemaRegistryKey key, SchemaRegistryValue value) {
        if (key.getKeyType() == SchemaRegistryKeyType.SCHEMA) {
            this.handleSchemaUpdate((SchemaKey)key, (SchemaValue)value);
        } else if (key.getKeyType() == SchemaRegistryKeyType.DELETE_SUBJECT) {
            this.handleDeleteSubject((DeleteSubjectValue)value);
        }
    }

    private void handleDeleteSubject(DeleteSubjectValue deleteSubjectValue) {
        String subject = deleteSubjectValue.getSubject();
        Integer deleteTillVersion = deleteSubjectValue.getVersion();
        for (int version = 1; version <= deleteTillVersion; ++version) {
            try {
                SchemaKey schemaKey = new SchemaKey(subject, version);
                SchemaValue schemaValue = (SchemaValue)this.store.get(schemaKey);
                schemaValue.setDeleted(true);
                this.store.put(schemaKey, schemaValue);
                continue;
            }
            catch (StoreException e) {
                log.error("Failed to delete subject in the local store");
            }
        }
    }

    private void handleSchemaUpdate(SchemaKey schemaKey, SchemaValue schemaObj) {
        MD5 md5;
        SchemaIdAndSubjects schemaIdAndSubjects;
        this.schemaRegistry.guidToSchemaKey.put(schemaObj.getId(), schemaKey);
        if (this.schemaRegistry.getMaxIdInKafkaStore() < schemaObj.getId()) {
            this.schemaRegistry.setMaxIdInKafkaStore(schemaObj.getId());
        }
        if ((schemaIdAndSubjects = this.schemaRegistry.schemaHashToGuid.get(md5 = MD5.ofString(schemaObj.getSchema()))) == null) {
            schemaIdAndSubjects = new SchemaIdAndSubjects(schemaObj.getId());
        }
        schemaIdAndSubjects.addSubjectAndVersion(schemaKey.getSubject(), schemaKey.getVersion());
        this.schemaRegistry.schemaHashToGuid.put(md5, schemaIdAndSubjects);
    }
}

