/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectKey;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectValue;
import io.confluent.kafka.schemaregistry.storage.NoopKey;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKeyType;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.SerializationException;
import io.confluent.kafka.schemaregistry.storage.serialization.Serializer;
import java.io.IOException;
import java.util.Map;

public class SchemaRegistrySerializer
implements Serializer<SchemaRegistryKey, SchemaRegistryValue> {
    @Override
    public byte[] serializeKey(SchemaRegistryKey key) throws SerializationException {
        try {
            return new ObjectMapper().writeValueAsBytes((Object)key);
        }
        catch (IOException e) {
            throw new SerializationException("Error while serializing schema key" + key.toString(), e);
        }
    }

    @Override
    public byte[] serializeValue(SchemaRegistryValue value) throws SerializationException {
        try {
            return new ObjectMapper().writeValueAsBytes((Object)value);
        }
        catch (IOException e) {
            throw new SerializationException("Error while serializing value schema value " + value.toString(), e);
        }
    }

    @Override
    public SchemaRegistryKey deserializeKey(byte[] key) throws SerializationException {
        SchemaRegistryKey schemaKey = null;
        Enum keyType = null;
        try {
            try {
                Map keyObj = null;
                keyObj = (Map)new ObjectMapper().readValue(key, (TypeReference)new TypeReference<Map<Object, Object>>(){});
                keyType = SchemaRegistryKeyType.forName((String)keyObj.get("keytype"));
                if (keyType == SchemaRegistryKeyType.CONFIG) {
                    schemaKey = (SchemaRegistryKey)new ObjectMapper().readValue(key, ConfigKey.class);
                } else if (keyType == SchemaRegistryKeyType.NOOP) {
                    schemaKey = (SchemaRegistryKey)new ObjectMapper().readValue(key, NoopKey.class);
                } else if (keyType == SchemaRegistryKeyType.DELETE_SUBJECT) {
                    schemaKey = (SchemaRegistryKey)new ObjectMapper().readValue(key, DeleteSubjectKey.class);
                } else if (keyType == SchemaRegistryKeyType.SCHEMA) {
                    schemaKey = (SchemaRegistryKey)new ObjectMapper().readValue(key, SchemaKey.class);
                    this.validateMagicByte((SchemaKey)schemaKey);
                }
            }
            catch (JsonProcessingException e) {
                String type = "unknown";
                if (keyType != null) {
                    type = keyType.name();
                }
                throw new SerializationException("Failed to deserialize " + type + " key", e);
            }
        }
        catch (IOException e) {
            throw new SerializationException("Error while deserializing schema key", e);
        }
        return schemaKey;
    }

    @Override
    public SchemaRegistryValue deserializeValue(SchemaRegistryKey key, byte[] value) throws SerializationException {
        SchemaRegistryValue schemaRegistryValue = null;
        if (key.getKeyType().equals((Object)SchemaRegistryKeyType.CONFIG)) {
            try {
                schemaRegistryValue = (SchemaRegistryValue)new ObjectMapper().readValue(value, ConfigValue.class);
            }
            catch (IOException e) {
                throw new SerializationException("Error while deserializing config", e);
            }
        } else if (key.getKeyType().equals((Object)SchemaRegistryKeyType.SCHEMA)) {
            try {
                this.validateMagicByte((SchemaKey)key);
                schemaRegistryValue = (SchemaRegistryValue)new ObjectMapper().readValue(value, SchemaValue.class);
            }
            catch (IOException e) {
                throw new SerializationException("Error while deserializing schema", e);
            }
        } else if (key.getKeyType().equals((Object)SchemaRegistryKeyType.DELETE_SUBJECT)) {
            try {
                schemaRegistryValue = (SchemaRegistryValue)new ObjectMapper().readValue(value, DeleteSubjectValue.class);
            }
            catch (IOException e) {
                throw new SerializationException("Error while deserializing Delete Subject message", e);
            }
        } else {
            throw new SerializationException("Unrecognized key type. Must be one of schema or config");
        }
        return schemaRegistryValue;
    }

    @Override
    public void close() {
    }

    public void configure(Map<String, ?> stringMap) {
    }

    private void validateMagicByte(SchemaKey schemaKey) throws SerializationException {
        if (schemaKey.getMagicByte() != 0 && schemaKey.getMagicByte() != 1) {
            throw new SerializationException("Can't deserialize schema for the magic byte " + schemaKey.getMagicByte());
        }
    }
}

